/* catgets.h */

/* A hack that allows me to compile internationalized X/Open (UNIX)
   programs on DOS.  The catgets() call just returns the default
   string. */

/* I will update this to be "real" when I can use Steffen Kaiser's
   MSGLIB library as the backend. */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _CATGETS_H
#define _CATGETS_H

/* Symbolic constants */

#define MCLoadBySet		0			/* flag */
#define MCLoadAll		0			/* flag */


/* Functions */


/* catopen - opens a message catalog, returns a catalog descriptor */

int
catopen (const char *name, int flag);

/* catclose - closes a message catalog */

void
catclose (int cat);

/* catgets - returns the message matching mesg_id from set_id in
   catalog cat, or returns def_string if not found. */

char *
catgets (int cat, int set_id, int mesg_id, const char *def_string);

#endif /* _CATGETS_H */
