#ifndef THECURSE_H				/* prevent loading twice */
#define THECURSE_H

/* $Id: thecurse.h,v 1.1.1.1 1998/06/10 03:36:47 jhall Exp $ */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* This is a library for Borland C, which simulates UNIX curses.  This
   is intended only to aid software ports from UNIX to Borland C.  I
   am NOT trying to re-implement curses for Borland. */


#include <stdio.h>				/* same as UNIX curses */
#include <conio.h>				/* Borland conio library */

#include "curs_key.h"				/* curses KEY compatibility */
#include "curs_acs.h"				/* curses ACS compatibility */


/* Symbolic constants for OK and ERR */

#define OK 1
#define ERR 0


/* globals */

#ifndef THECURSE_C
extern int COLS;				/* the standard PC screen */
extern int LINES;
#endif /* THECURSE_C */

/* functions */

int initscr (void);
int endwin (void);
int move (int y, int x);
int addch (int ch);
int mvaddch (int y, int x, int ch);
int addstr (const char *str);
int mvaddstr (int y, int x, char *str);
int refresh (void);
int standout (void);
int standend (void);
int clrtoeol (void);
int erase (void);
int clear (void);
int beep (void);
int flash (void);

#endif /* THECURSE_H */
