/* $Id: mvaddnch.c,v 1.1.1.1 1998/06/10 03:36:47 jhall Exp $ */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* mvaddnch - move to an x,y and paint n instances of a character.
   This will also handle line-wrap correctly.  */

#ifdef unix
#include <curses.h>
#else
#include "thecurse.h"
#endif

int
cur_mvaddnch (int y, int x, int n, int ch)
{
  int i;
  int j;

  /* paint */

  move (y, x);

  for (i = 0, j = x; i < n; i++) {
    addch (ch);

    if (++j >= COLS) {
      /* we have reached the right column.  move to next line */

      j = x;
      move (++y, x);
    }
  } /* for */

  /* return success */

  return (OK);
}
