/* $Id: dsc_desc.c,v 1.1 1998/08/11 02:39:54 jhall Exp $ */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>				/* for strncmp */
#include <ctype.h>				/* for isspace */

#define STRLEN 128

int
dsc_summary (const char *dscfile)
{
  /* Displays the Summary line in a Debian Package Description file
     (.dsc file).  Returns the number of lines that were printed. */

  /* dscfile is the name of a '.dsc' file. */

  FILE *stream;
  char s[STRLEN];
  int len;
  int n;
  int is_summ_line;

  /* Open the file */

  stream = fopen (dscfile, "r");
  if (stream == NULL) {
    return 0;
  }

  /* Read the dscfile until done */

  n = 0;

  while (fgets (s, STRLEN, stream) != NULL) {
    /* Look only at first part of the string for 'Description:'.
       Assumes that we are case-sensitive, and that the field name
       appears at the start of the string. */

    if (strncmp (s, "Description:", 12) == 0) {
      /* Yes, we have a match. */
      /* Now print a summary line */

      printf ("%s", s);
      n++;
    }
  } /* while */

  /* Close the file */

  fclose (stream);
  return (n);
}

int
dsc_description (const char *dscfile)
{
  /* Displays the Description lines in a Debian Package Description
     file (.dsc file).  Returns the number of lines that were
     printed. */

  /* dscfile is the name of a '.dsc' file. */

  FILE *stream;
  char s[STRLEN];
  int len;
  int n;
  int is_desc_line;
  int is_blank;

  /* Open the file */

  stream = fopen (dscfile, "r");
  if (stream == NULL) {
    return 0;
  }

  /* Read the dscfile until done */

  n = 0;
  is_desc_line = 0;

  while (fgets (s, STRLEN, stream) != NULL) {
    /* If the line is empty, this is the end of the desc */

    for (len = 0, is_blank = 1; s[len] != '\0'; len++) {
      if (!isspace(s[len])) {
	is_blank = 0;
      }
    } /* for */

    if (is_blank) {
      is_desc_line = 0;
    }

    /* As an added test, see if another paragraph starts here, without
       the expected blank line in between. */

    if (!isspace(s[0])) {
      is_desc_line = 0;
    }

    /* If this is part of the description, print it */

    if (is_desc_line) {
      n++;
      printf ("%s", s);
    }

    /* Look for the 'Description:' flag.  Assumes that we are case-
       sensitive, and that the flag appears at the start of the
       string. */

    if (strncmp (s, "Description:", 12) == 0) {
      is_desc_line = 1;
    }

  } /* while */

  /* Close the file */

  fclose (stream);
  return (n);
}
