/* showdesc.c - Show the description lines for a particular name from
a file.  Assume the description file is laid out like this:

   name1: description1
   name1: description2
   name1: description3
   name2: description1
   name2: description2

More than one package name is allowed per description file. */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <string.h>				/* for strtok */

#define STRLEN 256


int
showdesc (const char *name, const char *file)
{
  /* Prints all lines from a file that match a descriptive name (as
     the first token).  Returns the number of lines printed, or <0 if
     an error.  This function does not care about how many lines it
     prints, and DOES NOT PAUSE AFTER EACH SCREENFUL. */

  FILE *stream;
  char s[STRLEN];
  char cp[STRLEN];
  int n;

  /* Read the file until done */

  if (!(stream = fopen (file, "r"))) {
    /* Cannot open file */

    return (-1);
  }

  /* Read the file until done */

  n = 0;
  while (fgets (s, STRLEN, stream) != NULL) {
    /* Check the first token for a match with name. */

    strcpy (cp, s);

    /* Compiler dependency here: comparing two strings with strcmp is
       okay - this is part of the ANSI standard.  However, comparing
       two strings WITHOUT REGARD TO CASE is not ANSI C. */

#ifdef __BORLANDC__
    if (strcmpi (name, strtok (s, " :")) == 0) {
#else
    if (strcasecmp (name, strtok (s, " :")) == 0) {
#endif
      /* A match - print the entire line.  strtok changes 's', so we
         need to print a copy of the original string. */

      printf ("%s", cp);
      n++;
    }
  } /* while */

  /* Done */

  fclose (stream);
  return (n);
}
