#ifdef unix
#include <curses.h>
#else
#include "thecurse.h"
#endif

/* this is a test program, which does very little except run through
   some basic curses routines.  use this as a portability experiment
   between curses/UNIX and dcurses/DOS. */

int
main ()
{
  /* start curses */

  initscr();

#ifdef unix
  cbreak();
  noecho();
#endif

  /* Most programs would additionally use the sequence: */

#ifdef unix
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
#endif

  /* erase the screen, and print a message */

  erase();
  standout();
  mvaddstr (5, 10, "this is 5,10");
  mvaddstr (8, 60, "this is 8,60");
  standend();

  beep();
  mvaddstr (LINES-1, 50, "press any key to exit");
  refresh();

  getch();

  /* exit curses */

  erase();
  refresh();

  endwin();

  /* end the program */

  exit (0);
}
