/* $Id: cat.c,v 1.1 1998/03/11 03:36:14 jhall Exp $ */

/* Copyright (C) 1997, James Hall, <jhall1@isd.net> */

/* This is free software.  See the file COPYING for details. */

#include <stdio.h>

int
cat (const char *filename)
{
  /* Concatenate a file to stdout.  Returns non-zero (true) if
     successful, or zero (false) if failed. */

  FILE *stream;
  int ch;

  /* Open the file */

  if ((stream = fopen (filename, "r")) == NULL) {
    /* Failed to open */

    return (0);
  }

  /* Now concatenate the file to stdout */

  while ((ch = fgetc (stream)) != EOF) {
    putchar(ch);
  }

  /* Done.  Close the file and return */

  fclose (stream);
  return (1);
}
