/* $Id: basecmp.c,v 1.3 1998/04/02 03:41:31 jhall Exp $ */

/* A function to compare a file name "mask" against a string.  Return
   value is the same as strcmp.  Under UNIX, the strings are compared
   case sensitively.  Under other platforms, the strings are compared
   without regard to case. */

#include <stdio.h>
#include <ctype.h>				/* for tolower */

int
basecmp (const char *mask, const char *s)
{
  /* If mask does not contain a '.', then only compare s until the
     dot.  Otherwise, if mask does have a '.', compare the whole
     thing. */

  int i;
  int c1, c2;

  for (i = 0; mask[i] != '\0'; i++) {
    /* Compare the characters */

#if defined(unix)
#  if defined(TEST)
    printf ("UNIX\n");
#  endif /* TEST */

    c1 = mask[i];
    c2 = s[i];
#else
    c1 = tolower (mask[i]);
    c2 = tolower (s[i]);
#endif

    /* Note that if c1 is a dot, then c2 must be a dot also, or else
       the strings do not match anyway.  So we do not need to make a
       special test for c1 == '.' here. */

    /* if not same, return <0 if mask less than s or >0 if mask
       greater than s*/

    if (c1 != c2) {
      return (c1 - c2);
    }
  } /* for */

  /* At this point, we have reached the end of mask, and all the
     characters in mask and s match okay. */

  /* Test if we are also at the end of s. */

  if (s[i] == '\0') {
    return (0);
  }

#if !defined(unix)
  /* Not at the end of s.  But is s[i] a dot? */

  if (s[i] == '.') {
    return (0);
  }
#endif /* unix */

  /* Not at end of s.  But is s[i] a space? */

  if (s[i] == ' ') {
    return (0);
  }

  /* s is still a string.  The strings do not match */

  return (1);
}

#if defined(TEST)
int
main(int argc, char **argv)
{
  int i;
  int ret;

  /* Tests the first argument against the remaining arguments, using
     basecmp. */

  /* Check usage */

  if (argc < 3) {
    /* There is one, or zero, arguments.  Not enough. */

    fprintf (stderr, "%s - tests the basecmp() function against its input\n\n", argv[0]);
    fprintf (stderr, "Error: Not enough arguments.\n");
    fprintf (stderr, "Usage: %s \"mask\" string..\n", argv[0]);
    exit (1);
  }

  /* Test all strings */

  for (i = 2; i < argc; i++) {
    printf ("\n\n");

    ret = basecmp (argv[1], argv[i]);

    if (ret == 0) {
      printf ("The strings match!\n");
    }

    else if (ret < 0) {
      printf ("%s was less than %s\n", argv[1], argv[i]);
    }

    else {
      printf ("%s was greater than %s\n", argv[1], argv[i]);
    }

    printf ("The strings were:\n");
    printf ("%s\n%s\n", argv[1], argv[i]);
  } /* for */

  exit (0);
}
#endif /* TEST */
