/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
#define GETOPTG
/* $RCSfile: getoptg.c,v $
   $Locker:  $	$Name: DOSTEST_1_2 $	$State: Exp $

   Free-DOS Function Library GETOPT.C - Returns command line options
   Written by Steffen Kaiser
   Based upon: Morgan "Hannibal" Toal,
    based upon original source by James Hall
   Compiler: MICRO-C 3.13/3.14/ARROWASM/VALLINK
   			 Borland C 2,3,4

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

/*
	This is a generic source text to create all forms of the getopt()
	function. This is controlled by the following #define's:
		GETOPT1			to generate getopt1()
		GETOPT2			to generate getopt2()
		GETOPTG			to generate getoptG()
		none of them	to generate getopt()

		getopt():	original
			- accept two option classes: argumented, non-argumented
			- options are marked with SWCHAR (hard coded)
			- arguments are delimited by ARGCHAR (hard coded)
			- arguments must not be empty
			- options must not fall into two classes
			- a SWCHAR within an option string is ignored

		getopt1():	as getopt() except:
			- options may fall into mor than one option class
			- arguments may be empty
			- options are marked either by SWCHAR or SWCHAR1 (hard coded)
			- arguments are marked either by ARGCHAR or ARGCHAR1 (hard coded)
			- non-argumented options may be controlled by a boolean state
				character '+' or '-' (hard coded). The character must
				immediately follow the switchar, e.g.:
					/+x
				but not:
					/x+y

		getopt2():	as getopt1() except:
			- third option class: /x*
				with:	/		an option indicator
						x		the option character
						*		the option argument (may be empty)
				This class is overridden by the argumented class, if
				the first character of '*' is an argument indicator.

		getoptG():	generic getopt(), as getopt2() except:
			- option indicator characters stored in a string
			- argument indicator characters stored in a string
			- boolean state characters stored in a string
			- controlled by flags:
				-- completely handled options will be marked as empty options
					A '\0' character will be placed behind the switch
					character.
				-- skipping of non-option command line arguments
					Those two flags allow to completely scan the command line
					for options, then, in a second pass, process the non-option
					arguments.
				-- skipping of following command line arguments
					This allows options in tar-style:
						tar -cBf 512 dummy.tar files
					where "512" belongs to "-B",& "dummy.tar" to "-f".
					While processing the options of "-cBf" the variable
					optFlags can be incremented to indicate, that the
					next argument(s) are already used up. Setting
					(optFlags & GETOPT_ADVANCE) to "2" causes the two
					arguments "512" and "dummy.tar" to be skipped and
					getoptG() will continue scanning for options with
					the argument "files".
					There can be a maximum of GETOPT_ADVANCE arguments
					to be skipped!
*/

#include <msglib.h>
#include <msglib.dcl>	/* because we have no local messages
							source in the global message declarations */
#ifndef _MICROC_
#include <ctype.h>
#include <string.h>
#endif
#include "getopt.h"

#define ARGCHAR '='
#define SWCHAR '/'

#define ARGCHAR1 ':'
#define SWCHAR1 '-'

#ifdef X_GETOPT1
#undef X_GETOPT1
#endif
#ifdef X_GETOPT2
#undef X_GETOPT2
#endif
#ifdef O_GETOPT
#undef O_GETOPT
#endif

#ifdef GETOPT1
int getopt1(int argc, char *argv[], char *opt1st, char *opt2nd)
#define isArg(c) ((c) == ARGCHAR || (c) == ARGCHAR1)
#define isOpt(c) ((c) == SWCHAR || (c) == SWCHAR1)
#define X_GETOPT1
#else
#ifdef GETOPT2
int getopt2(int argc, char *argv[], char *opt1st, char *opt2nd, char *opt3rd)
#define isArg(c) ((c) == ARGCHAR || (c) == ARGCHAR1)
#define isOpt(c) ((c) == SWCHAR || (c) == SWCHAR1)
#define GETOPT1
#define X_GETOPT1
#define X_GETOPT2
#else
#ifdef GETOPTG
int getoptG(int argc, char *argv[])
/* external references: opt1st		-- options
						opt2nd     	-- argoptions
						opt3rd		-- thirdoptions
						optFlags
						optSWCHAR	-- switch characters
						optARGCHAR	-- argument characters
						optBOOL		-- set/clear characters
*/
#define isArg(c) strchr(optARGCHAR, c)
#define isOpt(c) strchr(optSWCHAR, c)
#define X_GETOPT1
#define X_GETOPT2
#else
int getopt (int argc, char *argv[], char *opt1st, char *opt2nd)
#define isArg(c) ((c) == ARGCHAR)
#define isOpt(c) ((c) == SWCHAR)
#define O_GETOPT
#endif
#endif
#endif

{	char *p;		/* pointer to current option string */
    int c;			/* current uppercased option character */

	if(optchar < 2) {		/* check the first option in this argument? */
		optchar = 0;
#ifdef GETOPTG
		optind += optFlags & GETOPT_ADVANCE;
		optFlags &= ~GETOPT_ADVANCE;
#endif
	}

	c = 0;
    while(!c && optind < argc) {
		p = argv[optind];
/* If the current argv is a switch (i.e. starts with SWCHAR)... */

        if(isOpt(p[0])) {
        	if(optchar == 0) {	/* 1st time that this option string is checked */
				optarg = NULL;
				if((c = toupper(p[optchar = 1])) != 0) {
#ifdef X_GETOPT2
					if(strchr(opt3rd, c)) {
						optarg = p + 2;		/* 3rd character leads argument */
						goto nxtArg;	/* Advance to next arg, then break */
					}
#endif
#ifdef X_GETOPT1
#ifdef GETOPTG
					if(strchr(optBOOL, c))
#else
					if(c == '+' || c == '-')	/* set/clear sign */
#endif
					{	c = toupper(p[optchar = 2]);	/* next option */
						optarg = p + 1;			/* save the set/clear sign */
					}
#endif
				}
				else {
					c = '?';		/* return '?' as original getopt() does */
					goto nxtArg;	/* advance to next arg, than break */
				}
			}
			else c = toupper(p[optchar]);

#ifdef GETOPTG
			if(!(optFlags & GETOPT_NOHELPSCREEN))
#endif
			if(c == '?')
				hlpScreen();

			if(c) {			/* there is an option */
				/* check for an argumented option */
				if(p[++optchar] && isArg(p[optchar])) {	/* argument found */
					if(strchr(opt2nd, c)) {			/* OK, argumented option */
						optarg = p + optchar + 1;
#ifdef O_GETOPT			/* original getopt() denies empty arguments */
						if(!*optarg)
							error(E_argMissing, c);
#endif
						goto nxtArg;	/* advance to next arg, then break */
					}
#ifdef O_GETOPT			/* original getopt() performs a check */
					if(strchr(opt1st, c))
						error(E_nonArgOption, c);
#endif
				}

				/* no argument found */
#ifdef O_GETOPT			/* original getopt() performs a check */
				if(strchr(opt2nd, c))
					error(E_argOption, c);
#endif
				if(strchr(opt1st, c)) {	/* option found */
					return c;			/* return this option */
				}
				error(E_option, c);		/* option not found */
			}
			/* else		no option found => advance to next arg */
        }
        else {		/* not an option string => return EOF */
#ifdef GETOPTG
			if(!(optFlags & GETOPT_IGNORE))		/* not ignore non-options */
				return EOF;
#else
			return EOF;
#endif
        }

        /* advance to next argument */
nxtArg:
        ++optind, optchar = 0;
#ifdef GETOPTG
		if(optFlags & GETOPT_MARKEMPTY)
			p[1] = '\0';
#endif
	}

	return c? c: EOF;		/* nothing found */
}
