/* main.c - The guts of the Free-DOS Install program. */

/* Copyright (C) 1997, James Hall <jhall1@isd.net> */

/* This is free software.  See the file COPYING for details */


#include <stdio.h>
#include <stdlib.h>				/* for free() */
#include "dat.h"
#include "getkey.h"
#include "pause.h"
#include "showdesc.h"
#include "inst.h"


/* Symbolic constants */

#define STRLEN 256

#define DAT_FILE "INSTALL.DAT"
#define DESC_FILE "INSTALL.TXT"

int
main(void)
{
  char from[STRLEN];				/* where to install from */
  char exdir[STRLEN];				/* where to install to */
  int i;
  int dsk_ser_n;				/* Size of disk series ary */
  dat_t *dsk_ser;				/* The disk series array */

  /* Say hello. */

  printf ("-- Free-DOS Install --\n\n");
  printf ("Copyright (C) 1997, James Hall <jhall1@isd.net>\n");
  printf ("This is free software.  See the file COPYING for details.\n\n");

  /* Read the package list */

  if (!(dsk_ser = dat_read (DAT_FILE))) {
    /* Failed */

    fprintf (stderr, "install: Can't find %s\n", DAT_FILE);
    exit (1);
  }

  dsk_ser_n = dat_ary_size;

  /* Find out where to install from/to */

  printf ("Install from what path? ");
  if (gets (from) == NULL) {
    strcpy (from, "A:\\");
  }

  printf ("Install files to what path? ");
  if (gets (exdir) == NULL) {
    strcpy (exdir, "C:\\");
  }

  /* Print the package list */

  printf ("\n\n");
  printf ("You are about to install these disk series:\n");

  for (i = 0; i < dsk_ser_n; i++) {
    printf ("%s ", dsk_ser[i].fname);
  }
  printf ("\n\n");

  printf ("The install program will now let you install these disk series.  With\n");
  printf ("each series, you will be able to choose which to install and which to\n");
  printf ("skip.  Each disk series consists of several package files.  You can\n");
  printf ("also select which individual packages to install and which to skip.\n");
  printf ("Note that some disk series and package files may already be selected\n");
  printf ("for you.\n\n");

  /* Allow the user to bail out */

  if (!pause ()) {
    /* Quit */

    exit (0);
  }

  /* Ask which series to install */

  for (i = 0; i < dsk_ser_n; i++) {
    /* Show the description */

    printf ("\n\n");;
    showdesc (dsk_ser[i].fname, DESC_FILE);

    /* Find out which ones the user wants to install */

    switch (dsk_ser[i].rank) {
    case 'n':
    case 'N':
      /* Do not install */

      printf ("%s [SKIPPED]\n", dsk_ser[i].fname);
      dsk_ser[i].resp = 0;
      break;

    case 'y':
    case 'Y':
      /* Always install */

      printf ("%s [REQUIRED]\n", dsk_ser[i].fname);
      dsk_ser[i].resp = 1;
      break;

    default:
      /* Optional */

      printf ("%s [OPTIONAL]\n", dsk_ser[i].fname);

      /* Ask the user if you want to install it */

      dsk_ser[i].resp = instyn (dsk_ser[i].fname);
      break;

    } /* switch */
  } /* for */

  /* Run the install */

  printf ("\n\n");
  printf ("Installing the software ...\n");

  for (i = 0; i < dsk_ser_n; i++) {
    if (dsk_ser[i].resp) {
      instser (dsk_ser[i].fname, from, exdir);
    } /* if */
  } /* for */

  /* Done */

  free (dsk_ser);

  printf ("\n\n");;
  printf ("The install program completed successfully.\n");

  exit (0);
}
