;*****************************************************************************
;**                  c't  --  magazin fuer computer technik                 **
;*****************************************************************************
;**                     Ausgabe   08/90   ab Seite   214                    **
;**                                                                         **
;** original author and copyright                                           **
;**   (c) 1990 c't/Harald Albrecht                                          **
;**                                                                         **
;** created the v86 monitor part and EMS functions                                                                        **
;**                                                                         **
;**                                                                         **
;**        1990 Thomas Gloeckler - Rechenzentrum FH Ulm                     **
;** significant enhancements (DMA+fixes)                                    **
;**                                                                         **
;**                                                                         **
;** put into current shape as a potential EMM386 (EMM386-VCPI-DPMI-...)     **
;**   (c)  2001  tom.ehlert@ginko.de                                        **
;**                                                                         **
;**                                                                         **
;**                                                                         **
;**  for better understanding of the code history                           **                                     **
;**                                                                         **
;**  lowercase                                                              **
;**  	mov ax,bx                                                           **
;**  and english comments are my (tom ehlert) contribution                  **
;**                                                                         **
;**  UPPER case                                                             **
;**     MOV AX,BX                                                           **
;**  and german comments are generally the original (c't / Harald Albrecht) **
;**  where however                                                          **
;**  I may have cut/copy/pasted ... things around                           **
;**                                                                         **
;**                                                                         **
;**  11/23/2001  tom ehlert                                                 **
;**                                                                         **
;*****************************************************************************
		TITLE   V86 - Virtueller 8086-Monitor fuer 80386er PCs
		NAME    V86
;
;                          V 8 6        Version 1.34


;
; (c) 1990 c't/Harald Albrecht
; (c) 2001 tom.ehlert@ginko.de
;
;     T A S M 1.0 / 1.01
;     TC 2.01
;
; Virtueller 8086-Monitor, der den PC nach dem Starten im virtuellen
; 8086er- Betriebsmodus betreibt.
; **** #### Aanderungen der V 1.4 gegenueber Heftversion V1.3 sind
; **** #### hierdurch gekennzeichnet, als da sind:
; **** #### zusaetzliche Abfrage bei der Installation auf EMMXXXX0,
; **** #### da einige BIOSse den INT 67h besetzen
; **** #### Fehler bei der Abfrage nach der Kennung 'ct' beseitigt
; **** #### Das Extended Memory wird nun nicht mehr grundsaetzlich
; **** #### vollstaendig belegt, ueber EXT kann man den freibleibenden
; **** #### Rest vorgeben.
; **** #### STack als Klassenname fuer Stack-Segmenr fuer TLINK 3.0
;
; Durch Einsetzen der entsprechenden Erweiterungen an den mit (*-1-*) usf.
; markierten Stellen ergibt sich:
;
;**** ####  E M M    Version 1.4
;           LIM-EMS-Treiber fuer 386er PCs (EMS Version 3.2)
;
; (c) 1989 Harald Albrecht
;
;(#-0-#)
; Durch Einsetzen der Erweiterungen (#-1-#) usf. wird die DMA-Unterstuetzung
; installiert.
;
;       DMA-Unterstuetzung &  Die Wilde Dreizehn    Version 1.0
;
; (c) 1990 Harald Albrecht
;(#-0-#)
;
		.386P
		.SEQ                         ; Unbedingt Reihenfolge der Segment-
									 ; Definitionen einhalten !!!

		public _MAXPAGES
		public _FRAME
		public _startup_verbose

		LOCALS

LF              EQU 0AH
CR              EQU 0DH

V86_TOS         EQU 400H             ; Groesse des Monitor-Stacks

; **** ##### geaendert um ggf. Platz im Extended Speicher freizuhalten
EXT             EQU 14*1024	             ; hier kann man die freibleibende
										 ; Groesse in KB eingeben






PORT_A          EQU 60H              ; Datenport des 8042
STATUS_PORT     EQU 64H                   ; Statusport des 8042

@KB_FLAG        EQU 417H             ; Status SHIFT/CTRL/ALT usw.
@KB_FLAG_3      EQU 496H                 ; u.a. 0E0h/0E1h
@RESET_FLAG     EQU 472H                  ; Flag fuer Warmstart (=1234h)

; GDT - Selektoren im Global Descriptor Table
NULL_SEL        EQU 00H              ; Null-Descriptor
V86_LDT_SEL     EQU 08H                   ; Local Descriptor Table Selector
V86_TSS_SEL     EQU 10H                   ; Task State Segment des Monitors
TMP_TSS_SEL     EQU 18H                   ; Kurzzeitig benoetigtes TSS
REAL_SEL        EQU 20H              ; Codesegment fuer die Rueckkehr zum
										 ; REAL-Mode
REAL_DATA_SEL   EQU 28H              ; dto. Datensegment
UNIVERSE_SEL    EQU 30H                    ; 4-GByte-Datensegment

; LDT - Selektoren im Local Descriptor Table
V86_CODE_SEL    EQU 0CH                    ; Code-Segment virtueller 86-Monitor
V86_DATA_SEL    EQU 14H                    ; dto. Daten-Segment (DATA)
V86_STACK_SEL   EQU 1CH              ; dto. Stack-Segment (STACK)

;(#-1-#)
DMA_BUFF_SIZE   EQU     64              ; Groesse DMA-Buffer in kBytes

BasePrgrd       EQU      0              ; 0 - Adresse programmiert
LenPrgrd        EQU      1              ; 0 - Blocklaenge programmiert
PagePrgrd       EQU      2              ; 0 - Seitenregister prgrmmrt
ModePrgrd       EQU      3              ; 0 - Modusregister prgrmmrt

INT13Activ      EQU      0              ; INT 13h ist aktiv
INT40Activ      EQU      1              ; dto. INT 40h
NeedBuffer      EQU      2              ; DMA-Transfer via Buffer
HiLoFlag1       EQU     14              ; Hi-Byte adressieren, DMA #1
HiLoFlag2       EQU     15              ; dto., DMA-Controller #2

REPCMD  MACRO CMD,OP                     ;; Befehl mit unterschiedlichen
		IRP     OPERAND,<&OP>           ;; Operanden wiederholen
		CMD     OPERAND
		ENDM
		ENDM
;(#-1-#)

; Macro zur Umgehung des 386-Bugs bei 32-Bit-Stringoperationen
; betrifft nur Maskenversion B3
; Adressgroessen-Prefix + NOP anhaengen

BIG_NOP MACRO
		DB 67h    ;  32-Bit-Prefix
		NOP
		ENDM
;
;
; Macro zur Beschreibung von Descriptoren
;
SELECTOR MACRO BEGIN,LIMIT,ACCESS,GRANULARITY
		DW      LIMIT                   ;; Groesse des Segments (15..0)
		DW      BEGIN                   ;; Beginn des Segments (15..0)
		DB      0                    ;; Beginn (23..16)
		DB      ACCESS
		DB      GRANULARITY          ;; u.a. Groesse (19..16)
		DB      0                    ;; Beginn (31..24)
		ENDM


DRIVERCODE SEGMENT PARA USE16
DRIVERCODE ENDS


; Der Stack bleibt ebenfalls resident, da er waehrend der Rueckkehr zum
; REAL-Mode vor der Beendigung des fehlerausloesenden Prozesses benoetigt
; wird.
; no return to realmode ever wanted, no res_stack
RES_STACK  SEGMENT  PARA USE16
;        DB      V86_TOS DUP (?)  ; Platz fuer den Stack
;TOS     LABEL   WORD
RES_STACK  ENDS


RESCODE SEGMENT PARA USE16
RESCODE ENDS

DATA    SEGMENT PARA USE16
DATA    ENDS

CODE    SEGMENT PARA USE16
CODE 	ENDS

V86     SEGMENT PARA USE16
V86 	ENDS

_TEXT	segment	PARA public 'CODE' use16
_TEXT	ends

_DATA	segment word public 'DATA' use16
_DATA	ends

_BSS	segment word public 'BSS'  use16
_BSS	ends

_STACK	segment STACK  'STACK' use16
_STACK	ends

DGROUP	group	_DATA,_BSS,_STACK


TMP_STACK SEGMENT STACK PARA USE16
TMP_STACK ENDS


DRIVERCODE SEGMENT PARA USE16
		ASSUME  CS:DRIVERCODE,DS:NOTHING,ES:NOTHING,FS:NOTHING,GS:NOTHING

;******************************************************************************
; device driver header

device_header:
		dd  -1          ; last driver in list
		dw  0c000h      ; driver flags : 
						; 8000 - character device
						; 4000 - supports IOCTL - like EMM386
		dw  offset strategy     ; pointer to strategy routine
		dw  offset interrupt    ; pointer to interrupt handler
		db  'EMMXXXX0'      ; device driver name


;******************************************************************************
; strategy routine. is called by DOS to initialize the driver once.
; only thing to be done here is to store the address of the device driver
; request block.
; In:   ES:BX - address of request header
; Out:  nothing

public interrupt,strategy,device_header

request_ptr dd  0           ; pointer to request header

strategy:
	mov word ptr cs:[request_ptr+2],es  ; store segment addr
	mov word ptr cs:[request_ptr],bx    ; store offset addr
	retf                 ; far return here!

interrupt:
	;int 3			; trigger driver entry for debugging purpose

					; this driver assumes, it is called once
					; with cmd = INIT
					;
					; this one request is fullfilled, then then
					; every other denied
	push es
	push di

	les di,cs:[request_ptr]          ; load address of request header

	mov          es:[di+0eh+2],cs    ; set end address
	mov word ptr es:[di+0eh  ],0	 ;
	mov word ptr es:[di+3	 ],0800h ; STATUS_OK


	call far ptr go_driver_entry	 ; this will be patched
									; away after init
									; so ALL following request are simply OK'ed

	pop di
	pop es
	retf

;*********************************************************
; an UMB handler
; good enough for FreeDOS=UMB, for nothing else :-)
;*********************************************************

public _UMBhandler, _UMBOldhandler

_UMBhandler:

	jmp short TheUMBHandler		; standard XMS link chain
	nop                         ; with 3 required NOPs
	nop
	nop
TheUMBHandler:
	cmp ah,4					; global disable A20
	je  global_disable_a20
	cmp ah,6					; local disable A20
	je  local_disable_a20
	 
	cmp ah,010h					; UMBallocate
	je  UMBallocate				;
								; else let the others return
								; 'not implemented'


not_for_us:
	db 0eah						; jmp far  UMBoldhandler
_UMBoldhandler dd 0



; dull and stupid - we neither reallocate nor free

;UMBfree:
;UMBreallocate:
;	mov bl,080h			; not implemented
;	mov ax,0			; failure
;	retf




;
;	REALLY dull and stupid - we manage exactly four UMB blocks
;   no UMBfree
;   no UMBrealloc
;   no largest size UMB size in alloc
;
;	but it's
;   feel free to do it better
;   this is filled in by C code
;

public _UMBsegments
_UMBsegments dd 0
			dd 0
			dd 0
			dd 0


UMBallocate:

	xor ax,ax
								; find first available memory block
	lea bx, cs:[_UMBsegments]
	cmp word ptr cs:[bx],ax
	jne  @@UMBfound
	add bx, 4
	cmp word ptr cs:[bx],ax
	jne  @@UMBfound
	add bx, 4
	cmp word ptr cs:[bx],ax
	jne  @@UMBfound
	add bx, 4
	cmp word ptr cs:[bx],ax
	je no_umbs_available


@@UMBfound:
	mov	ax,dx				; size wanted
	mov dx,cs:[bx+2]		; dx = size of (largest) available

	cmp ax,dx				; enough memory available ??
	ja  umb_too_small

	mov  ax,cs:[bx]
	mov  word ptr cs:[bx],0
	mov  bx,ax
	mov  ax,1
	retf


umb_too_small:
	mov ax,0
	mov bl,0B0h	; only smaller UMB available
	retf


no_umbs_available:
	mov bl,0B1h	; no UMB's are available
	retf


;
; we do not want to have A20 disabled - we need it !
; so we don't do anything - and even say SUCCESS - like WinNT DOSBOX
;

global_disable_a20:
local_disable_a20:
	mov ax,1
	mov bl,0
	retf



;*******************************************
; prints text after call
; we rely on DOS to satisfy INT 29
;*******************************************

__print proc near

print_1char:
				int 29h

print2:			pop   bx
	   		    pop   si                       ; this is the first character
				lodsb                          ; get token
				push  si               			; stack up potential return address	
				push  bx
				                       
				cmp   al, 0                    ; end of string?
				jne   print_1char              ; until done
				ret

	
print:
	call print2
	ret





;*******************************************
; printing routines
; we rely on DOS to satisfy INT 29
;
; print
;   db 'hello world'
;
; printdh,printdx - what the name implies
;
; printhex, printhexd
;   'ds=',0    'eax=',0
;
;*******************************************

printdx:
				call printdh
				ror  dx,8

printdh:
				call printnibble
printnibble:				

				ror dh,4
				
				
				mov al,dh

				and al,0fh
				add al,'0'
				cmp al,'9'                  
				jbe nohex
				add al,'A'-'0' - 10
nohex:

				int 29h
				ret


printhex:
				call print2

				mov al,'='
				int 29h

printhex2:
				call printdx

				mov al,' '
				int 29h

				ret                            ; and jump to it
           
           
printhexd: 		call print2

				mov al,'='
				int 29h
                
                ror edx,16

				call printdx

                ror edx,16
                
                jmp printhex2


__print endp


;*********************************************************************
;
; illegal instruction executed
; print some diagnostic
; end program
;
; if int21/4c returns (during device init or more regularily
; for command.com), there is nothing left do to. show 'I am alive'
; and wait for '3FingerSalut'
;*********************************************************************

	public	_IllegalOpcodeHandler
_IllegalOpcodeHandler proc FAR

		; flags 36
		; CS    34
		; IP    32
	
		push es ;30
		push ds ;28
		push ebp ;24
		push edi ;20
		push esi ;16
		push edx ;12
		push ecx ;8
		push ebx ;4
		push eax ;0
	
		mov bp,sp
		push cs
		pop  ds


		call print
		db CR,LF,LF,'Illegal Instruction occurred',CR,LF,0


		mov dx,[bp+34]
		call printhex
		db 'CS',0

		mov dx,[bp+32]
		call printhex
		db 'IP',0

		mov dx,ss
		call printhex
		db 'SS',0

		mov dx,bp
		add dx, 38
		call printhex
		db 'SP',0

		mov dx,[bp+26]
		call printhex
		db 'DS',0

		mov dx,[bp+28]
		call printhex
		db 'ES',0


		mov edx,[bp]
		call printhexd
		db CR,LF,'EAX',0

		mov edx,[bp+4]
		call printhexd
		db 'EBX',0

		mov edx,[bp+8]
		call printhexd
		db 'ECX',0

		mov dx,[bp+12]
		call printhexd
		db 'EDX',0

		mov dx,[bp+16]
		call printhexd
		db CR,LF,'ESI',0

		mov dx,[bp+20]
		call printhexd
		db 'EDI',0


		mov dx,[bp+24]
		call printhexd
		db 'EBP',0

		call print
		db CR,LF,'Opcodes @CS:IP ',0

		les di,	[bp+32]		; CS:IP

		mov cx,8
hexdloop:
		push cx
		mov dh, es:[di]
		inc di
		call printdh
		call print
		db ' ',0
		pop cx
		loop hexdloop


	call print
	db CR,LF,'Aborting program',CR,LF,0

	sti
	mov ax,04c7fh
	int 21h

					; and if we tried to abort command.com
	sub dx,dx
stopit: sti
		call printhex
		db CR,'?cmd?',0
		inc dx


	jmp stopit		; should be never executed

_IllegalOpcodeHandler	endp

DRIVERCODE ENDS

;*********************************************************************

RESCODE SEGMENT
		ASSUME  CS:RESCODE,DS:NOTHING,ES:NOTHING,FS:NOTHING,GS:NOTHING

RETURN_OF_THE_86 PROC FAR
		CLI                          ; Keine Ruhestoerung !
		MOV     AX,REAL_DATA_SEL          ; Die On-Chip-Registercaches der
		MOV     DS,AX                    ; Segmentregister mit den Attributen
		MOV     ES,AX                    ; des REAL-Mode laden (wer jetzt noch
		MOV     FS,AX                    ; MOV CS,AX schreiben wollte, sollte
		MOV     GS,AX                    ; sich aber schaemen!)
		MOV     SS,AX

		MOV     EAX,CR0                    ; CR0-Register auslesen, um nun das
		AND     EAX,7FFFFFFEH           ; PE- Bit (Protected Mode Enable)
		MOV     CR0,EAX                    ; und evtl. Paging auszuschalten
		XOR     EAX,EAX                    ; Aus Sicherheitsgruenden nun noch den
		MOV     CR3,EAX                    ; TLB loeschen !
		JMP     FAR PTR FLUSH           ; Die Prefetch-Queue loeschen und die
FLUSH   LABEL   FAR                  ; Attribute fuer CS neu setzen
		MOV     AX,SEG DATA          ; DS neu laden, damit auch die Lage
		MOV     DS,AX                    ; der Interrupt-Tabelle sowie deren
		ASSUME  DS:DATA              ; Groesse
		LIDT    FWORD PTR [INTS_86]  ; neu gesetzt werden kann.
;        MOV     AX,SEG RES_STACK           ; Der Stack muss nun auch wieder neu
;        MOV     SS,AX                    ; angelegt werden (im residenten Teil
;        MOV     SP,OFFSET TOS           ; unterhalb 1 MB)
		JMP     FAR PTR BACK_TO_REALITY
RETURN_OF_THE_86 ENDP
;
; (Fortsetzung der Rueckkehr aus dem Protected Mode)
; Eine Fehlermeldung ausgeben (Nummer in DX)
;
BACK_TO_REALITY PROC FAR
	db 0eah,0,0,0ffh,0ffh		; jmp ffff:0
BACK_TO_REALITY endp

RESCODE ENDS


;
; Der Datenbereich des Monitor- & EMS-Programms
;

DATA    SEGMENT PARA USE16
		ASSUME  CS:DATA
;(*-2-*)
		DB      10 DUP (0)
Kennung DB      'EMMXXXX0'               ; Kennung des EMM-Treibers
		DB      'c''t_EMM'         ; Kennung fuer ct_EMM

DUMMY_CALL:                                ; Falls Software (u.a. TURBO Pascal
		INT     67H                  ; Programme) auf die Idee kommt, via
		IRET                         ; CS:IP aus der Interrupt-Tabelle den
										 ; EMM aufzurufen, EMM nun tatsaechlich
										 ; aufrufen !

;******************************************************************************
; INT15 handler:
;    everything forwarded to old handler, except int15/87 = move_memory
;
;******************************************************************************
;(*-2-*)
NEW15 PROC FAR
		CMP     AH,87H               	; is it a blockmove ?
		JZ      SHORT @@do_int1587 	 	;
		JMP     CS:DWORD PTR [OLDINT15] ; else forward to default handler
@@NO_MOVE:

;
; suggested by eric auer - and I like the idea (it's easy to implement)
;	it's easiest (for the moment), to change
;   the int15/87 into a magic, undocumented int67/87 function,
;   which is handled by the 'normal' int67 handler
;
; 	although not 100% efficient, as this will require 2 transitions
; 	DOS int15 --> V86 --> this code --> int67 --> done
;
;
;INT 15 - SYSTEM - COPY EXTENDED MEMORY
;
;        AH = 87h
;        CX = number of words to copy (max 8000h)
;        ES:SI -> global descriptor table (see #0403)
;Return: CF set on error
;        CF clear if successful
;        AH = status (see #0402)

@@do_int1587:
		MOV     AH,087h
		int 067h

		clc
		test ah,ah
		jz @@ok
		STC
		STI
@@ok:
		RET 2
NEW15 ENDP
;******************************************************************************

;MSG00   DB      CR,LF,'Virtuelle 8086-Betriebsart verlassen und zum REAL-'
;        DB      'Mode zurueckgekehrt.',CR,LF,'$'
;MSG01   DB      CR,LF,'$'
;MSG08   DB      'INT 08h: Doppelfehler (Gates - Wozniak 5-3 6-3 2-5 6-2)$'
;MSG09   DB      'INT 09h: x87 - Limitueberschreitung durch Operand$'
;MSG0A   DB      'INT 0Ah: Ungueltiges Task State Segment$'
;MSG0B   DB      'INT 0Bh: Segment nicht physikalisch vorhanden$'
;MSG0C   DB      'INT 0Ch: Stack-Fehler$'
;MSG0D   DB      'INT 0Dh: Generelle Sicherheitsverletzung$'
;MSG0E   DB      'INT 0Eh: Seite nicht physikalisch vorhanden$'
;MSG0F   DB      'INT 0Fh: hoppla, gibt''s eigentlich nicht$'
; MSG99   DB      CR,LF,'A20 kann nicht gesperrt werden!$'

;(#-3-#)
BaseAdr         DW      8 DUP (?)       ; Beginn Block der DMA-Kanaele
BlockLen        DW      8 DUP (?)       ; dto. Laenge des Blocks
PageReg         DB      8 DUP (?)       ; Pageregister
ChanFlags       DW      8 DUP (?)       ; div. Flags fuer Kanaele
Flags           DW      0               ; globale Flags

TargetAdr       DD      ?               ; Originaladresse fuer DMA
BuffStart       DD      ?               ; Beginn des DMA-Buffers
BuffLen         DD      ?               ; Benutzter Teil des Buffers

PageLookUp      DB      0,2,3,1,0,0,0,0,0,6,7,5,0,0,0,0
PageXLat        DB      87H,83H,81H,82H,0,8BH,89H,8AH

OLD13           DD      ?               ; Adresse des alten INT 13h
OLD40           DD      ?               ; dto. des alten INT 40h




;
; Kontrolle des INT 13h sowie INT 40h wegen der DMA-Unterstuetzung
;
NEW13 PROC FAR
		BTS     CS:[Flags],INT13Activ   ; Jetzt geht's rund.
		BTR     CS:[Flags],NeedBuffer   ; Lieber immer ausschalten.
		PUSH    ECX
		MOV     ECX,8                   ; Die Statusbits teilweise
@@Loop: MOV     CS:[ChanFlags+ECX*2-2],1100B ; = ModePrgrd+PagePrgrd
		LOOP    @@Loop                  ; initialisieren.
		POP     ECX
		PUSHF                           ; Dann nun den alten INT
		CALL    DWORD PTR CS:[OLD13]    ; aufrufen. Falls ein Fehler
		PUSHF                           ; eintritt, ... nix is !
		JC      @@Bye
		BTR     CS:[Flags],NeedBuffer   ; Muss der Buffer noch zurueck-
		JNC     @@Bye                   ; kopiert werden ?
HLT13:  HLT                             ; Hallo, 32-Bit Welt !
@@Bye:  BTR     CS:[Flags],INT13Activ   ; Bye bye (Flags wurden geret-
		POPF                            ; tet, da BTR CY-Flag loescht !)
		RETF    2                       ; Zurueck mit den Flags
NEW13 ENDP

NEW40 PROC FAR
		BTS     CS:[Flags],INT40Activ   ; Jetzt geht's rund.
		BTR     CS:[Flags],NeedBuffer   ; Lieber immer ausschalten.
		PUSH    ECX
		MOV     ECX,8                   ; Die Statusbits teilweise
@@Loop: MOV     CS:[ChanFlags+ECX*2-2],1100B ; = ModePrgrd+PagePrgrd
		LOOP    @@Loop                  ; initialisieren.
		POP     ECX
		PUSHF                           ; Dann nun den alten INT
		CALL    DWORD PTR CS:[OLD40]    ; aufrufen. Falls ein Fehler
		PUSHF                           ; eintritt, ... nix is !
		JC      @@Bye
		BTR     CS:[Flags],NeedBuffer   ; Muss der Buffer noch zurueck-
		JNC     @@Bye                   ; kopiert werden ?
HLT40:  HLT                             ; Hallo, 32-Bit Welt !
@@Bye:  BTR     CS:[Flags],INT40Activ   ; Bye bye (Flags wurden geret-
		POPF                            ; tet, da BTR CY-Flag loescht !)
		RETF    2                       ; Zurueck mit den Flags
NEW40 ENDP
;(#-3-#)

		ALIGN   4
;MSGTAB  DW      MSG08,MSG09,MSG0A,MSG0B,MSG0C,MSG0D,MSG0E,MSG0F

PSP             DW      ?            ; PSP des Programms
OLDINT15        DD      ?                  ; Adresse des alten INT 15h

INTS_86         DW      3FFH         ; Groesse und Lage der Interrupttabelle
				DD      0            ; (IDT) im REAL-Mode
IDT_PTR         DW      7FFH         ; Groesse und Lage IDT im Pro
				DW      OFFSET IDT,0 ; (Wird spaeter noch angepasst !)
GDT_PTR         DW      GDT_LEN  ; dto. GDT
				DW      OFFSET GDT,0

;(*-3-*)
OLDINT67        DD      ?                  ; Alter EMM-Vektor
;EXTMEM          DW      ?                 ; Extended Memory in kBytes
public 	_MONITOR_ADDR
_MONITOR_ADDR   DD  100000H +EXT*1024   ; Beginn des Monitor-Codes

public _EMM_MEMORY_END              	; end of memory for EMM
_EMM_MEMORY_END dd 0

public _TOTAL_MEMORY					; highest physical adress in maschine
_TOTAL_MEMORY	dd      0

public PAGEDIR
PAGEDIR         DD      ?                  ; ^ auf Page Directory (spaeter CR3)

public FIRSTPAGE
FIRSTPAGE       DD      ?            ; ^ auf erste verfuegbare EMS-Seite

STATUSTABLE     DD      ?            ; ^ auf Zustandstabelle fuer Handles
EMSPAGETABLE    DD      ?            ; ^ auf Belegungstabelle der
_MAXPAGES        DW      ?                  ; EMS-Seiten Maximal verfuegbare
PAGESAVAIL      DW      ?            ; EMS-Seiten momentan verfuegbare
_FRAME          DW      0D000H       ; EMS-Seiten Segmentadresse des
FRAMEANCHOR     DD      ?            ; EMS-"Fensters" ^ auf Eintrag in
PHYSPAGETABLE   DW      4 DUP (-1)   ; Page Table Aktuell eingeblendete
										 ; Seiten

							; Flag to enable/disable special
							; handling of INT67/44 (MAP_PAGE)
							; during init phase, abused to map UMB everywhere
	public _INIT_DONE							
_INIT_DONE		db		0			; reset after initialization

_startup_verbose db 0				; more (debug) output in Init Phase 




;(*-3-*)
;
; GDT - Global Descriptor Table. Diese Tabelle enthaelt die Beschreibungen
; aller "oeffentlichen" Daten-, Code-, LDT- und Task-Segmente
;
		ALIGN   4
GDT     LABEL BYTE
  DQ            0                                          ; NULL-Eintrag
  SELECTOR <OFFSET LDT>,LDT_LEN,82H,0               ; LDT-Descriptor
  SELECTOR <OFFSET TSS>,TSS_LEN,89H,0               ; TSS V86
  SELECTOR <OFFSET TMP_TSS>,TMP_TSS_LEN,89H,0 ; Temporaeres TSS
  SELECTOR 0,0FFFFH,9AH,0                   ; "Normales" Codesegment (64k)
  SELECTOR 0,0FFFFH,92H,0                   ; "Normales" Datensegment mit
												 ; REAL-Attributen
  DW 0FFFFH,0                               ; 4-GByte-Adressraum
  DB 0,92H,0C0H+0FH,0
GDT_LEN EQU     $-GDT
;
; LDT - Local Descriptor Table. Diese Tabelle enthaelt das Code-, Daten-
; und Stack-Segment exklusiv fuer den virtuellen Monitor (daher DPL = 0).
;
LDT     LABEL BYTE
  DQ            0                                ; NULL-Eintrag
  SELECTOR 0,V86_LEN,09AH,0              ; Code-Segment V86  (16 Bit) use32
  SELECTOR 0,WHOLE_DATA_LEN,92H,0    ; Daten-Segment V86 (16 Bit)
  SELECTOR 0,V86_TOS,92H,0              ; Stack-Segment V86 (16 Bit)
LDT_LEN EQU     $-LDT
		PURGE   SELECTOR

public DATA_END
DATA_END        EQU     $            ; Ende des residenten Teils


;
; Es folgt nun die Interrupt-Tabelle (IDT), die die "Gates" fuer Exceptions
; oder Interrupts im Protected Mode enthaelt. Zu beachten: Damit die Ver-
; arbeitung ordnungsgemaess erfolgen kann, muss DPL = 3 gelten !
;
IDT_ENTRY_O MACRO SEQNR              ;; Leider wird nur auf diese Weise
		DW      OFFSET INT&SEQNR         ;; der Symbolname INTxx richtig
		ENDM                         ;; erzeugt.

IDT_ENTRY MACRO VON,BIS              ;; Interrupt Gates erzeugen
		LOCAL   ENTRY
ENTRY   =       VON
		REPT    BIS-VON+1
		IDT_ENTRY_O %(ENTRY)               ;; Offset 15..0 des Ziels
		DW      V86_CODE_SEL         ;; Code-Segment-Selektor des Ziels
		DB      0,0EEH                   ;; Interrupt Gate (DPL=3, 32 Bit)
		DW      0                    ;; Offset 31..16
ENTRY   =       ENTRY+1
		ENDM
		ENDM

IDT     LABEL BYTE
		IDT_ENTRY 00H,0FFH               ; Interrupt-Tabelle
IDT_LEN EQU     $-IDT
		PURGE   IDT_ENTRY,IDT_ENTRY_O
;
; TSS - primaeres Task State Segment; wird waehrend der Initialisierung
; benoetigt, um durch Taskwechsel den 86er-Monitor zu aktivieren.
; (Genaugenommen wird kein einziges Byte benoetigt, nur der 386 ist mit
; der blossen Existenz schon zufrieden.)
;
TMP_TSS LABEL BYTE
		DW      0,0                  ; Back Link fuer verschachtelte Tasks
		DD      V86_TOS                   ; Level 0 Stack
		DW      V86_STACK_SEL,0
		DD      0,0                  ; Level 1 Stack
		DD      0,0                  ; Level 2 Stack
		DD      0                    ; CR3 (fuer Paging)
		DW      OFFSET V86_START,0       ; EIP
		DD      0                    ; EFLAGS (IF = 0)
		DD      0,0,0,0                   ; EAX/EBX/ECX/EDX
		DD      V86_TOS                   ; ESP
		DD      0,0,0                   ; EBP/ESI/EDI
		DW      V86_DATA_SEL,0          ; ES
		DW      V86_CODE_SEL,0          ; CS
		DW      V86_STACK_SEL,0  ; SS
		DW      V86_DATA_SEL,0          ; DS
		DW      V86_DATA_SEL,0          ; FS
		DW      V86_DATA_SEL,0          ; GS
		DW      V86_LDT_SEL,0        ; LDT
		DW      0                    ; Debug-Bit 0
		DW      $+2-TMP_TSS          ; Offset I/O-Erlaubnis-Bitmap rel.
										 ; TSS Es ist keine I/O erlaubt
TMP_TSS_LEN     EQU     $-TMP_TSS
;
; TSS - Task State Segment des Monitor-Programms (hier endet zugleich der
; residente Teil des Programmes, der Rest wird teilweise in den
; Bereich verlagert, um den Speicherplatz MSDOS' zu schonen.)
;
DATA_LEN        EQU     OFFSET $
;
; Diese TSS wird allerdings wirklich benoetigt!
;
TSS     LABEL BYTE
		DW      0,0                  ; Back Link fuer verschachtelte Tasks
		DD      V86_TOS                   ; Level 0 Stack
		DW      V86_STACK_SEL,0
		DD      0,0                  ; Level 1 Stack
		DD      0,0                  ; Level 2 Stack
		DD      0                    ; CR3 (fuer Paging)
		DW      OFFSET V86_START,0       ; EIP
		DD      0                    ; EFLAGS (IF = 0)
		DD      0,0,0,0                   ; EAX/EBX/ECX/EDX
		DD      V86_TOS                   ; ESP
		DD      0,0,0                   ; EBP/ESI/EDI
		DW      V86_DATA_SEL,0          ; ES
		DW      V86_CODE_SEL,0          ; CS
		DW      V86_STACK_SEL,0  ; SS
		DW      V86_DATA_SEL,0          ; DS
		DW      V86_DATA_SEL,0          ; FS
		DW      V86_DATA_SEL,0          ; GS
		DW      V86_LDT_SEL,0        ; LDT
		DW      0                    ; Debug-Bit 0
		DW      $+2-TSS                   ; Offset I/O-Erlaubnis-Bitmap rel.

;**********************************************************************

;(#-4-#)
Comment $
;(#-4a-#)
DB      10000H/8 DUP (0)        ; TSS ALLE I/O-Adressen erlaubt, ohne DMA!
;(#-4a-#)
$
;*********************************************************************
;       geaendert fuer I/O-Kontrolle der DMA-Ports
; Die Zeile "DB 10000H/8 DUP (0)" direkt vor dieser neuen Anpassung muss
; entweder geloescht oder auskommentiert werden !!
;
		DB      11111111B,00011000B     ; DMA-Controller #1
		DB      14 DUP (0)
		DB      10001110B,00001110B     ; Seitenregister
		DB      6 DUP (0)
		DB      11111111B,11111111B,01000000B ; DMA-Controller #2
		DB      00000001B               ; dto.
		DB      (10000H-0E0H)/8 DUP (0)
;(#-4-#)
		DB      0FFH                 ; wg. Lesemechanismus des 80386
TSS_LEN EQU     $-TSS

;MSG1    DB      'Harrys virtueller 8086-Monitor fuer 386-PCs, Version 1.34'
;        DB      CR,LF,'(c) 1990 c''t/Harald Albrecht',CR,LF,'$'
; MSG3    DB      'A20 kann nicht freigegeben werden!',CR,LF,'$'
;MSG4    DB      'Dieses Programm benoetigt einen 386(-kompatiblen) '
;        DB      'Prozessor!',CR,LF,'$'
;(*-4-*)
;MSG5    DB      'Harrys Expanded Memory Manager EMM (EMS 3.2) Version 1.4'
;        DB      CR,LF,'(c) 1990 c''t/Harald Albrecht',CR,LF,'$'
;MSG6    DB      ' Seiten ($'
;MSG7    DB      ' kBytes) verfuegbar.',CR,LF,'$'
;MSG8    DB      'Extended Memory zu klein, EMM abgebrochen',CR,LF,'$'
;MSG9    DB      'unbekannten EMM vorgefunden, EMM abgebrochen',CR,LF,'$'
;MSG10   DB      'EM-Seiten noch aktiv, neu installieren (j/n) ?',CR,LF,'$'
;MSG11   DB      'Virtueller Modus derzeit aktiv,'
;MSG12   DB      'EMM abgebrochen',CR,LF,'$'
;(*-4-*)
;(#-5-#)
;MSG20   DB      'DMA-Unterstuetzung fuer die "Wilde Dreizehn" Version 1.0'
;        DB      CR,LF,'(c) 1990 Harald Albrecht',CR,LF,'$'
;MSG21   DB      ' kBytes DMA-Buffer reserviert.',CR,LF,'$'
;(#-5-#)

MSGF    DB      ' Byte remaining resident, EMM386 return to DOS',CR,LF,'$'
MSGFail DB      ' something failed - driver aborted',CR,LF,'$'
msg_already_installed DB 'EMM already installed',CR,LF,'$'


WHOLE_DATA_LEN  EQU     OFFSET $

DATA    ENDS
;
; Den Prozessor in den Protected-Mode umschalten und die virtuelle
; Betriebsart des 80386 starten. Einsprung erfolgt im REAL-Mode, danach
; wird ein Task- Wechsel erzwungen, durch den der virtuelle 8086-Modus
; gestartet wird.
CODE    SEGMENT PARA USE16
		ASSUME  CS:CODE,DS:DATA

STORE MACRO ADDRESS
		MOV     EAX,EDI                    ;; Durch <ADDRESS> beschriebenen
		MOV     WORD PTR FS:[ADDRESS+2],AX;; Descriptor mit dem Wert aus
		SHR     EAX,16                    ; EDI; laden
		MOV     BYTE PTR FS:[ADDRESS+4],AL
		ENDM

REPMOVSB MACRO
		MOVZX   ECX,CX               ;; 32 Bit-Adressen benutzen, damit
		REP MOVS BYTE PTR [ESI],BYTE PTR [EDI]; der; gesamte Adressraum
		BIG_NOP;
		ADD     EDI,3                    ; angesprochen; werden kann. Adresse
		AND     DI,NOT 3                   ; auf Langwort-; grenze runden, Bits
		ENDM                          ;  1 & 0 loeschen

_pmessage macro line,col,c1,c2
	push ds
	push ax
	mov ax,UNIVERSE_SEL
	mov ds,ax
	mov byte ptr ds:[0b0000h+line*160+col*2+0],c1
	mov byte ptr ds:[0b0000h+line*160+col*2+1],070h
	mov byte ptr ds:[0b0000h+line*160+col*2+2],c2
	mov byte ptr ds:[0b0000h+line*160+col*2+3],070h
	inc byte ptr ds:[0b0000h+line*160+col*2+4]
	mov byte ptr ds:[0b0000h+line*160+col*2+5],070h
	pop ax
	pop ds
	endm

_pause macro line,col,c1,c2
	push ebx

	mov ebx, (line*80 + col) * 2
	call pause

	pop ebx
	endm



GO_PROTECTED PROC FAR
		CLI                          ; do not disturb !
		CLD
		LIDT    FWORD PTR [IDT_PTR]  ; Zeiger auf IDT und GDT im Speicher
		LGDT    FWORD PTR [GDT_PTR]  ; initialisieren
		MOV     BX,TMP_TSS_SEL           ; Voruebergehend temporaere Task setzen
		MOV     EAX,CR0                    ; Das Protected-Mode-Enable-Bit in
		OR      EAX,1                   ; CR0 setzen.
		MOV     CR0,EAX                    ; Im Protected-Mode !
		JMP     SHORT $+2            ; Prefetch-Queue loeschen
		LTR     BX                   ; Nun aktuelles TSS anwaehlen.
		MOV     AX,V86_LDT_SEL           ; Nun auch LDT initialisieren (ERST
		LLDT    AX                   ; JETZT !)

		ASSUME  FS:DATA
		MOV     AX,UNIVERSE_SEL   ; Alles adressieren
		MOV     DS,AX
		MOV     ES,AX
		MOV     AX,V86_DATA_SEL   ; GDT/LDT & Co.
		MOV     FS,AX

		MOV     SI,SEG V86           ; Lage des Monitor-Codes im REAL-Mode
		MOVZX   ESI,SI               ; berechnen
		SHL     ESI,4


		MOV     EDI,FS:[_MONITOR_ADDR]          ; Beginn des Monitor-Codes
;(#-6-#)
; Den Platz fuer den DMA-Buffer reservieren
;
		MOV     FS:[BuffStart],EDI         ; Zeiger abspeichern.
		ADD     EDI,DMA_BUFF_SIZE*1024  ; Platz fuer Buffer einfuegen
;(#-6-#)

		STORE   <OFFSET LDT+(V86_CODE_SEL AND 0F8H)>
										 ; neue Lage des Code-Segments
		MOV     CX,V86_LEN           ; Laenge des Codes
		REPMOVSB

		MOV     SI,SEG DATA          ; Die Interrupt-Tabelle verschwindet
		MOVZX   ESI,SI               ; ebenfalls im Extended-Bereich
		SHL     ESI,4
		MOV     EBP,ESI                    ; fuer spaeter retten
		MOV     AX,OFFSET IDT
		MOVZX   EAX,AX
		ADD     ESI,EAX
		STORE   <IDT_PTR>            ; Zeiger auf IDT neu setzen
		MOV     CX,7FFH
		REPMOVSB
		LIDT    FWORD PTR FS:[IDT_PTR]; IDT-Basisregister neu laden

		MOV     ESI,EBP                    ; Da sich das TSS nicht gerade klein
		MOV     AX,OFFSET TSS           ; ausnimmt (ueber 8 kByte), wird es
		MOVZX   EAX,AX               ; ebenfalls verschoben.
		ADD     ESI,EAX
		STORE   <OFFSET GDT+(V86_TSS_SEL AND 0F8H)>
		MOV     CX,TSS_LEN
		REPMOVSB
;(*-5-*)
; Die Variablen des Expanded Memory Managers (EMM) nun ebenfalls
; initialisieren. Zuerst kommt die virtuelle Speicherverwaltung des 80386
; an die Reihe.
		ADD     EDI,4095                   ; Auf die naechste Seitengrenze runden
		AND     EDI,NOT 4095


;        MOV     AX,FS:[__EXTMEM]           ; Ermitteln der zur Verfuegung
;        ADD     AX,1024                    ; stehenden kBytes (inkl. DOS = 1

		mov eax, FS:[_TOTAL_MEMORY]			; memory in byte
		shr eax, 10						; in kbyte

		SHR     eAX,2                    ; MByte) In Seiten ( 4 kBytes)
		SHR     eAX,10                    ; umrechnen ...ergibt die Anzahl der
		MOV     BX,1024                    ; benoetigten Eintraege im Page
		INC     AX                    ;  Directory
		SUB     BX,AX                    ; Den Rest spaeter ausnullen

		MOV     ESI,111B                   ; R/W=1, U/S=1, P=1
		MOV     FS:[PAGEDIR],EDI          ; Beginn der Tabellen (spaeter in CR3)
		MOV     EDX,EDI                    ; 1. Page Table beginnt direkt hinter
		ADD     EDX,4096                   ; dem Page Directory
@@FILL_PAGEDIR:
		MOV     [EDI],EDX            ; physikalische Adresse der
		OR      BYTE PTR [EDI],111B  ; jeweiligen Seite (Page Table) &
		ADD     EDI,4                     ;  Statusbits
		MOV     CX,1024                    ; Jeweils einen Page Table fuellen
@@FILL_PAGETABLE:
		MOV     [EDX],ESI            ; Lage der Seite im physikalischen
		ADD     ESI,4096                   ; Adressraum berechnen und im Page
		ADD     EDX,4                    ; Table ablegen
		LOOP    @@FILL_PAGETABLE
		DEC     AX
		JNZ     SHORT @@FILL_PAGEDIR
		MOVZX   ECX,BX               ; Den Rest des Page Directory
		XOR     EAX,EAX                    ; ausnullen
		REP     STOS DWORD PTR [EDI]
		BIG_NOP                         ; Fuer die alten 386er (B3-Maske)
		MOV     EDI,EDX                    ; EDI zeigt immer auf das erste
										 ; (noch) freie Byte im Extended



;        MOVZX   EAX,FS:[__EXTMEM]     ; Memory Die Anzahl der zur
;        ADD     EAX,1024                   ; Verfuegung stehenden Seiten ( 4
;		sub		eax,EXT
;
;
;        SHL     EAX,10                    ; kBytes) berechnen, indem der
;        SUB     EAX,EDI                    ; bisher verbrauchte Platz abge-

		mov eax, FS:[_EMM_MEMORY_END]			;
		sub eax, EDI				 	;

		SHR     EAX,12                    ; zogen wird.


		DEC     AX                   ; Eine Seite benoetigt der EMM selbst.
		SHR     AX,2                    ; Nun in EMS-Seiten umrechnen
		MOV     FS:[_MAXPAGES],AX
		MOV     FS:[PAGESAVAIL],AX
		MOV     FS:[STATUSTABLE],EDI ; Hier beginnt die Statustabelle der
		MOV     AX,-1                    ; Handles. Handle 0 ist dem System
		STOS    WORD PTR [EDI]            ; vorbehalten, alle anderen sind
		BIG_NOP                         ; Prefix-Anpassung
		MOV     AX,-2                    ; frei
		MOV     ECX,256*4-1          ; Noch zu fuellende Eintraege fuer 255
		REP     STOS WORD PTR [EDI]  ; Handles (REP STOSW, addr. size =
		BIG_NOP;
		MOV     FS:[EMSPAGETABLE],EDI; 32) Hier beginnt die Belegung der
		MOV     ECX,2048                   ; EMS-Seiten
		MOV     AL,FREEPAGE_ID           ; alle momentan frei
		REP     STOS BYTE PTR [EDI]  ; REP STOSB (addr. size = 32)
		BIG_NOP;
		MOV     FS:[FIRSTPAGE],EDI   ; Beginn der ersten EMS-Seite
										 ; vermerken
; Es ist ausserdem noch die Lage der Eintraege in den Page Tables fuer das
; EMS- Fenster zu ermitteln. (Erspart spaeter wiederkehrende Berechnungen)
;
		MOVZX   EAX,FS:[_FRAME]        ;  D000 Segmentadresse des Fensters
		SHL     EAX,4                 ; D0000 ... in absolute Adresse umrechnen
		MOV     ESI,FS:[PAGEDIR]
		SHR     EAX,10                ;
		PUSH    EAX
		SHR     EAX,10                ; Zeiger in das Page Directory er-
		AND     EAX,111111111100B     ; mitteln
		AND     ESI,NOT 111111111111B ; Statusbits herauswerfen
		MOV     ESI,[ESI+EAX]         ; ^ auf Page Table lesen
		POP     EAX
		AND     EAX,111111111100B     ; Das gleiche Spiel von Neuem
		AND     ESI,NOT 111111111111B
		ADD     ESI,EAX
		MOV     FS:[FRAMEANCHOR],ESI
;(*-5-*)
; Kleine Anmerkung zu dem folgenden Befehl: der Descriptor-Cache des FS-
; Segmentregisters enthaelt nach der Ausfuehrung weiterhin die alte Segment-
; grenze! (An dieser Stelle ist das unwesentlich, da keine weiteren
; Zugriffe erfolgen.)
		MOV     WORD PTR FS:[LDT+(V86_DATA_SEL AND 0F8H)],DATA_LEN
;
; Nun ist endlich alles vorbereitet, so dass mit einem Task-Wechsel der
; virtuelle 8086-Monitor gestartet werden kann.
;
		JMP     DWORD PTR CS:[@@V86_ENTRY_ADDR]; Task-Wechsel erzwingen
@@V86_ENTRY_ADDR:
		DW      0,V86_TSS_SEL        ; "Adresse" Task State Segment
GO_PROTECTED ENDP

CODE    ENDS
;
; Der eigentliche Monitor fuer den virtuellen 8086-Modus. Dieser Bereich
; wird in das Extended Memory ab 1 MByte ausgelagert.
;
V86     SEGMENT
		ASSUME  CS:V86,ES:NOTHING,FS:NOTHING,GS:NOTHING
;
; Innerhalb dieser Routine werden die Interrupts und Ausnahmen gehandhabt,
; indem einfach der Interrupt-Aufruf in den virtuellen 8086-Modus
; reflektiert wird. Ausnahmen bilden nur die Fehler-INTs 08h bis 0Fh, die
; darauf ueberprueft werden muessen, ob sie hardwaremaessig generiert wurden.
;
V86_MONITOR PROC NEAR
		PUSH    EAX
		PUSH    EBX
		PUSH    ECX

		movzx   esp,sp

									; ECX is a pointer into iterrupt table
									; or intno*4
		MOV     cX,[ESP+12]         ; 
		SUB     cX,OFFSET INT_TABLE
		AND     ecX,0fffch          ;



; Bei den Interrupts 08h - 0Fh ist zu ueberpruefen, ob sie per INT
; xx-Befehl bzw. Hardware ausgeloest wurden, oder ob es sich um einen
; Ausnahme-Interrupt handelt.
; Ausserdem kann es auch noch sein, dass der Monitor rekursiv aufgerufen
; wurde, da ein HLT-Befehl ausgefuehrt werden musste.
;
		CMP     ESP,V86_TOS-36H   ; Was ist ueberhaupt passiert ?!
		JZ      @@V86_ABORT          ; Ein Ausnahme-Interrupt
		JB      SHORT @@PROTECTED        ; Monitorprogramm wurde unterbrochen

@@REENTRY:
		MOV     BX,UNIVERSE_SEL   ; 4-GByte-Bereich fuer vollen Zugriff
		MOV     DS,BX                    ; auf alle Bytes benutzen.

		SUB     WORD PTR [ESP+14+12],6 ; Platz fuer INT-Daten schaffen

		MOVZX   EBX,WORD PTR [ESP+14+16] ; linear address of 86er-Stacks
		SHL     EBX,4                    ; 
		movzx   eax,word ptr [ESP+14+12] ; use ONLY low portion SP,
		add 	ebx,eax			         ; as ESP may be undefined !

				
                                       ; copy Interrupt frame down
		MOV     AX,[ESP+14]            ; IP 
		MOV     [EBX],AX
		MOV     AX,[ESP+14+4]          ; CS 
		MOV     [EBX+2],AX
		MOV     AX,[ESP+14+8]          ; Flags
		MOV     [EBX+4],AX


;
; Bei den Hardware-Interrupts 08h bis 0Fh sowie 70h bis 77h ist das
; Interrupt- Flag zu sperren
;
		CMP     CX,08H*4                   ; Bereich 08h bis 0Fh ?
		JB      SHORT @@V86_CONT         ; Falls nicht, dann weiter
		CMP     CX,0FH*4
		JBE     SHORT @@CLR_IF
		CMP     CX,70H*4                   ; Nur im Bereich 70h bis 77h
		JB      SHORT @@V86_CONT
		CMP     CX,77H*4
		JA      SHORT @@V86_CONT
@@CLR_IF:
		AND     WORD PTR [ESP+14+8],NOT 200H; IF loeschen: Interrupts sperren
@@V86_CONT:
		AND     WORD PTR [ESP+14+8],NOT 100H; TF loeschen: Einzelschritt aus!

		MOV     BX,[ECX]             ; Neue Adresse CS:IP aus der 8086-
		MOV     [ESP+14],BX          ; Tabelle in die Ruecksprungadresse
		MOV     BX,[ECX+2]           ; auf dem Stack schreiben
		MOV     [ESP+18],BX

		POP     ECX                  ; Wieder alles fein saeuberlich auf-
		POP     EBX                  ; raeumen.
		POP     EAX
		
		INC     ESP                  ; Alte Aufrufadresse korrigieren
		INC     ESP

		IRETD                        ; Rueckkehr zum virtuellen 86-Modus
										 ; (nur) via IRETD !
;
; EFLAG, CS, IP, die durch den neuen Interrupt gerettet wurde, wieder
; entfernen
@@PROTECTED:
		MOV     AX,[ESP+12]          ; Neue Interrupt-Nr (= Ruecksprung-
		MOV     [ESP+24],AX          ; adresse) auf die richtige Pos.
		MOV     EAX,[ESP+8]          ; legen. EAX, EBX, ECX ebenfalls
		MOV     [ESP+20],EAX         ; nach oben verschieben, damit der
		MOV     EAX,[ESP+4]          ; Stack fuer den virtuellen
		MOV     [ESP+16],EAX         ; Registern EFLAG, CS, IP bereinigt
		MOV     EAX,[ESP]            ; werden kann.
		MOV     [ESP+12],EAX
		ADD     ESP,12                    ; EFLAG, CS, IP Protected Mode weg-
		JMP     @@REENTRY            ; werfen und weiter.


@@V86_ABORT:
		CMP     CX,0DH*4             ; Privilegverletzung ?
		JNZ     @@V86_ABORT_IT ; Alles andere liegt immer daneben !

		MOV     AX,UNIVERSE_SEL      ; Hallo Welt, hallo Universum !
		MOV     DS,AX

		MOVZX   EAX,WORD PTR [ESP+18+4]; ueberpruefen, ob ein HLT-Befehl die
		SHL     EAX,4                    ; Privilegverletzung ausgeloest hatte
		ADD     EAX,[ESP+18]

										; EAX = linear CS:IP

;
; ueberpruefung des fehlerausloesenden Befehls
;
		MOV     BL,[EAX]                ; check opcode

		CMP     BL,0F4H                 ; HLT-
		JZ      @@Is_Hlt                ; Befehl ?

		CMP     BL,0E4H                 ; IN/OUT ??
		JB      @@V86_ABORT_IT                   ;
		CMP     BL,0E7H                 ;
		JBE     @@DoIO_Im               ;
		CMP     BL,0ECH                 ;
		JB      @@V86_ABORT_IT                   ;
		CMP     BL,0EFH
		JBE     @@DoIO_DX
@@nix:  JMP     @@V86_ABORT_IT          ; ansonsten meckern !

@@Is_Hlt:

		CMP     WORD PTR [ESP+18+4],SEG DATA ; War ein besonderer HLT-
		JNZ     @@Do_Hlt                ; Befehl der Ausloeser fuer den


		MOV     AX,[ESP+18]             ; General Protection Fault ?
		CMP     AX,OFFSET HLT13
		JZ      TRANSFER_BUFF           ; Buffer noch zurueckkopieren
		CMP     AX,OFFSET HLT40
		JZ      TRANSFER_BUFF
@@Do_Hlt:
;(#-7-#)

		INC     WORD PTR [ESP+18]         ; Den HLT-Befehl ueberspringen
		POP     ECX                  ; Register restaurieren
		POP     EBX
		POP     EAX
		ADD     ESP,6                    ; Fehlercode & Ruecksprungadr.
		STI                          ; wegwerfen Interrupts wieder
		HLT                          ; freigeben und dann warten, warten,
										 ;      warten...



;*************************************************************
; this driver isn't abortable (it hols UMBs,...)
;
; so we generate an INT 6 (invalid opcode) interrupt, and hope,
; that DOS aborts us
;
;*************************************************************
@@V86_ABORT_IT:                      ; Jetzt ist aber endgueltig Schluss !

									;>> by mov ax,[ffff]
									;>> by AX,0FFF1h		    ; sonst provozier Privilegfehler
									;>>    LMSW	 AX		      ;	zum Deinstallieren

									; ESP+22 = cs
									; ESP+18 = ip


		MOV     BX,UNIVERSE_SEL   ; 4-GByte-Bereich fuer vollen Zugriff
		MOV     DS,BX                    ; auf alle Bytes benutzen.
		MOVZX   EBX,WORD PTR [ESP+18+16]; Die absolute Lage des 86er-Stacks
		SHL     EBX,4                    ; berechnen
		ADD     EBX,[ESP+18+12]         ; (ESP 86er-Stack dazu)

		SUB     DWORD PTR [ESP+18+12],6 ; room for IP,CS,FLAGS

		MOV     AX,[ESP+18]          ; IP kopieren
		MOV     [EBX-6],AX
		MOV     AX,[ESP+18+4]          ; dto. CS retten
		MOV     [EBX-4],AX
		MOV     AX,[ESP+18+8]          ; Flags bearbeiten
		MOV     [EBX-2],AX
;


									; simulate invalid opcode interrupt
		MOV     BX,[ds:6*4]            ; Neue Adresse CS:IP aus der 8086-
		MOV     [ESP+18],BX         ; Tabelle in die Ruecksprungadresse
		MOV     BX,[ds:6*4+2]          ; auf dem Stack schreiben
		MOV     [ESP+18+4],BX

		AND     WORD PTR [ESP+18+8],NOT 100H; clear TF (single step off)


		POP     ECX                  ; Wieder alles fein saeuberlich auf-
		POP     EBX                  ; raeumen.
		POP     EAX

		INC     ESP                  ; Alte Aufrufadresse korrigieren
		INC     ESP

		add     ESP,4   			 ; remove error word

		IRETD                        ; Rueckkehr zum virtuellen 86-Modus
										 ; (nur) via IRETD !

;***************************************


;        MOV     DX,CX                    ; Nummer des Interrupts berechnen
;        SHR     DX,2
;        JMP     DWORD PTR CS:[@@V86_ABORT_ADDR]
;@@V86_ABORT_ADDR:
;        DW      OFFSET RETURN_OF_THE_86,REAL_SEL

;(#-8-#)
;
; Ein IN/OUT-Befehl muss nun emuliert und die Daten ggf. kontrolliert
; werden
;
@@DoIO_Im:
		REPCMD  PUSH,<EDX,ESI,EDI>      ; rette sich, wer kann !!
		INC     EAX                     ; Opcode uebergehen und die
		MOVZX   DX,BYTE PTR [EAX]       ; I/O-Adresse lesen
		ADD     WORD PTR [ESP+18+12],2  ; Den Befehl ueberspringen
@@WithDX:
		MOV     AX,V86_DATA_SEL
		MOV     DS,AX
		TEST    BL,00000010B            ; Ist es ein IN-Befehl ?
		JNZ     @@Im_Out                ; Noe ... 'n oller OUT.
		TEST    BL,00000001B            ; Breite Wort oder Byte ?
		JNZ     @@Im_Word
		IN      AL,DX                   ; Das Datum vom Port einlesen
		MOV     [ESP+8+12],AL           ; und zurueckgeben.
@@Bye:  REPCMD  POP,<EDI,ESI,EDX,ECX,EBX,EAX>
		ADD     ESP,6
		IRETD

@@Im_Word:
		IN      AX,DX                   ; Gleiche Aktion wie oben nun
		MOV     [ESP+8+12],AX           ; mit 16 Bit
		JMP     @@Bye

@@Im_Out:
		MOV     AL,[ESP+8+12]           ; Opcode wegen Byte/Word-Flag
		REPCMD  PUSH,<BX,DX>            ; retten. Low Byte zuerst nun an
		CALL    @@Do_IO                 ; den Port absenden.
		REPCMD  POP,<DX,BX>             ; Opcode wiederholen und testen,
		TEST    BL,00000001B            ; ob noch das Hi-Byte abzuschik-
		JZ      @@Bye                   ; ken ist.
		INC     DX
		MOV     AL,[ESP+8+1+12]
		CALL    @@Do_IO
		JMP     @@Bye

@@Do_IO:
		CMP     DX,80H                  ; Ist ein Page-Register ange-
		JB      LIKE_DMA                ; sprochen worden ? Oder etwa
		CMP     DX,8FH                  ; doch einer der beiden DMA-
		JBE     LIKE_PAGE               ; Controller ?
		JMP     LIKE_DMA

@@DoIO_DX:
		REPCMD  PUSH,<EDX,ESI,EDI>      ; Register retten.
		INC     WORD PTR [ESP+18+12]    ; Den Opcode ueberspringen
		JMP     @@WithDX

;
; Den DMA-Bufferinhalt nach Beendigung des Disk-I/Os an das gewuenschte
; Ziel kopieren.
;
TRANSFER_BUFF PROC NEAR
		INC     WORD PTR [ESP+18]       ; Den HLT-Befehl ueberspringen.
		REPCMD  PUSH,<DS,ES,ESI,EDI>
		MOV     AX,V86_DATA_SEL
		MOV     DS,AX
		MOV     ESI,[BuffStart]         ; Die Eckdaten des zu verschie-
		MOV     EDI,[TargetAdr]         ; benden Blocks holen.
		MOV     ECX,[BuffLen]
		MOV     AX,UNIVERSE_SEL         ; Die grosse Freiheit ... irgend-
		MOV     DS,AX                   ; wann faellt jede (Segment-)
		MOV     ES,AX                   ; Mauer !
		CLD
		MOV     EAX,ECX
		AND     ECX,3
		REP     MOVS BYTE PTR [ESI],BYTE PTR [EDI]
		BIG_NOP
		MOV     ECX,EAX
		SHR     ECX,2
		REP     MOVS DWORD PTR [ESI], DWORD PTR [EDI]
		BIG_NOP
		REPCMD  POP,<EDI,ESI,ES,DS,ECX,EBX,EAX>
		ADD     ESP,6                   ; Ruecksprungadresse wegwerfen.
		IRETD                           ; zurueck zum virtuellen 8086-
TRANSFER_BUFF ENDP                      ; Modus.
;
; Zugriff auf ein Seitenregister
;
; Ein: DX : Portadresse; AL : Wert
;
LIKE_PAGE PROC NEAR
		OUT     DX,AL                   ; Datum auch ausgeben.
		MOV     BX,DX                   ; Die zum Port gehoerende Kanal-
		MOVZX   EDI,BYTE PTR PageLookUp[BX-80H] ; nummer suchen.
		MOV     PageReg[EDI],AL         ; Bits 24-16 zwischenspeichern
		BTR     ChanFlags[EDI*2],PagePrgrd ; Seitenreg. programmiert
		JMP     READY?
LIKE_PAGE ENDP
;
; Bestimmte Register der DMA-Bausteine ueberwachen
; Ein: DX : Portadresse; AL : Wert
;
LIKE_DMA PROC NEAR
		OUT     DX,AL                   ; Erst einmal weitergeben...
		CMP     DX,0C0H                 ; Soll der zweite Controller
		JB      @@What?                 ; programmiert werden ?
		SUB     DX,0C0H-20H             ; Dann I/O-Adresse in den Be-
		SHR     DX,1                    ; reich 10h - 1Fh umrechnen
@@What?:
		CMP     DX,7                    ; Adresse bzw. Laenge der Bloecke
		JBE     @@BlockSet              ; programmieren ?
		CMP     DX,10H                  ; dto. 2ter DMA-Controller ?
		JB      @@Mode?
		CMP     DX,17H
		JBE     @@BlockSet
@@Mode?:
		CMP     DX,0BH                  ; "Mode Register" angesprochen ?
		JZ      @@Mode8                 ; DMA-Controller #1 ?
		CMP     DX,1BH                  ; dto. #2 ?
		JZ      @@Mode16
		CMP     DX,0CH                  ; Soll das Hi/Lo-FlipFlop ge-
		JZ      @@Clear8                ; loescht werden ?
		CMP     DX,1CH
		JZ      @@Clear16
		JMP     @@Bye                   ; Wenn alles fehlschlaegt...
;
; Zugriff auf Startadresse bzw. Blocklaenge eines DMA-Kanals
;
@@BlockSet:
		MOVZX   EDI,DX                  ; Die DMA-Kanalnummer aus der
		AND     DI,0110B                ; I/O-Adresse (ebenfalls bereits
		SHR     DI,1                    ; umgeformt) berechnen
		MOV     BX,HiLoFlag1            ; ... momentan Controller #1
		CMP     DX,10H                  ; Etwa doch der zweite Control-
		JB      @@Len?                  ; ler angesprochen ?
		ADD     DI,4                    ; Ab dem 4. Kanal (von wegen
		MOV     BX,HiLoFlag2            ; Private...)
@@Len?: TEST    DX,0001H                ; Blocklaenge gemeint ?
		JNZ     @@Length

		BTC     [Flags],BX              ; Das Hi/Lo-Flag toggeln. Wurde
		JNC     @@AdrLo                 ; das Lo-Byte programmiert ?
		MOV     BYTE PTR BaseAdr[EDI*2+1],AL ; Die hoeherwertigen Bits
		BTR     ChanFlags[EDI*2],BasePrgrd ; 8-15 ablegen und Flag
		JMP     READY?                  ; loeschen, da vollstaendig
@@AdrLo:                                ; programmiert.
		MOV     BYTE PTR BaseAdr[EDI*2],AL ; Das Lo-Byte programmiert,
		BTS     ChanFlags[EDI*2],BasePrgrd ; daher Flag setzen, weil
		JMP     @@Bye                   ; noch 8 Bits folgen.

@@Length:
		BTC     [Flags],BX              ; Wieder Hi/Lo-Flag toggeln.
		JNC     @@LenLo                 ; Ansonsten spielt sich hier
		MOV     BYTE PTR BlockLen[EDI*2+1],AL ; fast das Gleiche wie
		BTR     ChanFlags[EDI*2],LenPrgrd ; vorher ab.
		JMP     READY?
@@LenLo:
		MOV     BYTE PTR BlockLen[EDI*2],AL ; Lo-Byte programmieren
		BTS     ChanFlags[EDI*2],LenPrgrd
		JMP     @@Bye

READY?: TEST    ChanFlags[EDI*2],1111B
						; = BasePrgrd+LenPrgrd+PagePrgrd+ModePrgrd
		JNZ     @@Bye                   ; Alle Register initialisiert ?
		TEST    [Flags],11B             ; INT13Active+INT40Active.
										; Ist momentan ein Disk-
		JZ      @@Bye                   ; I/O-INT aktiv ? Wenn nicht,
										; Augen zu und durch...
		CALL    CHK_CHANNEL             ; Dann Werte kontrollieren
@@Bye:  RET
;
; "Mode Register" ueberwachen fuer die Transferrichtung DMA <--> I/O
;
@@Mode8:
		MOVZX   EDI,AL                  ; Die Nummer des DMA-Kanals aus-
		AND     DI,0011B                ; maskieren
@@Mode8@16:
		SHL     AL,2                    ; Die Transferrichtung aus den
		AND     AL,00110000B            ; restlichen Daten ausmaskieren
		AND     ChanFlags[EDI*2],NOT 00110000B ; und in die Statusdaten
		OR      BYTE PTR ChanFlags[EDI*2],AL ; des jeweiligen Kanals
		BTR     ChanFlags[EDI*2],ModePrgrd ; einschreiben.
		JMP     READY?                  ;
@@Mode16:
		MOVZX   EDI,AL                  ; Ebenfalls die Nummer des DMA-
		AND     DI,0011B                ; Kanals ausmaskieren.
		ADD     DI,4                    ; Es handelt sich um einen 16-
		JMP     @@Mode8@16              ; Bit-Kanal.
;
; Das Hi/Lo-FlipFlop des entsprechenden DMA-Controllers loeschen
;
@@Clear8:
		BTR     [Flags],HiLoFlag1       ; Das war es auch schon.
		JMP     @@Bye
@@Clear16:
		BTR     [Flags],HiLoFlag2       ; Nummer 2 ist nun an der Reihe
		JMP     @@Bye
LIKE_DMA ENDP
;
; Einen Speicherbereich darauf ueberpruefen, ob er kontinuierlich auf
; 4k-Seiten im physikalischen Speicher liegt.
;
; Ein: ESI: lineare Startadresse
;      ECX: Laenge des Bereiches
; Aus: CY-Flag: rueckgesetzt, ESI = physikalische Adresse
;               gesetzt, nicht durchgaengig
;
CONTINUOUS? PROC NEAR
		PUSH    ES                      ; Wir brauchen hier gleich ein
		MOV     AX,UNIVERSE_SEL         ; wenig mehr Platz im Adressraum,
		MOV     ES,AX                   ; daher nun aufpusten...
		PUSH    ECX
		MOV     EAX,ESI                 ; So tun, als ob der Block auf
		AND     EAX,4095                ; einer Seitengrenze beginnt,
		ADD     ECX,EAX                 ; daher die Laenge anpassen.
		PUSH    ESI                     ; Fuer spaeter retten
		MOV     EAX,ESI
		SHR     ESI,20                  ; Den Zeiger auf den entspr.
		AND     ESI,111111111100B       ; Eintrag in der Seitentabelle
		MOV     EBX,CR3                 ; ermitteln.
		ADD     ESI,EBX
		MOV     ESI,ES:[ESI]
		AND     ESI,NOT 4095
		SHR     EAX,10
		AND     EAX,111111111100B
		ADD     ESI,EAX
		MOV     EAX,ES:[ESI]            ; Lage der Seite im phys. Adress-
		AND     EAX,NOT 4095            ; raum erfragen
		PUSH    EAX                     ; Bits 31-12 retten
		SHR     ECX,12                  ; Die Anzahl der ueberstrichenen
		JCXZ    @@Ok                    ; Seiten berechnen. Null ist ok!
@@Loop: ADD     EAX,4096                ; Jeweils eine Seite und einen
		ADD     ESI,4                   ; Eintrag weiter wandern.
		MOV     EBX,ES:[ESI]            ; Schliesst sich die folgende
		AND     EBX,NOT 4095            ; Seite im Speicher direkt an ?
		CMP     EAX,EBX
		JNZ     @@Fail                  ; ...daneben !
		LOOP    @@Loop
@@Ok:   REPCMD  POP,<EAX,ESI,ECX,ES>    ; Die physikalische Adresse er-
		AND     ESI,4095                ; gibt sich aus den Bits 31-12
		OR      ESI,EAX                 ; der Seite und dem Offset 11-0
		CLC                             ; ...ist ok.
		RET
@@Fail: REPCMD  POP,<EAX,ESI,ECX,ES>    ; Register wiederherstellen.
		STC                             ; ...geht nicht !
		RET
CONTINUOUS? ENDP
;
; Ein DMA-Kanal wurde vollstaendig mit Daten ueber Beginn und Laenge ver-
; sorgt, so dass nun eine ueberpruefung stattfinden kann (und muss).
;
; Ein: EDI: Kanalnummer 0..7
;
CHK_CHANNEL PROC NEAR
		MOVZX   ECX,BlockLen[EDI*2]     ; Die Laenge des zu uebertragenden
		INC     ECX                     ; Blocks berechnen
		CMP     EDI,4                   ; Falls es sich um einen 16-Bit-
		JB      @@Only8                 ; DMA-Kanal handelt, werden
		ADD     ECX,ECX                 ; Woerter uebertragen. Die Basis-
		MOVZX   ESI,PageReg[EDI]        ; adresse liegt zudem immer auf
		SHL     ESI,15                  ; einer Wortgrenze und Bit 0 des
		MOV     SI,BaseAdr[EDI*2]       ; Seitenregisters wird ignoriert
		SHL     ESI,1
		JMP     @@Chk
@@Only8:
		MOVZX   ESI,PageReg[EDI]        ; Bei 8-Bit-DMA-Kanaelen ist die
		SHL     ESI,16                  ; Adressberechnung etwas ein-
		MOV     SI,BaseAdr[EDI*2]       ; facher...
@@Chk:
		BTR     [Flags],NeedBuffer      ; Initialisieren.
		MOV     [TargetAdr],ESI         ; Daten ueber Block sicherheits-
		MOV     [BuffLen],ECX           ; halber fuer spaeter vermerken.
		CALL    CONTINUOUS?             ; Befindet sich der Block auf
		JNC     @@Set                   ; hintereinanderliegenden
										; Seiten ?
		MOV     AL,BYTE PTR ChanFlags[EDI*2] ; Sollte allerdings ein
		AND     AL,00110000B            ; Verify gewuenscht sein, ist der
		JZ      @@Bye                   ; Buffer voellig ueberfluessig.
		MOV     ESI,[BuffStart]         ; Wenn nicht, gehe ueber Buffer
		BTS     [Flags],NeedBuffer      ; (und ziehe 4000 Takte ein...)
@@Set:
		MOV     DX,DI                   ; Aus der Kanalnummer die I/O-
		ADD     DX,DX                   ; Adresse berechnen.
		CMP     EDI,4                   ; 8 oder 16 Bit Kanal ?
		JB      @@Set8

		BTR     [Flags],HiLoFlag2       ; DMA #2, HiLo-FlipFlop-Flag
		ADD     DX,DX                   ; Der zweite DMA-Controller
		ADD     DX,0C0H                 ; befindet sich bei 0C0h
		OUT     [0D8H],AL               ; Hi/Lo-FlipFlop loeschen
		JMP     $+2                     ; ... etwas Zeit lassen.
		SHR     ESI,1                   ; Die Basisadresse wird nun
		MOV     AX,SI                   ; neu in den Controller einge-
		OUT     DX,AL                   ; schrieben, Lo vor Hi-Byte
		MOV     AL,AH                   ; in der ueblichen Intel-Manier.
		JMP     $+2
		OUT     DX,AL
		MOVZX   DX,PageXLat[DI]         ; I/O-Adresse des Seiten-
		SHR     ESI,15                  ; registers ermitteln.
		MOV     AX,SI                   ; Noch die restlichen 8 Bit der
		JMP     $+2                     ; 24-Bit-Adresse in das Seiten-
		OUT     DX,AL                   ; register verfrachten.
		JMP     @@Cont
@@Set8:
		BTR     [Flags],HiLoFlag1       ; DMA #1, HiLo-FlipFlop-Flag
		OUT     [0CH],AL                ; Hi/Lo-FlipFlop loeschen ...
		JMP     $+2                     ; ... und das uebliche.
		MOV     AX,SI                   ; Die Basisadresse neu pro-
		OUT     DX,AL                   ; grammieren
		MOV     AL,AH
		JMP     $+2
		OUT     DX,AL
		MOVZX   DX,PageXLat[DI]         ; Aahnlich oben, nur dass die
		SHR     ESI,16                  ; Adressberechnung etwas anders
		MOV     AX,SI                   ; (und einfacher) bei 8-Bit-DMA-
		JMP     $+2                     ; Kanaelen ausfaellt.
		OUT     DX,AL
@@Cont:
;
; Nun ueberpruefen, ob die Daten (wegen "Save") zuerst noch in den Buffer
; kopiert werden muessen.
;
		BT      [Flags],NeedBuffer      ; Muss ueberhaupt ein Transfer via
		JNC     @@Bye                   ; Buffer stattfinden ?
		MOV     AL,BYTE PTR ChanFlags[EDI*2] ; Bei einem Save (Speicher
		AND     AL,00110000B            ; -> I/O) vorher noch den Buffer
		CMP     AL,00100000B            ; initialisieren mit den Daten
		JNZ     @@Bye

		MOV     ESI,[TargetAdr]         ; Den benoetigten Speicherblock
		MOV     EDI,[BuffStart]         ; nun zuerst in den DMA-Buffer
		MOV     ECX,[BuffLen]           ; kopieren
		REPCMD  PUSH,<DS,ES>
		MOV     AX,UNIVERSE_SEL         ; ...ein Stueckchen Universum
		MOV     DS,AX                   ; schaut nun herein (Gruesse auch
		MOV     ES,AX                   ; an 'Grenzenlos' !)
		CLD
		MOV     EAX,ECX
		AND     ECX,3
		REP     MOVS BYTE PTR [ESI],BYTE PTR [EDI]
		BIG_NOP
		MOV     ECX,EAX
		SHR     ECX,2
		REP     MOVS DWORD PTR [ESI], DWORD PTR [EDI]
		BIG_NOP
		REPCMD  POP,<ES,DS>
		BTR     [Flags],NeedBuffer      ; Kann gehn...
@@Bye:
		RET
CHK_CHANNEL ENDP
;(#-8-#)

;
; PAUSE :
;         wait a little bit, incrementing some screen memory - 
;         so you see some little flashing before the program
;         looses control of itself :-)
;


pause proc near

	push ds
	push ax
	mov ax,UNIVERSE_SEL
	mov ds,ax

	add ebx, 0b0000h

	mov ax,0ffffh

@@loop:
	inc word ptr ds:[ebx]
	inc word ptr ds:[ebx+2]
	inc word ptr ds:[ebx+4]
	dec ax
	jne @@loop

	add ebx, 08000h

	mov ax,0ffffh

@@loop1:
	inc word ptr ds:[ebx]
	inc word ptr ds:[ebx+2]
	inc word ptr ds:[ebx+4]
	dec ax
	jne @@loop1


	pop ax
	pop ds
	ret

pause endp

V86_MONITOR     ENDP

;
; Der Affengriff (CTRL-ALT-Del) muss abgefangen und speziell behandelt
; werden !
KBOARD PROC NEAR
		PUSH    EAX                     ; Rette sich, wer kann !
		MOV     AX,UNIVERSE_SEL   ; Alles im Griff ...
		MOV     DS,AX
		IN      AL,[PORT_A]          ; Tastenscancode abholen
		CMP     AL,53H                    ; Del ?
		JNZ     SHORT @@CONT
		MOV     AL,DS:[@KB_FLAG]          ; Sind die Tasten CTRL & ALT
		AND     AL,1100B                    ;  gedrueckt ?
		CMP     AL,1100B                   ; Falls nicht, dann weiterarbeiten
		JNZ     SHORT @@CONT
		TEST    BYTE PTR DS:[@KB_FLAG_3],10B; 0E0h gesendet (Sondertaste)
		JNZ     SHORT @@CONT         ; ? Dann niemals Neustart !
		MOV     WORD PTR DS:[@RESET_FLAG],1234H; Ansonsten einen
                     
                     					
		mov     al,0feh				    ; reset, using the keyboard	
		out		dx,al

										; if that doesn't work,
										; do a more conventional 
										; jmp ffff:0 from real mode


		JMP     DWORD PTR CS:[@@ABORT_ADDR]; Warmstart vormerken und
@@ABORT_ADDR:                        ; wieder in den REAL-Mode zurueck
		DW      OFFSET RETURN_OF_THE_86,REAL_SEL


@@CONT: POP     EAX
		JMP     V86_MONITOR
KBOARD ENDP
;
; Einsprungpunkt durch den Task-Wechsel nach dem Umschalten in den
; Protected Mode zum Starten der virtuellen 8086-Bearbeitung. Zur
; Beachtung: Wir befinden uns in einem 16-Bit Segment !!!
;
V86_START PROC NEAR
		PUSH    0
		PUSH    0                    ; GS  Den Stackrahmen fuer das
		PUSH    0                    ;     Umschalten in den virtuellen
		PUSH    0                    ; FS  8086-Modus schaffen.
		PUSH    0                    ;
		PUSH    SEG DATA             ; DS
		PUSH    0
		PUSH    0                    ; ES
		PUSH    0
		PUSH    SEG TMP_STACK            ; SS
		PUSH    0
		PUSH    OFFSET TMP_TOS            ; ESP
		PUSH    0002H                     ; EFLAGS: VM, IOPL=3, IF
		PUSH    3200H
		PUSH    0
		PUSH    SEG _TEXT          ; CS
		PUSH    0
		PUSH    OFFSET KEEP          ; EIP
		CLTS                         ; TS-Flag (Task Switch) unbedingt
										 ; loeschen, damit der naechste
										 ; x87-Befehl ohne INT 7 ausgefuehrt
										 ; wird !!
;(*-6-*)
		MOV     AX,V86_DATA_SEL   ; Noch den "Anker" auf die fuer die
		MOV     FS,AX                    ; virtuelle Speicherverwaltung not-
		MOV     EAX,FS:[PAGEDIR]          ; wendigen Tabellen werfen
		MOV     CR3,EAX
		MOV     EAX,CR0                    ; Nun noch das Paging einschalten
		OR      EAX,80000000H
		MOV     CR0,EAX
;(*-6-*)
		IRETD                        ; Mit diesem einzelnen Befehl wird
										 ; die 8086-Verarbeitung gestartet.
V86_START ENDP
;
; Hier beginnt die Interrupt-Tabelle des virtuellen 86er-Monitors. Diese
; Tabellenadressen sind nun gueltig, nicht mehr die Tabelle ab 0:0.
;
INTENTRY_O MACRO SEQNR               ;; Leider wird nur auf diese Weise
INT&SEQNR:                                ;; der Symbolname INTxx richtig
		ENDM                         ;; erzeugt.

INTENTRY MACRO VON,BIS               ;; Einsprungpunkte fuer Interrupts im
		LOCAL   ENTRY                      ;; angegebenen Bereich (fuer die
ENTRY   =       VON                       ;; Mathematiker: Intervall)
		REPT    BIS-VON+1            ;;  generieren.
		INTENTRY_O %(ENTRY)               ;; Den virtuellen 86er-Monitor mit
		CALL    V86_MONITOR          ;; der Rueckkehradresse als Hinweis
		NOP                          ;; aufrufen. Ausrichten (auf 4 Bytes)
ENTRY   =       ENTRY+1
		ENDM
		ENDM

INTENTRYNR MACRO INTRNR,ADDRESS      ;; Eine Routine gezielt aufrufen
		INTENTRY_O %(INTRNR)
		ADDRESS
		NOP                          ;; Ausrichten
		ENDM

INT_TABLE:
		INTENTRY 0,8                 ; Alle Interrupts, bis auf den
		INTENTRYNR 09H,<CALL KBOARD> ; Tastatur- Interrupt auf den
										 ; Monitor umleiten
;********************************************************************
;(*-7-*)
comment $
;(*-7a-*)
	   INTENTRY 10,255  ; Diese Zeile wird bei EMM ausgeblendet
;(*-7a-*)
$
; Die Zeile INTENTRY 10,255 direkt ueber (*-7-*) muss geloescht werden !!!
;********************************************************************
		INTENTRY 10,66H
		INTENTRYNR 67H,<JMP  EMM_ENTRY>; EMM-Treiber
		INTENTRY 68H,255
;(*-7-*)

		PURGE   INTENTRY,INTENTRY_O,INTENTRYNR

;(*-8-*)
;
; Hier beginnt nun der Expanded Memory Manager (EMM) Version 3.2
;
; Die Definitionen der Lage der Segmentregister sind entsprechend
; anzupassen, wenn im Dispatcher EMM_ENTRY noch zusaetzliche Register
; gerettet werden!!!
V8086_ES        EQU     <ESP+34>          ; ES auf dem Level-0-Stack
V8086_DS        EQU     <ESP+38>          ; DS auf dem Level-0-Stack

MAX_HANDLES     EQU     255              ; Es sind nur 255 Handles (lt.
										 ; Dokumentation LIM EMS 4.0) zu
										 ; vergeben
FREEPAGE_ID     EQU     255              ; Eigner (Handle) einer freien Seite
EMM_ENTRY PROC NEAR
		ASSUME  FS:DATA
		PUSH    ESI                     ; Die in jedem Fall gefaehrdeten
		PUSH    EDI                     ; Register retten
		PUSH    ECX
		CLD

		MOV     CX,UNIVERSE_SEL   ; Alles adressieren
		MOV     DS,CX
		MOV     ES,CX
		MOV     CX,V86_DATA_SEL
		MOV     FS,CX

									;
									; hack: handle undocumented
									; int67/87 function = simulated int15/87
									;
		cmp     ah,087h
		jne		@@normal_emm_functions

		pop     ecx									
		CALL    SIMULATE_INT1587
		jmp     @@BYECX


@@normal_emm_functions:
		MOVZX   ECX,AH               ; Adresse der gewuenschten Routine
		SUB     CL,40H                    ; ermitteln. Falls ausserhalb des er-
		JB      SHORT @@INV_CALL         ; laubten Bereichs, dann Fehler
		CMP     CL,0EH                    ; melden
		JA      SHORT @@INV_CALL
		SHL     CX,1
		CALL    WORD PTR CS:[OFFSET CALL_TABLE+ECX]

@@BYE:  POP     ECX
@@BYECX:POP     EDI
		POP     ESI                  ; Register wiederherstellen
		IRETD                        ; 32-Bit-Return !!!
@@INV_CALL:
		MOV     AH,84H                    ; "Ungueltiger Funktionscode in AH"
		JMP     SHORT @@BYE
EMM_ENTRY ENDP

;************************************************************
; simulate INT15/87
;
;INT 15 - SYSTEM - COPY EXTENDED MEMORY (by RBIL)
;
;        AH = 87h
;        CX = number of words to copy (max 8000h)
;        ES:SI -> global descriptor table (see #0403)
;Return: CF set on error
;        CF clear if successful
;        AH = status
;
;Values for extended-memory copy status:
; 00h    source copied into destination
; 01h    parity error
; 02h    interrupt error
; 03h    address line 20 gating failed
; 80h    invalid command (PC,PCjr)
; 86h    unsupported function (XT,PS30)
;
;Format of global descriptor table:
;Offset  Size    Description     (Table 0403)
; 00h 16 BYTEs   zeros (used by BIOS)
; 10h    WORD    source segment length in bytes (2*CX-1 or greater)
; 12h  3 BYTEs   24-bit linear source address, low byte first
; 15h    BYTE    source segment access rights (93h)
; 16h    BYTE    more rights
; 17h    BYTE    8 bit  linear source adress, high
; 18h    WORD    destination segment length in bytes (2*CX-1 or greater)
; 1Ah  3 BYTEs   24-bit linear destination address, low byte first
; 1Dh    BYTE    destination segment access rights (93h)
; 1eh    byte    more rights
; 1fh    BYTE    8 bit  linear source adress, high
;************************************************************

SIMULATE_INT1587 proc near

;        ES:SI -> global descriptor table (see #0403)

		movzx	ecx,cx				; verify size

		jecxz	@@OK				; we are done

		MOVZX   edi,WORD PTR [V8086_ES]; make edi = linear address of command
		SHL     edi,4
		MOVZX   esi,si
		add     edi,esi

		shl		ecx,1				; verify, source and destination
									; descriptors are ok
		cmp		cx, word ptr [edi+10h]
		ja		@@invalid_command

		cmp		cx, word ptr [edi+18h]
		ja		@@invalid_command

		shr		ecx,1
									; we don't care about segment access rights


									; load the source/destination
									; adresses
; 12h  3 BYTEs   24-bit linear source address, low byte first
; 17h    BYTE    8 bit  linear source adress, high
; 1Ah  3 BYTEs   24-bit linear destination address, low byte first
; 1fh    BYTE    8 bit  linear source adress, high

		push edx					; must be protected


		mov dl,[edi+17h]			; get linear source address
		shl edx,8
		mov dl,[edi+14h]
		shl edx,16
		mov dx,[edi+12h]

		mov esi,edx

		mov dl,[edi+1fh]			; get destination source address
		shl edx,8
		mov dl,[edi+1ch]
		shl edx,16
		mov dx,[edi+1ah]

		mov edi,edx

		mov dx,es					; get es=ds
		push ds
		pop es

		cld

		shr ecx,1
		REP MOVS DWORD PTR [ESI],DWORD PTR [EDI];
		BIG_NOP;
		adc ecx,ecx
		REP MOVS WORD PTR [ESI],WORD PTR [EDI];
		BIG_NOP;

		mov es,dx

		pop edx

@@ok:
		mov   AH,0                    ; everything OK and finished
		RET

@@abort:
		mov   AH,1                    ; everything OK and finished
		RET


@@invalid_command:
		mov ah,80h
		ret

SIMULATE_INT1587 endp


CALL_TABLE DW OFFSET GET_STATUS
		   DW OFFSET GET_PAGE_FRAME_ADDRESS
		   DW OFFSET GET_UNALLOCATED_PAGE_COUNT
		   DW OFFSET ALLOCATE_PAGES
		   DW OFFSET MAP_HANDLE_PAGE
		   DW OFFSET DEALLOCATE_PAGES
		   DW OFFSET GET_VERSION
		   DW OFFSET SAVE_PAGES
		   DW OFFSET RESTORE_PAGES
		   DW OFFSET NOT_IMPL
		   DW OFFSET NOT_IMPL
		   DW OFFSET GET_OPEN_HANDLES_COUNT
		   DW OFFSET GET_NR_OF_ALLOCATED_PAGES
		   DW OFFSET GET_ALLOCATED_PAGES
		   DW OFFSET SET_GET_PAGE_MAP


;
; AH = 40h: Den aktuellen Zustand des EMM-Treibers zurueckliefern.
;
GET_STATUS PROC NEAR
		XOR     AH,AH                    ; Immer alles ok.
		RET
GET_STATUS ENDP
;
; AH = 41h: Die Segmentadresse des EMS-Fensters erfragen
;
GET_PAGE_FRAME_ADDRESS PROC NEAR
		XOR     AH,AH                    ; Kein Fehler aufgetreten
		MOV     BX,FS:[_FRAME]           ; Segmentadresse des EMS-Fensters
		RET
GET_PAGE_FRAME_ADDRESS ENDP
;
; AH = 42h: Anzahl der (auch maximal) verfuegbaren EMS-Seiten erfragen
;
GET_UNALLOCATED_PAGE_COUNT PROC NEAR
		XOR     AH,AH
		MOV     BX,FS:[PAGESAVAIL]   ; Anzahl momentan verfuegbarer Seiten
		MOV     DX,FS:[_MAXPAGES]          ; Anzahl maximal verfuegbarer Seiten
		RET
GET_UNALLOCATED_PAGE_COUNT ENDP
;
; AH = 43h: Speicherplatz der EMS-Karte (aehaemm...) reservieren
;
ALLOCATE_PAGES PROC NEAR
		MOV     AH,89H                    ; "Versucht, null Seiten zu
		AND     BX,BX                    ;      reservieren"
		JZ      SHORT @@BYE
		MOV     AH,87H                    ; "Nicht genuegend Seiten vorhanden"
		CMP     BX,FS:[_MAXPAGES]
		JA      SHORT @@BYE
		MOV     AH,88H                    ; "Nicht mehr genuegend Seiten
		CMP     BX,FS:[PAGESAVAIL]   ;  vorhanden"
		JA      SHORT @@BYE
		MOV     ESI,FS:[STATUSTABLE] ; Nun nach einem freien Handle in der
		MOV     ECX,MAX_HANDLES   ; Tabelle forschen
@@SEARCH:
		CMP     WORD PTR [ESI],-2         ; Ist dort noch frei ... ?
		JZ      SHORT @@FOUND
		ADD     ESI,8
		LOOP    @@SEARCH
		MOV     AH,85H                    ; "Kein Handle mehr frei"
@@BYE:  RET

@@FOUND:
		PUSH    BX
		MOV     WORD PTR [ESI],-3         ; Handle als belegt markieren
		SUB     FS:[PAGESAVAIL],BX   ; Seiten vom Pool abziehen
		MOV     DX,MAX_HANDLES           ; Aus CX nun die tatsaechliche Handle-
		SUB     DX,CX                    ; nummer ermitteln, damit die Seiten
		MOV     EDI,FS:[EMSPAGETABLE]; in der Seitenbelegungstabelle als
		MOVZX   ECX,FS:[_MAXPAGES]    ; belegt markiert werden koennen
		MOV     AL,FREEPAGE_ID
@@SEARCH_PAGES:
		REPNZ   SCAS BYTE PTR [EDI]  ; Nach einer freien Seite suchen
		MOV     [EDI-1],DL           ; Dem Handle zuordnen
		DEC     BX                   ; Solange weitermachen, bis alle ge-
		JNZ     SHORT @@SEARCH_PAGES ; wuenschten Seiten belegt sind.
		POP     BX
		XOR     AH,AH
		RET
ALLOCATE_PAGES ENDP
;
; AH = 44h: logische Seite im EMS-Fenster einblenden
;
MAP_HANDLE_PAGE PROC NEAR
		CMP     AL,4                    ; nicht" Es sind nur die Seiten 0
		JAE     SHORT @@PAGE_TO_LARGE ; bis 3 erlaubt !

		CALL    TEST_HANDLE          ; uebergebenes Handle testen
		PUSH    BX                   ; BX retten (da es veraendert wird
		AND     BX,BX                    ; Falls die log. Seitennummer
		JS      SHORT @@MAP          ; negativ ist, keine Suche, da
		INC     BX                   ; Ausblenden
		MOVZX   ECX,FS:[_MAXPAGES]    ; Zu durchforstender Bereich
		PUSH    AX                   ; AL darf nicht zerstoert werden
		MOV     AL,DL                    ; Zu suchendes Handle
		MOV     EDI,FS:[EMSPAGETABLE]; Die Belegungstabelle nach den durch
@@LOOP: REPNZ   SCAS BYTE PTR [EDI]  ; das Handle belegten Seiten absuchen
		JNZ     SHORT @@NIX          ; Aus und vorbei...
		DEC     BX                   ; Die logische Seite ist noch nicht
		JNZ     SHORT @@LOOP         ; erreicht, also weiter !
		MOV     BX,FS:[_MAXPAGES]          ; Nun die absolute logische Seiten-
		SUB     BX,CX                    ; nummer fuer MAP_PAGE berechnen
		DEC     BX
		POP     AX                   ; BI "Schont den Stack"
@@MAP:  CALL    MAP_PAGE
		POP     BX
		XOR     AH,AH
@@BYE:  RET
@@NIX:  POP     AX                   ; Register wiederherstellen
		POP     BX
		MOV     AH,8AH                    ; "log. Seite ausserhalb des
		RET                          ; reservierten Bereichs"

;*******************************************************************************
; here comes the funny part (by tom)
;		during initialization phase, calling EMM_MAP_PAGE (0x44)
;		with pysical page (AL) > 3 is possible.
;		meaning:
;
;		AL = highest 8 bits of logical adress, AL=E4 --> address E4000
;
;		initialization phase is terminated with AL=FF
;*******************************************************************************

@@PAGE_TO_LARGE:
		MOV     AH,8BH                    ; "Angegeb. phys. Seite existiert nicht
		cmp     FS:[_INIT_DONE],0			; still in init phase ?
		jne     @@BYE

		cmp		al,0ffh					; AL=ff finishes init phase
		jne		@@TomsFunnyMapPage

		mov		FS:[_INIT_DONE],1			; finish initialization
		mov		ah,0						; success
		jmp @@BYE

		; the fun part - map in page DX:BX at address AL

@@TomsFunnyMapPage:

		MOV     AH,8BH                    ; "Angegeb. phys. Seite existiert nicht
		AND     BX,BX                     ; Falls die log. Seitennummer
		JS      SHORT @@BYE               ; negativ ist, keine Suche, da

											; code stolen above
											; find the memory for handle/page


		CALL    TEST_HANDLE          ; uebergebenes Handle testen
		PUSH    BX                   ; BX retten (da es veraendert wird
		INC     BX                   ; Ausblenden
		MOVZX   ECX,FS:[_MAXPAGES]    ; Zu durchforstender Bereich
		PUSH    AX                   ; AL darf nicht zerstoert werden
		MOV     AL,DL                    ; Zu suchendes Handle
		MOV     EDI,FS:[EMSPAGETABLE]; Die Belegungstabelle nach den durch
@@XLOOP: REPNZ   SCAS BYTE PTR [EDI]  ; das Handle belegten Seiten absuchen
		JNZ     SHORT @@NIX          ; Aus und vorbei...
		DEC     BX                   ; Die logische Seite ist noch nicht
		JNZ     SHORT @@XLOOP         ; erreicht, also weiter !
		MOV     BX,FS:[_MAXPAGES]          ; Nun die absolute logische Seiten-
		SUB     BX,CX                    ; nummer fuer MAP_PAGE berechnen
		DEC     BX
		POP     AX                   ; BI "Schont den Stack"

;****
;**** stolen from MAP_PAGE
;**** with insertions from frameanchor calculation
;****
										; calculation of 'frame anchor'

		MOVZX   EAX,AL				    ;  00E4 Segmentadresse des Fensters
		shl		EAX,8					; usual format,

		SHL     EAX,4                 ; D0000 ... in absolute Adresse umrechnen
		MOV     ESI,FS:[PAGEDIR]
		SHR     EAX,10                ;
		PUSH    EAX
		SHR     EAX,10                ; Zeiger in das Page Directory er-
		AND     EAX,111111111100B     ; mitteln
		AND     ESI,NOT 111111111111B ; Statusbits herauswerfen
		MOV     ESI,[ESI+EAX]         ; ^ auf Page Table lesen
		POP     EAX
		AND     EAX,111111111100B     ; Das gleiche Spiel von Neuem
		AND     ESI,NOT 111111111111B
		ADD     ESI,EAX

					; MOV     FS:[FRAMEANCHOR],ESI

		; esi = 'frame anchor'


		MOVZX   EDI,BX               ; Aus der Seitennummer (absolut) nun
		SHL     EDI,14                    ; die Lage der EMS-Seite im Extended
		ADD     EDI,FS:[FIRSTPAGE]   ; Memory errechnen.
		ADD     DI,111B                  ; Statusbits: R/W=1,U/S=1,P=1

		MOV     CX,4                    ; 1 EMS entspr. 4 (virtuelle) Seiten
		MOVZX   ECX,CX
@@X2LOOP: MOV     [ESI],EDI                  ; Die neue physikalische Adresse der
		ADD     ESI,4                    ; Fensterseite eintragen
		ADD     EDI,4096                   ; Naechste 4k-Seite bearbeiten
		LOOP    @@X2LOOP

		MOV     ESI,FS:[PAGEDIR]          ; Um Fehler durch den TLB zu
		MOV     CR3,ESI                    ; vermeiden, den TLB durch Laden von


		POP     BX
		XOR     AH,AH
		RET

;*******************************************************************************
; end of fun :-)
;*******************************************************************************


MAP_HANDLE_PAGE ENDP



;
; AH = 45h: Reservierten Speicherplatz wieder freigeben
;
DEALLOCATE_PAGES PROC NEAR
		CALL    TEST_HANDLE          ; Zu allererst...
		MOV     AH,86H                    ; "Es existiert noch ein gesicherter
		CMP     WORD PTR [ESI],-3         ; Zustand" ?
		JNZ     SHORT @@BYE
		PUSH    AX
		MOVZX   ECX,FS:[_MAXPAGES]    ; Alle Seiten in der Belegungstabelle
		MOV     AL,DL                    ; muessen wieder als frei (= 0)
		MOV     EDI,FS:[EMSPAGETABLE]; markiert werden
@@LOOP: REPNZ   SCAS BYTE PTR [EDI]  ; nach Seiten mit Handlenummer
		JNZ     SHORT @@OK           ; absuchen Alles abgearbeitet ?
		MOV     BYTE PTR [EDI-1],FREEPAGE_ID; Die Seite als frei markieren
		INC     FS:[PAGESAVAIL]
		JMP     SHORT @@LOOP
@@OK:   MOV     WORD PTR [ESI],-2    ; Das Handle nun wieder freigeben
		POP     AX
		XOR     AH,AH                    ; Funktion ordnungsgemaess ausgefuehrt
@@BYE:  RET
DEALLOCATE_PAGES ENDP
;
; AH = 46h: Versionsnummer des EMM ermitteln
;
GET_VERSION PROC NEAR
		MOV     AX,0032H                   ; Momentan in der Gegend von 3.2
		RET
GET_VERSION ENDP
;
; AH = 47h: Nummern der eingeblendeten Seiten im EMS-Fenster sichern
;
SAVE_PAGES PROC NEAR
		CALL    TEST_HANDLE
		MOV     AH,8DH                    ; "Zustand fuer Handle bereits
		CMP     WORD PTR [ESI],-3         ;     gesichert"
		JNZ     SHORT @@BYE
SAVE_TO_ESI:                         ; Einsprung aus Funktionen 4Exxh
		PUSH    AX                   ; damit AL gerettet wird
		MOV     AX,FS:[PHYSPAGETABLE]; Die aktuellen logischen S
		MOV     [ESI],AX                   ; im Handle-Status-Bereich ablegen
		MOV     AX,FS:[PHYSPAGETABLE+2]
		MOV     [ESI+2],AX
		MOV     AX,FS:[PHYSPAGETABLE+4]
		MOV     [ESI+4],AX
		MOV     AX,FS:[PHYSPAGETABLE+6]
		MOV     [ESI+6],AX
		POP     AX
		XOR     AH,AH                    ; 'alles ok' vermelden
@@BYE:  RET
SAVE_PAGES ENDP
;
; AH = 48h: Gesicherten Status des EMS-Fensters wiederherstellen
;
RESTORE_PAGES PROC NEAR
		CALL    TEST_HANDLE
		MOV     AH,8EH                    ; "Es existiert kein gesicherter
		CMP     WORD PTR [ESI],-3         ; Zustand"
		JZ      SHORT @@BYE
		CALL    RESTORE_FROM_ESI           ; Heute 'mal indirekt
		MOV     WORD PTR [ESI],-3         ; Nichts gespeichert f. Handle
		XOR     AH,AH                    ; vermerken Alles ok.
@@BYE:  RET
RESTORE_FROM_ESI:                       ; Einsprung aus Funktionen 4Exxh
		PUSH    AX                   ; alles retten! Daten- und System-
		PUSH    BX                   ; register zuerst!
		XOR     AL,AL                    ; Seite 0 wieder einblenden
		MOV     BX,[ESI]
		PUSH    ESI
		CALL    MAP_PAGE
		POP     ESI
		INC     AL                   ; Seite 1 einblenden
		MOV     BX,[ESI+2]
		PUSH    ESI
		CALL    MAP_PAGE
		POP     ESI
		INC     AL                   ; Seite 2
		MOV     BX,[ESI+4]
		PUSH    ESI
		CALL    MAP_PAGE
		POP     ESI
		INC     AL                   ; Seite 3
		MOV     BX,[ESI+6]
		PUSH    ESI
		CALL    MAP_PAGE
		POP     ESI
		POP     BX
		POP     AX
		XOR     AH,AH                    ; Ok melden (wegen Funktion
		RET                          ;  $4E01/$4E02)
RESTORE_PAGES ENDP
;
NOT_IMPL PROC NEAR
		MOV     AH,84H                    ; "Ungueltiger Funktionscode"
		RET
NOT_IMPL ENDP
;
; AH = 4Bh: Anzahl der offenen Handles
;
GET_OPEN_HANDLES_COUNT PROC NEAR
		MOV     ESI,FS:[STATUSTABLE] ; Die Handle-Statustabelle nach ver-
		MOV     CX,MAX_HANDLES           ; gebenen Handles durchsuchen
		XOR     BX,BX
@@LOOP: CMP     WORD PTR [ESI],-2        ; Noch frei ?
		JZ      SHORT @@CLOSED
		INC     BX
@@CLOSED:
		ADD     ESI,8                    ; naechster Eintrag.
		LOOP    @@LOOP
		XOR     AH,AH
		RET
GET_OPEN_HANDLES_COUNT ENDP
;
; AH = 4Ch: Anzahl der reservierten Seiten fuer ein Handle ermitteln
;
GET_NR_OF_ALLOCATED_PAGES PROC NEAR
		CALL    TEST_HANDLE
		PUSH    AX
		MOV     AL,DL                    ; Nach diesem Handle die komplette
		MOVZX   ECX,FS:[_MAXPAGES]    ; Seiten-Belegungstabelle durchsuchen
		MOV     EDI,FS:[EMSPAGETABLE]
		XOR     BX,BX
@@LOOP: REPNZ   SCAS BYTE PTR [EDI]  ; Absuchen ...
		JNZ     SHORT @@OK           ; Nichts mehr gefunden, also fertig
		INC     BX                   ; eine Seite mehr
		JMP     SHORT @@LOOP
@@OK:   POP     AX
		XOR     AH,AH                    ; Ok.
		RET
GET_NR_OF_ALLOCATED_PAGES ENDP
;
; AH = 4Dh: Anzahl der reservierten Seiten fuer alle Handles ermitteln
;
GET_ALLOCATED_PAGES PROC NEAR
		MOVZX   ESI,WORD PTR [V8086_ES]; ES auf dem Level-0-Stack
		SHL     ESI,4                    ; ES:DI ^ auf den Speicherbereich, in
		MOVZX   EDI,DI               ; dem die Tabelle abgelegt wird
		ADD     ESI,EDI
		PUSH    AX
		PUSH    DX
		MOV     EDI,FS:[STATUSTABLE]
		XOR     AX,AX                    ; aktuelle Handle-Nummer
		XOR     BX,BX                    ; bisher kein Handle offen
@@NEXT_HANDLE:
		CMP     WORD PTR [EDI],-2         ; Handle ueberhaupt vergeben ? Wenn
		JZ      SHORT @@NEXT         ; nicht, dann ueberspringen
		INC     BX                   ; Ein Handle mehr ist offen...
		MOV     [ESI],AX                   ; Handle ablegen
		INC     ESI
		INC     ESI
		PUSH    EDI
		MOV     EDI,FS:[EMSPAGETABLE]; Die Anzahl der reservierten Seiten
		XOR     DX,DX                    ; fuer das Handle ermitteln
		MOVZX   ECX,FS:[_MAXPAGES]
@@LOOP: REPNZ   SCAS BYTE PTR [EDI]  ; Seiten-Belegungstabelle abgrasen
		JNZ     SHORT @@NOPE         ; Nichts mehr gefunden
		INC     DX
		JMP     SHORT @@LOOP
@@NOPE: MOV     [ESI],DX                  ; Die Anzahl der ermittelten Seiten
		INC     ESI                  ; ablegen
		INC     ESI
		POP     EDI
@@NEXT: ADD     EDI,8                   ; das naechste Handle, bitte !
		INC     AX
		CMP     AX,MAX_HANDLES           ; Alle Handles abgearbeitet ?
		JB      SHORT @@NEXT_HANDLE
		POP     DX
		POP     AX
		XOR     AH,AH                    ; Alles ok.
		RET
GET_ALLOCATED_PAGES ENDP
;
; AH = 4Eh: Get & Set Map: aehnlich 47h/48h Zustand der Hardware sichern.
;
CHKSUM  MACRO   REG
		MOV     AX,[REG+2]           ; Kontrollsumme bilden
		ADD     AX,[REG+4]
		ADD     AX,[REG+6]
		ADD     AX,[REG+8]
		ENDM

SET_GET_PAGE_MAP PROC NEAR
		CMP     AL,3                    ; Subfunktion 0 bis 3 ?
		JA      SHORT @@NIX_IS
		JZ      SHORT @@SUBF_3          ; Groesse des Feldes
		DEC     AL
		JZ      SHORT @@SUBF_1          ; Set Page Map
; Subf. 2: Get & Set Page Map
; Subf. 0: Get Page Map - Hardwarestatus sichern
@@SUBF_0:
		MOVZX   ESI,WORD PTR [V8086_ES]; ES:DI ^ auf Zustandsfeld im
		SHL     ESI,4                    ; ueblichen REAL-Mode-Format berechnen
		MOVZX   EDI,DI
		ADD     ESI,EDI
		PUSH    AX                   ; Subfunktionscode retten
		ADD     ESI,2                    ; Kontrollsumme momentan ueberspringen
		CALL    SAVE_TO_ESI
		SUB     ESI,2
		CHKSUM  ESI                       ; Kontrollsumme bilden und ...
		MOV     [ESI],AX                   ; ... ablegen
		POP     AX                   ; Subfunktionscode wiederherstellen
		CMP     AL,2                    ; und ueberpruefen, ob Subf. 2
		JZ      SHORT @@SUBF_1          ; gewuenscht ist, da dann auch noch
		XOR     AH,AH                    ; die Subf. 1 auszufuehren ist.
		RET                          ; Alles ok.
; Subf. 1: Set Page Map - Hardwarestatus wiederherstellen
@@SUBF_1:
		MOVZX   EDI,WORD PTR [V8086_DS]; DS:SI ^ auf Zustandsfeld im
		SHL     EDI,4                    ; ueblichen REAL-Mode-Format berechnen
		MOVZX   ESI,SI
		ADD     ESI,EDI
		CHKSUM  ESI                       ; Kontrollsumme bilden und kontrol-
		CMP     [ESI],AX                   ; lieren
		JNZ     SHORT @@CHKERR
		ADD     ESI,2                    ; Kontrollsumme ueberspringen
		JMP     RESTORE_FROM_ESI
; Quersumme ist fehlerhaft !
@@CHKERR:
		MOV     AH,0A3H                    ; Daten sind zerstoert !
		RET
; Subf. 3: Groesse des Feldes
@@SUBF_3:
		MOV     AL,4*2+2                   ; 4 Eintraege  2 Byte + 2 Bytes
		XOR     AH,AH                    ; ChkSum
		RET                          ; Das war's auch schon.

@@NIX_IS:
		MOV     AH,8FH                    ; Ungueltiger Subfunktionscode !
		RET
SET_GET_PAGE_MAP ENDP
;
; Eine logische Seite im EMS-Fenster einblenden.
; AL = phys. Seite 0 - 3, BX = log. Seite (absolut) oder -1
;
MAP_PAGE PROC NEAR
		MOVZX   ESI,AL
		MOV     FS:[PHYSPAGETABLE+ESI*2],BX; Eingeblendete Seite ablegen
		SHL     ESI,4                    ; Den Zeiger auf den entspr. Eintrag
		ADD     ESI,FS:[FRAMEANCHOR] ; im Page Table ermitteln
		AND     BX,BX                    ; log. Seite < 0, dann ausblenden
		JS      SHORT @@UNMAP
		MOVZX   EDI,BX               ; Aus der Seitennummer (absolut) nun
		SHL     EDI,14                    ; die Lage der EMS-Seite im Extended
		ADD     EDI,FS:[FIRSTPAGE]   ; Memory errechnen.
@@SET:  ADD     DI,111B                  ; Statusbits: R/W=1,U/S=1,P=1
		MOV     CX,4                    ; 1 EMS entspr. 4 (virtuelle) Seiten
		MOVZX   ECX,CX
@@LOOP: MOV     [ESI],EDI                  ; Die neue physikalische Adresse der
		ADD     ESI,4                    ; Fensterseite eintragen
		ADD     EDI,4096                   ; Naechste 4k-Seite bearbeiten
		LOOP    @@LOOP
		MOV     ESI,FS:[PAGEDIR]          ; Um Fehler durch den TLB zu
		MOV     CR3,ESI                    ; vermeiden, den TLB durch Laden von
		RET                          ; CR3 leeren
@@UNMAP:
		MOV     ECX,ESI                    ; ESI retten !
		MOVZX   EDI,FS:[_FRAME]             ; Beim Ausblenden gilt "logische =
		SHL     EDI,4                    ; physikalische Adresse"
		SHL     ESI,10
		ADD     EDI,ESI
		MOV     ESI,ECX
		JMP     SHORT @@SET
MAP_PAGE ENDP
;
; Ein gegebenes Handle auf Gueltigkeit ueberpruefen. Falls das Handle
; ungueltig ist, wird die Rueckkehradresse weggeworfen und danach mittels
; RET zum Dispatcher zurueckgekehrt.
;
TEST_HANDLE PROC NEAR
		MOV     AH,83H                    ; "uebergebenes Handle ist unbekannt"
		CMP     DX,MAX_HANDLES           ; Ausserhalb des Bereichs ?
		JAE     SHORT @@BYE
		MOVZX   ESI,DL               ; Den Zeiger auf die Handle-Status-
		SHL     ESI,3                    ; Tabelle formen und ...
		ADD     ESI,FS:[STATUSTABLE]
		CMP     WORD PTR [ESI],-2         ; ... ueberpruefen, ob das Handle als
		JZ      SHORT @@BYE          ; frei markiert ist.
		RET
@@BYE:  POP     SI                   ; Aufrufadresse wegwerfen
		RET
TEST_HANDLE ENDP
;(*-8-*)
V86_LEN         EQU     OFFSET $          ; Ende des Code-Bereichs

V86     ENDS
;
; Installationsteil des virtuellen Monitors, der spaeter wieder an das
; System zurueckgegeben wird.
;

_TEXT SEGMENT
		extrn _startup_driver:far
		extrn _startup_exe:far
		extrn _finishing_touches:far
_TEXT ENDS


_TEXT SEGMENT
		ASSUME  CS:_TEXT,DS:DATA

;*********************************************
; startpoint when executing as EXE
;*********************************************


GO:
		MOV     AX,SEG DATA          ; Datensegment einrichten
		MOV     DS,AX
		MOV     [PSP],ES                   ; PSP fuer spaeter retten

		mov     ax, DGROUP
		mov     ds,ax
		mov     ss,ax
		mov     sp, offset DGROUP:exe_stacktop


		push  es						; startup_exe(commandline);
		mov   ax,080h
		push  ax
		call  _startup_exe
		add sp,4

										; exit
		mov   	ah,04ch					; das wars dann
		int 	21h

;***** exe done



;**********************************************
; driver init part
;**********************************************

go_driver_entry proc far

	push ax
	push bx
	push cx
	push dx
	push si
	push bp
	push ds

	mov word ptr es:[di+3	 ],1000h ; STATUS_BAD

	cmp byte ptr es:[di+2],0 		; command == 0 : do we have to initialize?
	jne driver_done


	push es							; request_ptr, needed later
	push di

	call far ptr  go_driver

	pop di
	pop es					       	; reload address of request header


	or ax,ax						; ax = size of resident code
	jz driver_done

	mov          es:[di+0eh  ],ax   ;
	mov word ptr es:[di+3	 ],0800h ; STATUS_OK


driver_done:
									; we are done,
									; patch the code, calling this
									; driver entry, so we NEVER get called again
	mov bp,sp						;
									; stack frame:
	lds bx, [bp + 14]				; 7*regs, [cs:ip]
	sub bx,5						; call far

	mov byte ptr [bx],0ebh					; JMP $+3
	mov byte ptr [bx+1],03h

	pop ds
	pop bp
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	retf
go_driver_entry ENDP




;struc	request_hdr
;  req_size	db	?		; number of bytes stored
;  unit_id	db	?		; unit ID code
;  cmd		db	?		; command code
;  status	dw	?		; status word
;  rsvd		db	8 dup (?)	; reserved
;ends	request_hdr

;struc	init_strc
;  init_hdr	db	size request_hdr dup (?)
;  units		db	?		; number of supported units
;  end_addr	dd	?		; end address of resident part
;  cmd_line	dd	?		; address of command line
;ends	init_strc

driverss dw 0
driversp dw 0
driverret dw 0

go_driver PROC FAR


	mov cs:[driverret],0
	mov cs:[driverss],ss
	mov cs:[driversp],sp

		mov     ax, DGROUP
		mov     ds,ax
		mov     ss,ax
		mov     sp, offset DGROUP:exe_stacktop




	les ax, es:[di+18]			; fetch driver commandline

	push es                     ; startup_driver(char far *cmdLine)
	push ax
	call _startup_driver
	add sp,4

								;some bugs ??
	or ax,ax
	jnz fail_driver





		XOR     AX,AX                ; zunaechst Reset-Flag
		MOV     DS,AX                    ; zuruecksetzen
		MOV     AX,00AAh                   ; uebliche OK-Meldung
		MOV     WORD PTR DS:[@Reset_flag],AX
		MOV     AX,SEG DATA          ; Datensegment einrichten
		MOV     DS,AX


;(*-9-*)

;        MOV     AH,88H                    ; Groesse des Extended Memorys
;        INT     15H                  ;  ermitteln
;        MOV     [EXTMEM],AX          ; (in kBytes)

		MOV     AX,3567H                   ; alten Inhalt EMM-Vektor retten
		INT     21H
		MOV     WORD PTR [OLDINT67],BX
		MOV     WORD PTR [OLDINT67+2],ES
		MOV     AX,ES                    ; EMM schon eingerichtet ?
		OR      AX,BX                   ;
		JZ      Neu_inst                  ; nein, dann neu
;   **** #### **** zusaetzliche Abfrage nach EMMXXXX0 ********
		MOV     DI,10
		MOV     SI,OFFSET Kennung
		CLD
		MOV     CX,8
		REPZ    CMPSB
		JNZ     Neu_inst

;   **** #### ***********************************************

		mov 	dx, OFFSET msg_already_installed
		jmp 	ERR_EX

Neu_inst:


		MOV     DX,OFFSET DUMMY_CALL ; EMM-Vektor einrichten
		MOV     AX,2567H
		INT     21H
;(*-9-*)
;(#-9-#)
		MOV     AX,3513H                ; Die Adresse des "alten" Disk-
		INT     21H                     ; oder Platten-I/O-Interrupts
		MOV     WORD PTR [OLD13],BX     ; retten und stattdessen die
		MOV     WORD PTR [OLD13+2],ES   ; neuen Routinen einhaengen.
		MOV     DX,OFFSET NEW13
		MOV     AX,2513H
		INT     21H
		MOV     AX,3540H                ; Der reine Disketten-Interrupt
		INT     21H                     ; will aber aus Sicherheits-
		MOV     WORD PTR [OLD40],BX     ; gruenden auch nicht vergessen
		MOV     WORD PTR [OLD40+2],ES   ; sein !
		MOV     DX,OFFSET NEW40
		MOV     AX,2540H
		INT     21H
;(#-9-#)

		MOV     AX,3515H                ; INT 15h mit Move Block und Extended
		INT     21H            		    ; Size sichern und ...
		MOV     WORD PTR [OLDINT15],BX
		MOV     WORD PTR [OLDINT15+2],ES
		MOV     DX,OFFSET NEW15   		; ... stattdessen neue Routine ein-
		MOV     AX,2515H                ; haengen
		INT     21H
;
; Die Tabellen anpassen (Dieser Programmteil uebernimmt die "dankbare"
; Aufgabe, DLL (Dynamik Linking Loader) zu spielen).
;
		MOV     CX,4                    ; Insgesamt 4 GDT-Eintraege muessen
		MOV     SI,OFFSET GDT           ; bearbeitet werden.
		MOV     DX,SEG DATA          ; Beginn des DATA-Segments berechnen
		MOVZX   EDX,DX
		SHL     EDX,4
GDT_LOOP:
		MOVZX   EBX,WORD PTR [SI+2]  ; Basisadresse des Segments einlesen
		AND     EBX,EBX                    ; Null ? Dann uebergehen
		JZ      SHORT GDT_LOOP_CONT
		ADD     EBX,EDX
		MOV     [SI+2],BX            ; Beginn (15..0) schreiben
		SHR     EBX,16
		MOV     [SI+4],BL            ; Bits 23..16 schreiben
GDT_LOOP_CONT:
		ADD     SI,8                    ; Den naechsten Eintrag bearbeiten
		LOOP    GDT_LOOP

		ADD     DWORD PTR [IDT_PTR+2],EDX; Lage von IDT & GDT muss
		ADD     DWORD PTR [GDT_PTR+2],EDX; ebenfalls angepasst werden.

		MOV     WORD PTR [OFFSET LDT+(V86_DATA_SEL AND 0F8H)+2],DX
		SHR     EDX,16
		MOV     BYTE PTR [OFFSET LDT+(V86_DATA_SEL AND 0F8H)+4],DL

		MOV     DX,SEG RESCODE           ; Die Lage des residenten Code-
		MOVZX   EDX,DX               ; segments eintragen.
		SHL     EDX,4
		MOV     WORD PTR [OFFSET GDT+(REAL_SEL AND 0F8H)+2],DX
		SHR     EDX,16
		MOV     BYTE PTR [OFFSET GDT+(REAL_SEL AND 0F8H)+4],DL

		MOV     DX,SEG V86
		MOVZX   EDX,DX
		SHL     EDX,4
		MOV     WORD PTR [OFFSET LDT+(V86_CODE_SEL AND 0F8H)+2],DX
		SHR     EDX,16
		MOV     BYTE PTR [OFFSET LDT+(V86_CODE_SEL AND 0F8H)+4],DL

		MOV     DX,SEG RES_STACK           ; Stack-Segment ebenfalls anpassen
		MOVZX   EDX,DX
		SHL     EDX,4
		MOV     WORD PTR [OFFSET LDT+(V86_STACK_SEL AND 0F8H)+2],DX
		SHR     EDX,16
		MOV     BYTE PTR [OFFSET LDT+(V86_STACK_SEL AND 0F8H)+4],DL

		JMP     FAR PTR GO_PROTECTED ; Es geht los !

ERR_EX: MOV     AH,9
		INT     21H
		jmp fail_driver




;
; Falls die Umschaltung erfolgreich war, werden die restlichen Befehle
; bereits im virtuellen 8086-Modus ausgefuehrt.
;
		public KEEP
KEEP:
		mov     ax, DGROUP
 
		mov     ds,ax
		mov     ss,ax
		mov     sp, offset DGROUP:exe_stacktop


		call  _finishing_touches		; do some postprocessing work

@@IGNORE:
;(*-10-*)
		MOV     AX,OFFSET DRIVERCODE:DATA_END   ; Ende des residenten Datenbereichs

		mov cs:[driverret],ax        ; we want that many bytes remaining

		call PRINT_DEZ

		MOV     AX,SEG DATA          ; Datensegment einrichten
		MOV     DS,AX

		MOV     DX,OFFSET MSGF           ; Fehlermeldung ausgeben...
		MOV     AH,9
		INT     21H


driver_exit:
	mov ss,cs:[driverss]
	mov sp,cs:[driversp]
	mov ax,cs:[driverret]
	retf

fail_driver:
		MOV     AX,SEG DATA          ; Datensegment einrichten
		MOV     DS,AX

		MOV     DX,OFFSET MSGFail           ; Fehlermeldung ausgeben...
		MOV     AH,9
		INT     21H

	jmp driver_exit

go_driver ENDP


;
; ueberpruefen, ob dieses Programm ueberhaupt auf einem 386er-Computer (o.ae.)
; laeuft (... man weiss ja nie...)
;
public _IS386
_IS386 PROC NEAR
		PUSHF                        ; Flags retten
		XOR     AX,AX                    ; Zuerst ueberpruefen, ob ein 8086/88
		PUSH    AX                   ; dieses Programm abarbeitet, da dort
		POPF                         ; der PUSHF-Befehl die Bits 15..12
		PUSHF                        ; immer auf Eins setzt, der 386
		POP     AX                   ; setzt das Bit 15 immer auf Null.
		TEST    AH,80H
		JNZ     SHORT @@NO_386
		MOV     AX,7000H                   ; Der IOPL-Wert bleibt beim 80386
		PUSH    AX                   ; auch bei POPF erhalten
		POPF                         ; beim 286 setzt ihn immer auf Null
		STI
		PUSHF
		POP     AX
		TEST    AX,7000H
		JZ      SHORT @@NO_386
		POPF
		mov ax,1					; OK
		RET
@@NO_386:
		xor ax,ax
		ret
_IS386 ENDP

public _ISPROTECTEDMODE
_ISPROTECTEDMODE proc near
		SMSW    AX
		AND    AX,0001H             ; PE-Bit (Protect Enable) gesetzt ?
		ret
_ISPROTECTEDMODE ENDP

;(*-11-*)
;
; Dezimalzahl in AX ausgeben
;
PRINT_DEZ PROC NEAR
		MOV     BX,10                    ; Basis 10
		XOR     CX,CX                    ; Zaehler fuer die Anzahl der Ziffern
@@DIV:  XOR     DX,DX                ; Mittels Division & Modulo die
		DIV     BX                   ; Ziffern rueckwaerts ermitteln ...
		PUSH    DX                   ; ... und auf dem Stack abladen
		AND     AX,AX                    ; Noch irgendetwas uebrig ?
		LOOPNZ  @@DIV
		NEG     CX                   ; Ergibt die Anzahl der Ziffern
@@PRINT:
		POP     DX                   ; Die einzelnen Ziffern wieder vom
		ADD     DL,'0'                    ; Stack herunterholen (nun in der
		MOV     AH,2                    ; richtigen Reihenfolge)
		INT     21H                  ; und ausgeben
		LOOP    @@PRINT
		RET
PRINT_DEZ ENDP
;(*-11-*)

_TEXT ENDS
;
; Kurzzeitig nach der Installation benoetigter Stack
;
TMP_STACK SEGMENT PARA USE16
		DB      100H DUP (0)         ; Temporaerer Stack
TMP_TOS EQU     $
TMP_STACK ENDS

_STACK	segment
	my_stack db 1024 dup(?)       ; stack for the C - things

	public exe_stacktop
exe_stacktop dw 0

_STACK	ends


		END     GO
