/*  FreeDOS HTML Help Viewer

    HELP - main module

    Copyright (c) Express Software 1998-2003
    See doc\htmlhelp\copying for licensing terms
    Created by: Joseph Cosentino.

    See doc\htmlhelp\history for a chronology of changes
*/

/* D E F I N E S ***********************************************************/

/* This directive is here so that only this file will declare certain
 variables in help.h. Other files that include help.h will extern those
 variables. Hence this is defined before including help.h */
#define HTML_HELP

/* Something similar with conio.h */
#define NOTEXTERN_IN_CONIO

/* Version: Use this to keep the /? command's display of the version up to
            date. Enclose within double-quotes. */
#define HTML_HELP_VERSION "5.3.0"

/* I N C L U D E S *********************************************************/

/* includes */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "help_gui.h"
#include "conio.h"
#include "help.h"

/* M A I N   M O D U L E ***************************************************/

int
main (int argc, char *argv[])
{
  char *showcommand = 0;
  char *oldscreen;
  int i;			/* counter for loop */
  int forcemono = 0;
  int AsciiExtendedChars = 1;

  if (getenv ("HELPPATH") == NULL)
    {
      get_base_dir (argv[0]);
      strcat (base_dir, "..\\help\\");
    }
  else
    {
      strcpy (base_dir, getenv ("HELPPATH"));
      if (base_dir[strlen (base_dir) - 1] != '\\')
	strcat (base_dir, "\\");
      strcpy (home_page, "index.htm");
    }

  if (getenv ("HELPCMD"))
    {
      if (strstr (getenv ("HELPCMD"), "/A"))
	AsciiExtendedChars = 0;
      if (strstr (getenv ("HELPCMD"), "/M"))
	forcemono = 1;
    }

  for (i = 1; i < argc; i++)
    {
      if (argv[i][0] == '/')
	{
	  switch (argv[i][1])
	    {

	    default:
	      printf ("Invalid argument -- %s\n", argv[i] + 1);
	    case '?':
	      show_usage ();
	      return 0;


	    case 'a':
	    case 'A':
	      if (argv[i][2] == 0)
		AsciiExtendedChars = 0;
	      break;

	    case 'h':
	    case 'H':
	      if (argv[i][2] == 0)	/* Only put /h or /H */
		{
		  show_usage ();
		  return 0;
		}
	      else
		{
		  help_page[0] = '#';
		  help_page[1] = 0;
		  strcat (help_page, argv[i] + 2);
		}
	      break;

	    case 'l':
	    case 'L':
	      strcat (base_dir, argv[i] + 2);
	      if (fclose (fopen (base_dir, "r")) == -1)
         {
            /* try adding .htm */
		      strcat (base_dir, ".htm");
            if (fclose (fopen (base_dir, "r")) == -1)
            {
               /* try adding .zip */
               base_dir[strlen(base_dir)-3] = '\0';
               strcat (base_dir, "zip");
               if (fclose (fopen (base_dir, "r")) == -1)
                  base_dir[strlen(base_dir)-4] = '\0';
            }
         }
	      get_home_page (base_dir);
	      get_base_dir (base_dir);
	      break;

	    case 'm':
	    case 'M':
	      if (argv[i][2] == '\0')
		forcemono = 1;
	      else
		{
		  printf ("Invalid argument -- %s\n", argv[i] + 1);
		  show_usage ();
		  return 0;
		}
	      break;

	    case 'o':		/* Override index file path/name */
	    case 'O':
	      strcpy (base_dir, argv[i] + 2);
	      get_home_page (base_dir);
	      get_base_dir (base_dir);
	   }
	}
      else if (showcommand == 0)
	{
	  showcommand = malloc (strlen (argv[i]) + 11);
	  if (!showcommand)
	    {
	      printf ("Could not allocate memory\n");
	      return 0;
	    }
	  sprintf (showcommand, "#%s", argv[i]);
	}
      else
	{
	  printf ("Please specify only one topic\n");
	  show_usage ();
	  return 0;
	}
    }

  conio_init (forcemono);
  if (forcemono == 0)
    {
      oldscreen = malloc (W * H * 2);
      if (oldscreen)
	save_window (X, Y, W, H, oldscreen);
    }
  interactive = 1;
  if (MonoOrColor == COLOR_MODE)
    {
      TEXT_COLOR = C_TEXT_COLOR;
      BOLD_COLOR = C_BOLD_COLOR;
      ITALIC_COLOR = C_ITALIC_COLOR;
      BORDER_BOX_COLOR = C_BORDER_COLOR;
      BORDER_TEXT_COLOR = C_BORDER_TEXT_COLOR;
      LINK_COLOR = C_LINK_COLOR;
      LINK_HIGHLIGHTED_COLOR = C_LINK_HIGHLIGHTED_COLOR;
    }
  else
    {
      TEXT_COLOR = M_TEXT_COLOR;
      BOLD_COLOR = M_BOLD_COLOR;
      ITALIC_COLOR = M_ITALIC_COLOR;
      BORDER_BOX_COLOR = M_BORDER_COLOR;
      BORDER_TEXT_COLOR = M_BORDER_TEXT_COLOR;
      LINK_COLOR = M_LINK_COLOR;
      LINK_HIGHLIGHTED_COLOR = M_LINK_HIGHLIGHTED_COLOR;
    }
  if (AsciiExtendedChars == 0)
    {
      strcpy (Border22f, "+-+( )+-+");
      strcpy (Border22if, "+-+( )+-+");
      BarBlock1 = '.';
      BarBlock2 = '#';
    }
  show_mouse ();
  move_mouse (80, 25);
  html_view (showcommand);
  free (showcommand);
  hide_mouse ();
  if ((oldscreen != 0) && (forcemono == 0))
    {
      load_window (X, Y, W, H, oldscreen);
      free (oldscreen);
    }
  conio_exit ();

  return 0;
}

int checkForFile(char *givenname)
{
   char backupname[257];
   strcpy(backupname, givenname);

   if (fclose (fopen (givenname, "r")) == -1)
   {
      /* try adding .htm */
		strcat (givenname, ".htm");
      if (fclose (fopen (givenname, "r")) == -1)
      {
         /* try adding .zip */
       	strcpy (givenname, backupname);
         strcat (givenname, ".zip");
         if (fclose (fopen (givenname, "r")) == -1)
         {
            strcpy (givenname, backupname);
       		/* This simply can't be opened as a file */
            /* so treat as directory instead with maybe index.htm */
            strcat(givenname, "\\index.htm");
            if (fclose (fopen (givenname, "r")) == -1)
            {
               /* Last chance: may be a directory with a zip in it */
               char *zipdir;
             	strcpy (givenname, backupname);
               if ((zipdir = strrchr(backupname, '\\')) != NULL)
               {
                  strcat(givenname, "\\");
                  strcat(givenname, zipdir+1);
                  strcat(givenname, ".zip");
                  if (fclose (fopen (givenname, "r")) == -1)
                  {
                     strcpy (givenname, backupname);
                     return 1;
                  }
               }
            }
         }
      }
   }
   return 0;
}

void
get_home_page (char *path)
{
  char *p;

  if (path != 0)
    if (path[0] != 0)
      {
	p = path + strlen (path) - 1;

	while (p != path && *p != '\\' && *p != '/')
	  --p;

	if (p[0] == '\\' || p[0] == '/')	/* Went a bit too far back */
	  ++p;

	strncpy (home_page, p, 12);
	home_page[13] = '\0';
      }
}

void
get_base_dir (char *path)
{
  char *p;

  if (path != 0)
    if (path[0] != 0)
      {
	p = path + strlen (path) - 1;
	while (p != path && *p != '\\' && *p != '/')
	  p--;

	if (*p == '\\' || *p == '/')
	  {
	    strncpy (base_dir, path, p - path + 1);
	    base_dir[p - path + 1] = 0;
	  }
	else
	  base_dir[0] = 0;
      }
}

void
show_usage (void)
{
  printf ("FreeDOS HTML Help Viewer " HTML_HELP_VERSION "\n\n"
	  "HELP [options] [topic]\n\n"
	  "Basic Options:\n"
	  "  topic            Show help on this topic\n"
	  "  /?               Displays this help message\n"
	  "  /M               Force monochrome display\n"
	  "  /A               uses ASCII instead of extended characters\n\n"
	  "Advanced Options:\n"
	  "  /O[path[file]]   Overrides the help path\n"
	  "                    (if no file is specified, index.htm is assumed)\n"
	  "  /Lfile           Loads a file other than index.htm relative to the help path\n"
	  "  /Htopic          When the user presses F1 or clicks on \"help on help\"\n"
	  "                   help will search for this topic. Default topic is 'help'\n\n"
	  "Environment Variables:\n"
	  "  HELPPATH         Directory that contains your help files.\n"
	  "  HELPCMD          Can contain /M and /A to make these switches default\n");
}
