/*  HTML Parse Stuff

    Copyright (c) Express Software 1998-2002
    All Rights Reserved.

    Created by: Brian E. Reifsnyder, Paul Hsieh and Robert Platt
*/

/* #define AMP_HASH_MATCH */
/* If this define is uncommented, then the code that supports "&#number;"
   HTML codes is included. This code was here so that unusual ASCII can be
   included in the help files in a 'standard' way. E.g. borders around titles
   Unfortunately, while these codes work well in Internet Explorer, they
   appear as question marks in Netscape Navigator.

   The help files should not then use "&#number;", and so this feature is not
   to be used in help.exe. Since this code increases the binary's size by 5k,
   and is evidently not a universal feature of browsers, it is perhaps best
   if it is not included.

   Standard codes such as "&copy;" and "&nbsp;" are still supported
   even with this define commented out. Only # code support is affected.

   RP
*/


#ifndef PARSE_H_INCLUDED
#define PARSE_H_INCLUDED

/* Tag substition table */
#define TST_ENTRY(b, a) {(b), (a)}
/* #define HYPERLINK_MARKER_ON */

struct tagSubsEntryStruct {
    char * before;
    char * after;
};

typedef struct tagSubsEntryStruct tagSubsEntry;

static tagSubsEntry tagSubsTable1[] = {
    TST_ENTRY ("<h1"  , "<b><h1"),
    TST_ENTRY ("</h1>" , "</h1></b><br>"),
    TST_ENTRY (0       , 0           )
};

static tagSubsEntry tagSubsTable2[] = {
	 TST_ENTRY ("<hr>"  ,
"\n\n  \n\n"),
    TST_ENTRY ("<strong",   "<b"        ),
    TST_ENTRY ("</strong>", "</b>"      ),
    TST_ENTRY ("<code" ,    "<b"        ),
    TST_ENTRY ("</code>",   "</b>"      ),
    TST_ENTRY ("<br>"   ,   "\n"        ),
    TST_ENTRY ("<p>"   ,    "\n\n"      ),
    TST_ENTRY ("</p>"  ,    "\n\n"      ),
    TST_ENTRY ("<ol>"  ,    "\n\n"      ),
    TST_ENTRY ("</ol>" ,    "\n\n"      ),
    TST_ENTRY ("<ul>"  ,    "\n\n"      ),
    TST_ENTRY ("</ul>" ,    "\n\n"      ),
    TST_ENTRY ("<li>"  ,    " \n\007 "  ),
    TST_ENTRY ("<h2"   ,    "\n\n<b"    ),
    TST_ENTRY ("</h2>" ,    "</b>\n"    ),
    TST_ENTRY ("<h3"   ,    "\n\n<b"    ),
    TST_ENTRY ("</h3>" ,    "</b>\n"    ),
    TST_ENTRY ("<pre"  ,    "\n<pre"    ),
    TST_ENTRY ("</pre>",    "\n</pre>"  ),
    TST_ENTRY ("<em"   ,    "<i"        ),
    TST_ENTRY ("</em>" ,    "</i>"      ),
    TST_ENTRY ("<tt"   ,    "<i"        ),
    TST_ENTRY ("</tt>" ,    "</i>"      ),
    TST_ENTRY (0       , 0           )
};

#undef TST_ENTRY

#ifdef _PARSE_C_

/* Escape Code table */

/* ampersand character entity substition table */
#define AST_ENTRY(b, a) {(b), (a)}
/* #define HYPERLINK_MARKER_ON */

struct {
    char * before;
    char after;
} static ampCharEntityTable[] = {
   AST_ENTRY ("&para;", 20),
   AST_ENTRY ("&sect;", 21),
   AST_ENTRY ("&lt;", '<'),
   AST_ENTRY ("&gt;", '>'),
   AST_ENTRY ("&amp;", '&'),
   AST_ENTRY ("&nbsp;", ' '),
   AST_ENTRY ("&quot;", '\"'),
   AST_ENTRY (0        , 0)
};

#ifdef AMP_HASH_MATCH

#define AH_TAB_ENTRY(a) {a, sizeof (a)-3}

static struct {
	char * before;
	unsigned char len;
} tab0[] = {
    AH_TAB_ENTRY ("&#32;"),
    AH_TAB_ENTRY ("&#9786;"),
    AH_TAB_ENTRY ("&#9787;"),
    AH_TAB_ENTRY ("&#9829;"),
    AH_TAB_ENTRY ("&#9830;"),
    AH_TAB_ENTRY ("&#9827;"),
    AH_TAB_ENTRY ("&#9824;"),
    AH_TAB_ENTRY ("&#9679;"),
    AH_TAB_ENTRY ("&#9688;"),
    AH_TAB_ENTRY ("&#9675;"),
    AH_TAB_ENTRY ("&#9689;"),
    AH_TAB_ENTRY ("&#9794;"),
    AH_TAB_ENTRY ("&#9792;"),
    AH_TAB_ENTRY ("&#9834;"),
    AH_TAB_ENTRY ("&#9836;"),
    AH_TAB_ENTRY ("&#9788;"),
    AH_TAB_ENTRY ("&#9658;"),
    AH_TAB_ENTRY ("&#9668;"),
    AH_TAB_ENTRY ("&#8597;"),
    AH_TAB_ENTRY ("&#8252;"),
    AH_TAB_ENTRY ("&#182;"),
    AH_TAB_ENTRY ("&#167;"),
    AH_TAB_ENTRY ("&#9602;"),
    AH_TAB_ENTRY ("&#8616;"),
    AH_TAB_ENTRY ("&#8593;"),
    AH_TAB_ENTRY ("&#8595;"),
    AH_TAB_ENTRY ("&#8594;"),
    AH_TAB_ENTRY ("&#8592;"),
    AH_TAB_ENTRY ("&#8735;"),
    AH_TAB_ENTRY ("&#8596;"),
    AH_TAB_ENTRY ("&#9650;")
};

static struct {
	char * before;
	unsigned char len;
} tab128[] = {
    AH_TAB_ENTRY ("&#199;"),
    AH_TAB_ENTRY ("&#220;"),
    AH_TAB_ENTRY ("&#233;"),
    AH_TAB_ENTRY ("&#226;"),
    AH_TAB_ENTRY ("&#228;"),
    AH_TAB_ENTRY ("&#224;"),
    AH_TAB_ENTRY ("&#229;"),
    AH_TAB_ENTRY ("&#231;"),
    AH_TAB_ENTRY ("&#234;"),
    AH_TAB_ENTRY ("&#235;"),
    AH_TAB_ENTRY ("&#232;"),
    AH_TAB_ENTRY ("&#239;"),
    AH_TAB_ENTRY ("&#238;"),
    AH_TAB_ENTRY ("&#236;"),
    AH_TAB_ENTRY ("&#196;"),
    AH_TAB_ENTRY ("&#197;"),
    AH_TAB_ENTRY ("&#201;"),
    AH_TAB_ENTRY ("&#230;"),
    AH_TAB_ENTRY ("&#198;"),
    AH_TAB_ENTRY ("&#244;"),
    AH_TAB_ENTRY ("&#246;"),
    AH_TAB_ENTRY ("&#242;"),
    AH_TAB_ENTRY ("&#251;"),
    AH_TAB_ENTRY ("&#249;"),
    AH_TAB_ENTRY ("&#376;"),
    AH_TAB_ENTRY ("&#214;"),
    AH_TAB_ENTRY ("&#220;"),
    AH_TAB_ENTRY ("&#162;"),
    AH_TAB_ENTRY ("&#163;"),
    AH_TAB_ENTRY ("&#165;"),
    AH_TAB_ENTRY ("&#8359;"),
    AH_TAB_ENTRY ("&#131;"),
    AH_TAB_ENTRY ("&#225;"),
    AH_TAB_ENTRY ("&#237;"),
    AH_TAB_ENTRY ("&#243;"),
    AH_TAB_ENTRY ("&#250;"),
    AH_TAB_ENTRY ("&#328;"),
    AH_TAB_ENTRY ("&#209;"),
    AH_TAB_ENTRY ("&#170;"),
    AH_TAB_ENTRY ("&#186;"),
    AH_TAB_ENTRY ("&#191;"),
    AH_TAB_ENTRY ("&#8976;"),
    AH_TAB_ENTRY ("&#172;"),
    AH_TAB_ENTRY ("&#189;"),
    AH_TAB_ENTRY ("&#188;"),
    AH_TAB_ENTRY ("&#161;"),
    AH_TAB_ENTRY ("&#171;"),
    AH_TAB_ENTRY ("&#187;"),
    AH_TAB_ENTRY ("&#9617;"),
    AH_TAB_ENTRY ("&#9618;"),
    AH_TAB_ENTRY ("&#9619;"),
    AH_TAB_ENTRY ("&#9474;"),
    AH_TAB_ENTRY ("&#9508;"),
    AH_TAB_ENTRY ("&#9569;"),
    AH_TAB_ENTRY ("&#9570;"),
    AH_TAB_ENTRY ("&#9558;"),
    AH_TAB_ENTRY ("&#9557;"),
    AH_TAB_ENTRY ("&#9571;"),
    AH_TAB_ENTRY ("&#9553;"),
    AH_TAB_ENTRY ("&#9559;"),
    AH_TAB_ENTRY ("&#9565;"),
    AH_TAB_ENTRY ("&#9564;"),
    AH_TAB_ENTRY ("&#9563;"),
    AH_TAB_ENTRY ("&#9488;"),
    AH_TAB_ENTRY ("&#9492;"),
    AH_TAB_ENTRY ("&#9524;"),
    AH_TAB_ENTRY ("&#9516;"),
    AH_TAB_ENTRY ("&#9500;"),
    AH_TAB_ENTRY ("&#9472;"),
    AH_TAB_ENTRY ("&#9532;"),
    AH_TAB_ENTRY ("&#9566;"),
    AH_TAB_ENTRY ("&#9557;"),
    AH_TAB_ENTRY ("&#9562;"),
    AH_TAB_ENTRY ("&#9556;"),
    AH_TAB_ENTRY ("&#9577;"),
    AH_TAB_ENTRY ("&#9574;"),
    AH_TAB_ENTRY ("&#9568;"),
    AH_TAB_ENTRY ("&#9552;"),
    AH_TAB_ENTRY ("&#9580;"),
    AH_TAB_ENTRY ("&#9575;"),
    AH_TAB_ENTRY ("&#9576;"),
    AH_TAB_ENTRY ("&#9572;"),
    AH_TAB_ENTRY ("&#9573;"),
    AH_TAB_ENTRY ("&#9561;"),
    AH_TAB_ENTRY ("&#9560;"),
    AH_TAB_ENTRY ("&#9554;"),
    AH_TAB_ENTRY ("&#9555;"),
    AH_TAB_ENTRY ("&#9579;"),
    AH_TAB_ENTRY ("&#9578;"),
    AH_TAB_ENTRY ("&#9496;"),
    AH_TAB_ENTRY ("&#9484;"),
    AH_TAB_ENTRY ("&#9608;"),
    AH_TAB_ENTRY ("&#9604;"),
    AH_TAB_ENTRY ("&#9612;"),
    AH_TAB_ENTRY ("&#9616;"),
    AH_TAB_ENTRY ("&#9600;"),
    AH_TAB_ENTRY ("&#945;"),
    AH_TAB_ENTRY ("&#946;"),
    AH_TAB_ENTRY ("&#915;"),
    AH_TAB_ENTRY ("&#960;"),
    AH_TAB_ENTRY ("&#931;"),
    AH_TAB_ENTRY ("&#963;"),
    AH_TAB_ENTRY ("&#181;"),
    AH_TAB_ENTRY ("&#947;"),
    AH_TAB_ENTRY ("&#934;"),
    AH_TAB_ENTRY ("&#952;"),
    AH_TAB_ENTRY ("&#937;"),
    AH_TAB_ENTRY ("&#948;"),
    AH_TAB_ENTRY ("&#8734;"),
    AH_TAB_ENTRY ("&#8750;"),
    AH_TAB_ENTRY ("&#949;"),
    AH_TAB_ENTRY ("&#8745;"),
    AH_TAB_ENTRY ("&#8801;"),
    AH_TAB_ENTRY ("&#177;"),
    AH_TAB_ENTRY ("&#8805;"),
    AH_TAB_ENTRY ("&#8804;"),
    AH_TAB_ENTRY ("&#8992;"),
    AH_TAB_ENTRY ("&#8993;"),
    AH_TAB_ENTRY ("&#247;"),
    AH_TAB_ENTRY ("&#8776;"),
    AH_TAB_ENTRY ("&#176;"),
    AH_TAB_ENTRY ("&#9679;"),
    AH_TAB_ENTRY ("&#9642;"),
    AH_TAB_ENTRY ("&#8730;"),
    AH_TAB_ENTRY ("&#8319;"),
    AH_TAB_ENTRY ("&#178;"),
    AH_TAB_ENTRY ("&#149;"),
    AH_TAB_ENTRY ("&#32;")
};

#undef AH_TAB_ENTRY
#endif

#endif

void tags2lwr(char *text);
int simpleTagSubstitutions (
     struct eventState * pes, tagSubsEntry *tagSubsTable);
int headerTagSubstitution (struct eventState *pes);
void preformatTrim (char *text);
void wordwrap (char *text);
void sensiblebreaks (char *text);
#ifdef AMP_HASH_MATCH
int ampHashMatch (struct eventState * pes);
#endif
int ampSubs (struct eventState * pes);
int link_length (char *link_text);

#endif
