/*
// Program:  Format
// Version:  0.91g
// (0.90b/c/d - better error messages - Eric Auer - May 2003)
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  userint.c
// Module Description:  User interfacing functions.
*/

/* #include <stdlib.h> */ /* no // comments for Turbo C! -ea */


#define USERINT

#include <dos.h>
#include <ctype.h>	/* toupper */
#include <string.h>	/* strlen  */
#include <io.h>		/* write (to stderr) */

#include "format.h"
#include "userint.h"




void ASCII_CD_Number(unsigned long number)
{
  int comma_counter;
  int index;
  int right_index;
  int shift_counter;
  int shift_register;
  int shift_temp_register;
  int start_shift;

  index=0;

  do
    {
    ascii_cd_number[index]=0;

    index++;
    }while(index<14);

  ultoa(number,ascii_cd_number,10);

  /* Add Commas */
  index=13;
  right_index=13;
  start_shift=FALSE;

  do
    {
    if(ascii_cd_number[index]>0) start_shift=TRUE;

    if(start_shift==TRUE)
      {
      ascii_cd_number[right_index]=ascii_cd_number[index];
      ascii_cd_number[index]=0;
      right_index--;
      }

    index--;
    }while(index>=0);

  comma_counter=0;
  index=13;
  do
    {
    comma_counter++;

    if(ascii_cd_number[index]==0)
      {
      comma_counter=5;
      ascii_cd_number[index]=' ';
      }

    if(comma_counter==4)
      {
      shift_counter=index-1;
      shift_register=ascii_cd_number[index];
      ascii_cd_number[index]=',';
      do
	{
	shift_temp_register=ascii_cd_number[shift_counter];
	ascii_cd_number[shift_counter]=shift_register;
	shift_register=shift_temp_register;

	shift_counter--;
	}while(shift_counter>=0);

      comma_counter=0;
      }

    index--;
    }while(index>=0);

  ascii_cd_number[14]=0;
}

void Ask_User_To_Insert_Disk()
{
  printf(" Insert new diskette for drive %c:\n",param.drive_letter[0]);
  write(2, " Press ENTER when the right disk is in drive...",
    strlen(" Press ENTER when the right disk is in drive..."));
  /* write to STDERR for the case of STDOUT being redirected */

  /* Wait for a key */

  regs.h.ah = 0x08;
  intdos(&regs, &regs);

  printf("\n\n");
}

void Confirm_Hard_Drive_Formatting()
{

  printf("\n WARNING: ALL DATA ON NON-REMOVABLE DISK\n");
  printf(" DRIVE %c: WILL BE LOST! PLEASE CONFIRM!\n",
    param.drive_letter[0]);
  /* printf(" Proceed with Format (YES/NO)? "); */
  write(2, " Proceed with Format (YES/NO)? ",
    strlen(" Proceed with Format (YES/NO)? "));
  /* write to STDERR for the case of STDOUT being redirected */

  /* Get keypress */
  regs.h.ah = 0x07;
  intdos(&regs, &regs);
  printf("%c",regs.h.al);

  if ( toupper(regs.h.al) != 'Y' )
    {
    printf("\n");
    exit(10);
    }

  /* Get keypress */
  regs.h.ah = 0x07;
  intdos(&regs, &regs);
  printf("%c",regs.h.al);

  if ( toupper(regs.h.al) != 'E' )
    {
    printf("\nYou have to type the whole word YES to confirm.");
    exit(10);
    }

  /* Get keypress */
  regs.h.ah = 0x07;
  intdos(&regs, &regs);
  printf("%c",regs.h.al);

  if ( toupper(regs.h.al) != 'S' )
    {
    printf("\nYou have to type the whole word YES to confirm.");
    exit(10);
    }

  printf("\n");
}


void Critical_Error_Handler(int source, unsigned int error_code)
{
  unsigned int error_code_high = (error_code & 0xff00) >> 8;
  unsigned int error_code_low  = error_code & 0x00ff;

  if(source==BIOS) {
    error_code_high = error_code_low;
    error_code_low  = 0x00;
    printf("\n Critical error encountered while using INT 13 disk driver");
  } else {
    printf("\n Critical error encountered while using DOS disk driver");
  }

  /* Display Status Message. */

  if (source==BIOS) {
    printf("\n INT 13 status (hex): %2.2x", error_code_high);

    printf("\n   Bits: ");
    /* changed to allow bit fields -ea */
    if (error_code_high == 0x00) printf("none ");
    if (error_code_high & 0x01) printf("bad command ");
    if (error_code_high & 0x02) printf("bad address mark ");
    if (error_code_high & 0x04) printf("requested sector not found ");
    if (error_code_high & 0x08) printf("DMA troubles ");
    if (error_code_high & 0x10) printf("data error (bad CRC) ");
    if (error_code_high & 0x20) printf("controller failed ");
    if (error_code_high & 0x40) printf("seek operation failed ");
    if (error_code_high & 0x80) printf("timeout / no response ");

    printf("\n   Description: "); /* *** marks popular errors */
    switch (error_code_high) {
      case 0x01: printf("invalid function or parameter"); break;
      case 0x02: printf("address mark not found"); break; /* *** */
      case 0x03: printf("DISK WRITE-PROTECTED"); break; /* *** */
      case 0x04: printf("read error / sector not found"); break; /* *** */
      case 0x05: printf("harddisk reset failed"); break;
      case 0x06: printf("FLOPPY CHANGED"); break; /* *** */
      case 0x07: printf("drive parameter error"); break;
      case 0x08: printf("DMA overrun"); break;
      case 0x09: printf("DMA across 64k boundary attempted"); break; /* *** */
      case 0x0a: printf("bad sector on harddisk"); break;
      case 0x0b: printf("bad track on harddisk"); break;
      case 0x0c: printf("invalid media / track out of range"); break; /* *** */
      case 0x0d: printf("illegal sectors / track (PS/2)"); break;
      case 0x0e: printf("harddisk control data address mark detected"); break;
      case 0x0f: printf("harddisk DMA arbitration level overflow"); break;
      case 0x10: printf("READ ERROR (CRC/ECC wrong)"); break; /* *** */
      case 0x11: printf("read error corrected by CRC/ECC"); break;
      case 0x20: printf("controller failure"); break;
      case 0x31: printf("no media in drive"); break; /* (int 13 extensions) */
      case 0x32: printf("invalid CMOS drive type"); break; /* (Compaq) */
      case 0x40: printf("Seek failed"); break; /* *** */
      case 0x80: printf("timeout (drive not ready)"); break; /* *** */
      case 0x0aa: printf("timeout (harddisk not ready)"); break;
      case 0x0b0: printf("volume not locked in drive"); break; /* int 13 ext */
      case 0x0b1: printf("volume locked in drive"); break; /* int 13 ext */
      case 0x0b2: printf("volume not removable"); break; /* int 13 ext */
      case 0x0b3: printf("volume in use"); break; /* int 13 ext */
      case 0x0b4: printf("volume lock count overflow"); break; /* int 13 ext */
      case 0x0b5: printf("eject failed"); break; /* int 13 ext */
      case 0x0b6: printf("volume is read protected"); break; /* int 13 ext */
      case 0x0bb: printf("general harddisk error"); break;
      case 0x0cc: printf("harddisk WRITE ERROR"); break;
      case 0x0e0: printf("harddisk status register error"); break;
      case 0x0ff: printf("harddisk sense operation failed"); break;
      default: printf("(unknown error code)"); break;
    } /* switch */
  } /* BIOS */
  else
  { /* DOS */

    printf("\n DOS driver error (hex): %2.2x", error_code_low);

    printf("\n   Description: ");
    switch (error_code_low) {
      case 0x00: printf("write-protection violation attempted / none"); break;
      case 0x01: printf("unknown unit for driver"); break;
      case 0x02: printf("drive not ready"); break;
      case 0x03: printf("unknown command given to driver"); break;
      case 0x04: printf("data error (bad CRC)"); break;
      case 0x05: printf("bad device driver request structure length"); break;
      case 0x06: printf("seek error"); break;
      case 0x07: printf("unknown media type"); break;
      case 0x08: printf("sector not found"); break;
      case 0x09: printf("printer out of paper"); break;
      case 0x0a: printf("write fault"); break;
      case 0x0b: printf("read fault"); break;
      case 0x0c: printf("general failure"); break;
      case 0x0d: printf("sharing violation"); break;
      case 0x0e: printf("lock violation"); break;
      case 0x0f: printf("invalid disk change"); break;
      case 0x10: printf("FCB unavailable"); break;
      case 0x11: printf("sharing buffer overflow"); break;
      case 0x12: printf("code page mismatch"); break;
      case 0x13: printf("out of input"); break;
      case 0x14: printf("insufficient disk space"); break;
      default: printf("(unknown error code)"); break;
    } /* switch */
  } /* DOS */

  /* *** We should probably allow an IGNORE or RETRY in *some* cases! *** */

  printf("\n Program terminated.\n");

  exit(1);
}

void Display_Drive_Statistics()
{

  drive_statistics.allocation_units_available_on_disk
    = drive_statistics.bytes_total_disk_space
    / drive_statistics.bytes_in_each_allocation_unit;

  drive_statistics.bytes_available_on_disk
    = drive_statistics.bytes_total_disk_space
    - ( drive_statistics.allocation_units_with_bad_sectors
      * drive_statistics.bytes_in_each_allocation_unit );

  ASCII_CD_Number(drive_statistics.bytes_total_disk_space);
  printf("\n%13s bytes total disk space\n",ascii_cd_number);

  if (drive_statistics.bytes_in_bad_sectors > 0) /* changed 0.91c */
    {
    ASCII_CD_Number(drive_statistics.bytes_in_bad_sectors);
    printf("%13s bytes in bad sectors\n",ascii_cd_number);
    ASCII_CD_Number(drive_statistics.bytes_total_disk_space -
      drive_statistics.bytes_available_on_disk);
    printf("%13s bytes in clusters with bad sectors\n",ascii_cd_number);
    }

  ASCII_CD_Number(drive_statistics.bytes_available_on_disk);
  printf("%13s bytes available on disk\n",ascii_cd_number);

  printf("\n");

  ASCII_CD_Number(drive_statistics.bytes_in_each_allocation_unit);
  printf("%13s bytes in each allocation unit.\n",ascii_cd_number);

  ASCII_CD_Number(drive_statistics.allocation_units_available_on_disk);
  printf("%13s allocation units on disk.\n",ascii_cd_number);

  if (drive_statistics.allocation_units_with_bad_sectors > 0) /* 0.91c */
    {
    ASCII_CD_Number(drive_statistics.allocation_units_with_bad_sectors);
    printf("%13s of the allocation units marked as bad\n",ascii_cd_number);
    }

  printf("\n Volume Serial Number is %04X-%04X\n",
   drive_statistics.serial_number_high, drive_statistics.serial_number_low);
}

void Display_Invalid_Combination()
{
  printf("\n Invalid combination of options... please read documentation.\n");
  printf(" Operation Terminated.\n");
  exit(4);
}

/* Help Routine (removed legacy stuff in 0.91c, but it is still parsed) */
/* There should be an help file which explains everything in detail,    */
/* including the (hardly ever used but still supported) legacy options! */
void Display_Help_Screen()
{
  printf("FreeDOS %6s Version %s\n",NAME,VERSION);
  printf("Written by Brian E. Reifsnyder (and several contributors).\n");
  printf("Copyright 1999 - 2003 under the terms of the GNU GPL, Version 2.\n\n");
  printf("Syntax:\n\n");
#if LEGACY_HELP /* with legacy stuff */
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/F:size] [/B | /S] [/D]\n");
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/T:tracks /N:sectors] [/B | /S] [/D]\n");
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/4] [/B | /S] [/D]\n");
  printf("FORMAT drive: [/Q] [/U] [/1] [/4] [/8] [/B | /S] [/D]\n\n");
#else /* new - without legacy stuff */
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/F:size] [/S] [/D]\n");
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/T:tracks /N:sectors] [/S] [/D]\n");
  /* the /4 option is a legacy shorthand for size selection: 360k in 1.2M drive */
  /* (drive type detection and "double stepping" setting are automatic on ATs.) */
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/4] [/S] [/D]\n\n");
#endif

  printf(" /V:label   Specifies a volume label for the disk, stores date and time of it.\n");
  printf(" /S         Calls SYS to make the disk bootable and to add system files.\n");

#if LEGACY_HELP /* legacy, DOS 1.x (/B cannot be combined with /S) */
  printf(" /B         Kept for compatibility, formerly reserved space for the boot files.\n");
#endif  
  printf(" /D         Be very verbose and show debugging output. For bug reports.\n");

  printf(" /Q         Quick formats the disk. If not combined with /U, can be UNFORMATed.\n");
  printf(" /U         Unconditionally formats the disk. Lowlevel format if floppy disk.\n");

  printf(" /F:size    Specifies the size of the floppy disk to format. Normal sizes are:\n");
  printf("            360, 720, 1200, 1440, or 2880 (unit: kiloBytes). /F:0 shows a list.\n");
  printf(" /4         Formats a 360k floppy disk in a 1.2 MB floppy drive.\n");
  printf(" /T:tracks  Specifies the number of tracks on a floppy disk.\n");
  printf(" /N:sectors Specifies the number of sectors on a floppy disk.\n");

#if LEGACY_HELP /* legacy, DOS 1.x */
  printf(" /1         Formats a single side of a floppy disk (160k / 180k).\n");
  printf(" /8         Formats a 5.25\" disk with 8 sectors per track (160k / 320k).\n");
#endif  
}

void Display_Percentage_Formatted(unsigned long percentage)
{
  if (debug_prog==TRUE)
    {
    printf("%3d%% done. ", percentage);
    }
  else
    {
    printf("%3d percent completed.", percentage);
    }

  if (debug_prog!=TRUE)
    {
    /* Re-position cursor back to the beginning of the line */
    printf("\r");
    }
}

void IllegalArg(char *option, char *argptr)
{
    printf("Parameter value not allowed - %s%s\n", option, argptr);
    exit(1);
}

