/*
// Program:  Format
// Version:  0.91g
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  hdisk.c
// Module Description:  Hard Drive Specific Functions
*/

#define HDISK


#include <stdlib.h>

#include "floppy.h"
#include "format.h"
#include "createfs.h"
#include "btstrct.h"
#include "hdisk.h"


void Get_Device_Parameters()
{
  unsigned long error_code = 0;

  if(debug_prog==TRUE)
    {
    printf("[DEBUG]  Enter Get_Device_Parameters() function\n");
    }

  parameter_block.bpb.bytes_per_sector = 0;		/* *** */
  parameter_block.bpb.sectors_per_cluster = 0;		/* *** */
  parameter_block.bpb.number_of_fats = 0;		/* *** */

  /* Get the device parameters for the logical drive */

  regs.h.ah=0x44;                     /* IOCTL Block Device Request          */
  regs.h.al=0x0d;
  regs.h.bl=param.drive_number + 1;
  regs.h.ch=0x08;                     /* Always 0x08...unless fs is FAT32                         */
  regs.h.cl=0x60;                     /* Get device parameters               */
  regs.x.dx=FP_OFF(&parameter_block);
  sregs.ds =FP_SEG(&parameter_block);
  parameter_block.use_current_bpb = 0;		/* bit 0 clear = we want the DEFAULT BPB only! */
  parameter_block.use_track_layout_fields = 0;
  parameter_block.all_sectors_same_size = 1;	/* bit 2 must be set */
  parameter_block.reserved = 0;
  parameter_block.bpb.sectors_per_fat = 0xffff; /* *** */
  intdosx(&regs, &regs, &sregs);

  error_code = regs.h.al;

  if ( (regs.x.cflag != 0) ||
       (parameter_block.bpb.sectors_per_fat == 0xffff) )
    {
    /* Add error trapping here */
    printf("\nCall to int 0x21, 0x440d 0x60, failed error %02x.\n", error_code);
    exit(1);
    }

  if (parameter_block.bpb.sectors_per_fat == 0)
    /* FAT32 stores 0 in this WORD and uses a DWORD elsewhere instead */
    {
    /* Ok, this is assumed to be a FAT32 partition and it will be       */
    /* formatted as such.                                               */

    if(debug_prog==TRUE)
      {
      printf("[DEBUG]  FAT32 detected.\n");
      }

    param.fat_type = FAT32;

    /* Get the device parameters for the logical drive */

    regs.h.ah=0x44;                     /* IOCTL Block Device Request          */
    regs.h.al=0x0d;
    regs.h.bl=param.drive_number + 1;
    regs.h.ch=0x48;                     /* Always 0x48 for FAT32                         */
    regs.h.cl=0x60;                     /* Get device parameters               */
    regs.x.dx=FP_OFF(&parameter_block);
    sregs.ds =FP_SEG(&parameter_block);
    parameter_block.use_current_bpb = 0;	/* we only want the DEFAULT BPB */
    parameter_block.use_track_layout_fields = 0;
    parameter_block.all_sectors_same_size = 1;
    parameter_block.reserved = 0;
    parameter_block.bpb.sectors_per_fat = 1; /* *** */

    intdosx(&regs, &regs, &sregs);

    error_code = regs.h.al;

    if (regs.x.cflag || (parameter_block.bpb.sectors_per_fat == 1))
      {
      /* Add error trapping here */
      printf("\nCall to int 0x21, 0x440d 0x60, failed error %02x.\n", error_code);
      exit(1);
      }

    }

  if (error_code!=0)
    printf("Error code: %ul,\n", error_code);
  if (debug_prog==TRUE)
    printf("[DEBUG]  Exit Get_Device_Parameters() function\n");

}

/* formerly called Set_DPB_Access_Flag, this function    */
/* forces re-creation of DPB when drive is next accessed */
void Force_Drive_Recheck()
{
  regs.h.ah = 0x0d; /* reset disk system of DOS, flush buffers */
  intdos(&regs, &regs);
  
  regs.h.ah = 0x32; /* force re-reading of boot sector */
  regs.h.dl = param.drive_number + 1;
  intdosx(&regs, &regs, &sregs);	/* DS:BX is DPB pointer on return - ignored! */
  segread(&sregs);			/* restore defaults */

  if (param.fat_type == FAT32)
    {
    /* structure is DW size 0x18, DW 0, DD function (2 "force media change"),
     * plus 0x10 unused bytes */
    union REGS r;
    struct SREGS s;
    char some_struc[0x20];
    memset(some_struc,0, 0x20);
    some_struc[0] = 0x18;
    some_struc[4] = 2;
    r.x.ax = 0x7304;		/* get/set FAT32 flag stuff */
    s.es   = FP_SEG(&some_struc[0]);
    r.x.di = FP_OFF(&some_struc[0]);
    r.h.dl = param.drive_number+1; /* A: is 1 etc. */
    r.x.cx = 0x18; /* structure size */
    intdosx(&r, &r, &s);
    segread(&sregs);		/* restore defaults */
    } /* FAT32 */
}

/*
 * Do everything to find a correct BPB and stuff.
 * Added extra sanity checks in 0.91e...
 * FAT type detection improved, too.
 */
void Set_Hard_Drive_Media_Parameters()
{
  /* int index; */
  /* int result; */
  int i;

  unsigned long number_of_sectors;

  param.media_type = HD;
  param.fat_type = FAT12; /* assume FAT12 first */

  Get_Device_Parameters();

  if (parameter_block.bpb.total_sectors!=0) /* 16bit value? */
    {
    number_of_sectors = parameter_block.bpb.total_sectors;
    }
  else /* else 32bit value */
    {
    number_of_sectors =  parameter_block.bpb.large_sector_count_high;
    number_of_sectors =  number_of_sectors<<16;
    number_of_sectors += parameter_block.bpb.large_sector_count_low;
    }

  /* *** drive_specs[HD].total_logical_sectors=number_of_sectors; *** */

  /* Copy the returned BPB information into drive_specs. */
  memcpy(&drive_specs[HD].bytes_per_sector,
    &parameter_block.bpb.bytes_per_sector, sizeof(STD_BPB));


  if (parameter_block.bpb.bytes_per_sector != 512) /* SANITY CHECK */
    {
    printf("Not 512 bytes per sector - aborting.\n");
    exit(1);
    }

  if ((parameter_block.bpb.number_of_fats<1) ||
      (parameter_block.bpb.number_of_fats>2)) /* SANITY CHECK */
    {
    printf("Not 1 or 2 FATs - aborting.\n");
    exit(1);
    }

  i = parameter_block.bpb.sectors_per_cluster;
  while ((i < 64) && (i != 0)) 
    i += i;	/* shift left until 32k / cluster */
  if (i != 64) /* SANITY CHECK */
    {
    i = parameter_block.bpb.sectors_per_cluster;
    printf("FATAL: Cluster size not 0.5, 1, 2, 4, 8, 16 or 32k but %d.%dk!\n",
      i/2, (i & 1) ? 5 : 0);
    exit(1);
    }

  Get_FS_Info(); /* create FS info from BPB */
  /* calculates things like FAT and cluster size */
  /* e.g. total_clusters is created from 16 or 32bit drive size etc. */

  if (file_sys_info.total_clusters > 65525L)
    {
    if (param.fat_type!=FAT32)
      printf("Almost formatted FAT32 drive as FAT1x, phew...\n");
    param.fat_type = FAT32;
    }
  else
    {
    if (param.fat_type==FAT32)
      printf("Almost formatted FAT1x drive as FAT32, phew...\n");
    param.fat_type = (file_sys_info.total_clusters>=4085) ? FAT16 : FAT12;
    }

  param.size=number_of_sectors/2048;

	/* *** drive_specs[HD] already is a memcpy of the BPB which *** */
	/* *** we had from parameter_block.bytes_per_sector, 25byt  *** */
	/* *** if FAT32, there is also bpb_fat32_ext with 27by more *** */

  drive_statistics.bytes_total_disk_space
    = ((unsigned long)drive_specs[param.media_type].bytes_per_sector
      * number_of_sectors)
    - ((1+(2*(unsigned long)drive_specs[param.media_type].sectors_per_fat)
    + ((unsigned long)drive_specs[param.media_type].root_directory_entries/16))
    * (unsigned long)drive_specs[param.media_type].bytes_per_sector);
  drive_statistics.bytes_available_on_disk
    = drive_statistics.bytes_total_disk_space;

  drive_statistics.bytes_in_each_allocation_unit
    = (unsigned long)drive_specs[param.media_type].sectors_per_cluster
    * (unsigned long)drive_specs[param.media_type].bytes_per_sector;
   
  printf("Formatting as FAT%d.\n",
    (param.fat_type==FAT32) ? 32 : ( (param.fat_type==FAT16) ? 16 : 12 ) );
}
