/*
// Program:  Format
// Written By:  Brian E. Reifsnyder
// Version:  0.91
// (0.90b ... 0.90f are updates by Eric Auer 2003)
// Copyright:  2002 under the terms of the GNU GPL, Version 2.
// Module Name:  FORMAT.H
// Module Description:  Main header file for format.
*/

/*
/////////////////////////////////////////////////////////////////////////////
//  SPECIAL
/////////////////////////////////////////////////////////////////////////////
*/

#define NAME "Format"
#define VERSION "0.91b"


#ifdef MAIN
#define EXTERN /**/
int debug_prog=0; /* now controlled by the /D command line argument */
#else
#define EXTERN extern
extern int debug_prog;
#endif



#include <dos.h>
#include <stdio.h>  /* printf */
#include <stdlib.h> /* exit */
#include <mem.h>    /* memset memcpy */

/*
/////////////////////////////////////////////////////////////////////////////
//  DEFINES
/////////////////////////////////////////////////////////////////////////////
*/


#define MEG 1048576

#define PRIMARY 1
#define EXTENDED 2
#define LOGICAL 3
#define SPECIAL 4

#define LAST 99

#define TRUE  1
#define FALSE 0

#define HARD   0
#define FLOPPY 1

#define FAT12 1
#define FAT16 2
#define FAT32 3

#define MAX_BAD_SECTORS 1024


#define UNUSED     99

#define READ       25
#define WRITE      26

#define UNKNOWN 99

#define BIOS 1
#define DOS  2

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL VARIABLES
/////////////////////////////////////////////////////////////////////////////
*/

EXTERN char ascii_cd_number[15];
EXTERN char partition_label[16];

/* Buffers */
EXTERN unsigned long bad_sector_map[(MAX_BAD_SECTORS+1)];
EXTERN unsigned int bad_sector_map_pointer;

EXTERN unsigned char fat12_fat[6145];

EXTERN unsigned char mirror_map[8192];

/* Ending Mapping Variables */
EXTERN long computed_ending_cylinder;
EXTERN unsigned long computed_partition_size;

/* Integers converted from long numbers */
EXTERN int integer3;
EXTERN int integer4;

EXTERN union  REGS  regs;
EXTERN struct SREGS sregs;

/*
/////////////////////////////////////////////////////////////////////////////
//  GLOBAL STRUCTURES
/////////////////////////////////////////////////////////////////////////////
*/

typedef struct Access_Flags
  {
  unsigned char special_function;      /* Set to 0.                        */
  unsigned char disk_access;           /* Set to non-zero to allow access. */
  } AF;

typedef struct Drive_Statistics
  {
  unsigned long bytes_total_disk_space;
  unsigned long bytes_in_bad_sectors;
  unsigned long bytes_available_on_disk;

  unsigned long bytes_in_each_allocation_unit;
  unsigned long allocation_units_available_on_disk;

  unsigned int serial_number_low;
  unsigned int serial_number_high;
  } DS;

typedef struct Formatting_Parameters
  {
  char drive_letter[2];
  char volume_label[12];

  char existing_format;           /* TRUE or FALSE */

  int drive_type;                 /* FLOPPY or HARD */
  int drive_number;
  int physical_drive_number;
  int partition_number;
  int fat_type;
  int media_type;                 /* FD#### or HD */

  int force_yes;
  int verify;

  unsigned long first_data_sector;

  int v;
  int q;
  int u;
  int f;
  int b;
  int s;
  int t;
  int n;
  int one;
  int four;
  int eight;

  unsigned long size;
  unsigned long cylinders;
  unsigned long sectors;
  unsigned long sides; /* for /1 processing -ea */

  } FP;

typedef struct DDPT_Structure /* see floppy.c for understanding this */
{
  unsigned step_rate : 4 ;       /* 0, HI4 */
  unsigned head_unload_time : 4; /* 0, LO4 */
  unsigned head_load_time : 7;   /* 1, HI7 */
  unsigned dma_flag : 1;         /* 1, LO1 */
  unsigned post_rt_of_disk_motor : 8; /* 2 */
  unsigned sector_size : 8;           /* 3 */
  unsigned sectors_per_cylinder : 8;  /* 4 */
  unsigned gap3_length_rw : 8;   /* !!!  5 */
  unsigned dtl : 8;              /* !!!  6 */
  unsigned gap3_length_xmat : 8; /* !!!  7 */
  unsigned fill_char_xmat : 8;        /* 8 */
  unsigned head_settle_time : 8;      /* 9 */
  unsigned run_up_time : 8;           /* a */
} DDPT;

typedef struct DPB_Structure {
  /* Standard DPB */
  unsigned char drive_number;
  unsigned char device_driver_unit_number;
  unsigned int  bytes_per_sector;
  unsigned char sectors_per_cluster_minus_one;
  unsigned char sectors_per_cluster_power_two;
  unsigned int  beginning_fat_sector;
  unsigned char number_fat_copies;
  unsigned int  number_root_directory_entries;
  unsigned int  first_data_cluster;
  unsigned int  number_clusters_plus_one;
  unsigned int  sectors_per_fat;
  unsigned int  first_root_directory_sector;
  unsigned long device_driver_address;
  unsigned char media_descriptor;
  unsigned char dpb_access_flag;
  unsigned long next_dpb_pointer;
  unsigned int  last_cluster_allocated;
  unsigned int  number_free_clusters;
  /* FAT32 DPB */
  unsigned int  number_free_clusters_high;
  unsigned      do_not_mirror_fat   : 1;
  unsigned      reserved            : 3;
  unsigned      active_fat_number   : 4;
  unsigned int  info_sector_number;
  unsigned int  backup_boot_sector_number;
  unsigned long first_sector_number_first_clust;
  unsigned long max_clust_number;
  unsigned long number_sectors_per_fat;
  unsigned long root_dir_start_cluster;
  unsigned long free_space_start_cluster;
  }DPB;

typedef struct Track_Address_Field_Structure
{
  unsigned cylinder : 8;
  unsigned head : 8;
  unsigned sector : 8;
  unsigned size_code : 8;
} TAF;

typedef struct Low_Level_Format_Values_Structure
{
  int interleave_factor;
  int interleave_index;
  int interleave_map[64];
} LLFVS;

typedef struct Parameter_Block_Structure
{
  unsigned use_current_bpb           :  1;
  unsigned use_track_layout_fields   :  1;
  unsigned all_sectors_same_size     :  1;
  unsigned reserved                  :  5;

  unsigned device_type               :  8;
  unsigned device_attributes         : 16;
  unsigned number_of_cylinders       : 16;
  unsigned media_type                :  8;
  /* BPB Follows */
  unsigned bytes_per_sector          : 16;
  unsigned sectors_per_cluster       :  8;
  unsigned reserved_sectors          : 16;
  unsigned number_of_fats            :  8;
  unsigned root_directory_entries    : 16;
  unsigned total_sectors             : 16;
  unsigned media_descriptor          :  8;
  unsigned sectors_per_fat           : 16;
  unsigned sectors_per_cylinder      : 16;
  unsigned number_of_heads           : 16;
  unsigned hidden_sectors_low        : 16;
  unsigned hidden_sectors_high       : 16;
  unsigned large_sector_count_low    : 16;
  unsigned large_sector_count_high   : 16;

  /* FAT32 BPB Follows */
  unsigned sectors_per_fat_low       : 16;
  unsigned sectors_per_fat_high      : 16;
  unsigned ext_flag_fat_mirror       :  1;
  unsigned ext_flag_reserved         :  3;
  unsigned ext_flag_active_fat_num   :  4;
  unsigned file_sys_ver_minor        :  8;
  unsigned file_sys_ver_major        :  8;
  unsigned root_dir_start_clus_low   : 16;
  unsigned root_dir_start_clus_high  : 16;
  unsigned file_sys_info_sec         : 16;
  unsigned backup_boot_sec_num       : 16;
  unsigned char fat32_bpb_reserved   [12];

  /* Ending of parameter block */
  unsigned char reserved_2           [32];
  unsigned char reserved_3           [64];  /* Slack...shouldn't be used. */
  /* do not use // style comments for Turbo C 2.01 ! -ea */
}PB;


EXTERN AF access_flags; /* removed far keyword -ea */
EXTERN DPB far *dpb;
EXTERN DS drive_statistics;
EXTERN FP param;
EXTERN PB parameter_block;
EXTERN DDPT far *ddpt;
EXTERN LLFVS low_level;

typedef struct Get_ExtDPB_Data_Buffer
{
  unsigned int buffer_length;
  DPB          ext_dpb;
}GE_DPD_DB;

EXTERN GE_DPD_DB ext_parameter_block;


