/*
// Program:  Format
// Version:  0.90c
// (0.90b/c - DMA boundary avoidance by Eric Auer - May 2003)
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
*/

#ifndef DRIVEIO_H
#define DRIVEIO_H

#ifdef DIO
  #define DIOEXTERN   /* */
#else
  #define DIOEXTERN   extern
#endif


typedef unsigned long ULONG;
typedef unsigned long  __uint32;
typedef unsigned short __uint16;


/* Integers converted from long numbers */
DIOEXTERN int integer1;
DIOEXTERN int integer2;


/* Buffers */
DIOEXTERN unsigned char sector_buffer_0[512];
DIOEXTERN unsigned char sector_buffer_1[512];
DIOEXTERN unsigned char huge_sector_buffer_0[(512*18)]; /* old: 512*32 */
DIOEXTERN unsigned char huge_sector_buffer_1[(512*18)]; /* old: 512*32 */
/* only uformat.c uses huge_sector_buffer at all (for fill with 0xf6), */
/* so huge_sector_buffer does NOT have to be one track big!            */

#ifdef DIO
DIOEXTERN unsigned char far * sector_buffer = &sector_buffer_0[0];
DIOEXTERN unsigned char far * huge_sector_buffer = &huge_sector_buffer_0[0];
#else
DIOEXTERN unsigned char far * sector_buffer;
DIOEXTERN unsigned char far * huge_sector_buffer;
#endif

/* The following lines were taken from partsize.c, written by Tom Ehlert. */

DIOEXTERN void Clear_Huge_Sector_Buffer(void);
DIOEXTERN void Clear_Sector_Buffer(void);
DIOEXTERN int Drive_IO(int command,unsigned long sector_number,int number_of_sectors);
DIOEXTERN void Enable_Disk_Access(void);

DIOEXTERN unsigned int FAT32_AbsReadWrite(char DosDrive, int count, ULONG sector, void far *buffer, unsigned ReadOrWrite);
DIOEXTERN unsigned int TE_AbsReadWrite(char DosDrive, int count, ULONG sector, void far *buffer, unsigned ReadOrWrite);

#endif
