#include <stdio.h>
#include <dos.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>


void (far *xmsPtr)();

unsigned XMSax,XMSbx,XMSdx;


int XMScall( unsigned rAX, unsigned rDX)
{
    if (xmsPtr == NULL)
        {
        _asm mov ax, 4300h
        _asm int 2fh                /* XMS installation check */

        _asm cmp al, 80h
        _asm jne detect_done

        _asm mov ax, 4310h               /* XMS get driver address */
        _asm int 2fh

        _asm mov word ptr [xmsPtr+2],es
        _asm mov word ptr [xmsPtr],bx
        
        
        printf("XMShandler located at 0x%04x:0x%04x\n",
	       FP_SEG(xmsPtr), FP_OFF(xmsPtr));
        }
detect_done:

    if (xmsPtr == NULL)
        return 0;

    _asm    mov  ax,rAX
    _asm    mov  dx,rDX
    _asm    call dword ptr [xmsPtr]
    
    _asm    mov XMSax,ax
    _asm    mov XMSbx,bx
    _asm    mov XMSdx,dx

    return XMSax;    

}                

XMSmove(unsigned dhandle, long doffset,
        unsigned shandle, long soffset,
        long length)
{
  struct {
    long length;
    short shandle;
    long soffset;
    short dhandle;
    long  doffset;
  } C;
  C.length =   length;  
  C.shandle = shandle;  
  C.soffset=  soffset; 
  C.dhandle=  dhandle; 
  C.doffset=  doffset; 
  
  _asm    mov  ax,0x0b00;
  _asm    lea si,C;
  _asm    call dword ptr [xmsPtr]
    
  _asm    mov XMSax,ax
  _asm    mov XMSbx,bx


  if (XMSax != 1)
    {
      printf("E %02x while moving (%u,%lx) <-- (%u,%lx), len %u\n",
	     (XMSbx & 0xff),
	     dhandle, 
	     doffset,
	     shandle,
	     soffset,
	     length);  
    }            
  return (XMSbx & 0xff);
  
}

int main(void)
{
  char scratch[100];
  char str1[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

  XMScall(0,0);           /* get version number */
    
  printf("Version info interface %04x, revision %04x, HMA exists %04x\n",
	 XMSax, XMSbx, XMSdx);
  
  XMScall(0x0800,0);  /* query free extended memory */
  
  printf("Total memory is %u.\n", XMSax);
  printf("Max continuos free memory is %u.\n", XMSdx);
  
  printf("Reference string is            '%s'.\n", str1);

  /*  
  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[10])
	, 0, (long)(void far *)&(scratch[0])
	, 6);
  printf("Non-overlap m forw 6 chars from 0 to 10: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[0])
	, 0, (long)(void far *)&(scratch[10])
	, 6);
  printf("Non-overlap m back 6 chars from 10 to 0: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[14])
	, 0, (long)(void far *)&(scratch[4])
	, 4);
  printf("Non-overlap m forw 4 chars from 4 to 14:\n'%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[2])
	, 0, (long)(void far *)&(scratch[16])
	, 4);
  printf("Non-overlap m back 4 chars from 16 to 2:\n'%s'.\n", scratch);
  */

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[2])
	, 0, (long)(void far *)&(scratch[0])
	, 6);
  printf("Overlap m forw 6 ch fr 0 to 2: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[4])
	, 0, (long)(void far *)&(scratch[0])
	, 6);
  printf("Overlap m forw 6 ch fr 0 to 4: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[4])
	, 0, (long)(void far *)&(scratch[2])
	, 6);
  printf("Overlap m forw 6 ch fr 2 to 4: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[6])
	, 0, (long)(void far *)&(scratch[2])
	, 6);
  printf("Overlap m forw 6 ch fr 2 to 6: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[0])
	, 0, (long)(void far *)&(scratch[2])
	, 6);
  printf("Overlap m back 6 ch fr 2 to 0: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[0])
	, 0, (long)(void far *)&(scratch[4])
	, 6);
  printf("Overlap m back 6 ch fr 4 to 0: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[2])
	, 0, (long)(void far *)&(scratch[4])
	, 6);
  printf("Overlap m back 6 ch fr 4 to 2: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[2])
	, 0, (long)(void far *)&(scratch[6])
	, 6);
  printf("Overlap m back 6 ch fr 6 to 2: '%s'.\n", scratch);


  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[2])
	, 0, (long)(void far *)&(scratch[0])
	, 8);
  printf("Overlap m forw 8 ch fr 0 to 2: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[4])
	, 0, (long)(void far *)&(scratch[0])
	, 8);
  printf("Overlap m forw 8 ch fr 0 to 4: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[4])
	, 0, (long)(void far *)&(scratch[2])
	, 8);
  printf("Overlap m forw 8 ch fr 2 to 4: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[6])
	, 0, (long)(void far *)&(scratch[2])
	, 8);
  printf("Overlap m forw 8 ch fr 2 to 6: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[0])
	, 0, (long)(void far *)&(scratch[2])
	, 8);
  printf("Overlap m back 8 ch fr 2 to 0: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[0])
	, 0, (long)(void far *)&(scratch[4])
	, 8);
  printf("Overlap m back 8 ch fr 4 to 0: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[2])
	, 0, (long)(void far *)&(scratch[4])
	, 8);
  printf("Overlap m back 8 ch fr 4 to 2: '%s'.\n", scratch);

  strcpy( scratch, str1 );
  XMSmove(0, (long)(void far *)&(scratch[2])
	, 0, (long)(void far *)&(scratch[6])
	, 8);
  printf("Overlap m back 8 ch fr 6 to 2: '%s'.\n", scratch);




  return( 0 );
}

  
