/* dynstr.h -- dynamic string library for edlin

  AUTHOR: Gregory Pietsch <GKP1@flash.net>

  DESCRIPTION:

  This file is a dynamic string library for edlin, an edlin-style line editor.

  COPYRIGHT NOTICE AND DISCLAIMER:

  Copyright (C) 2003 Gregory Pietsch

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef DYNSTRING_H
#define DYNSTRING_H

/* includes */
#if defined(__STDC__) || defined(HAVE_STDDEF_H)
#include <stddef.h>
#elif defined(HAVE_SYS_TYPES_H)
#include <sys/types.h>
#else
#define size_t unsigned
#endif

/* macros */
#define NPOS ((size_t)-1)

/* typedefs */

typedef struct DYNSTRING_T {
    char *ptr;
    size_t len;
    size_t res;
} DYNSTRING_T;

typedef struct DYNARRAYSTRING_T {
    DYNSTRING_T **ptr;
    size_t len;
    size_t res;
} DYNARRAYSTRING_T;

/* function definitions */

DYNSTRING_T *DScreate(void);
void DSdestroy(DYNSTRING_T * ds);
DYNSTRING_T *DSappendchar(DYNSTRING_T * ds, int c, size_t nr);
DYNSTRING_T *DSappendcstr(DYNSTRING_T * this, const char *s, size_t pos,
                          size_t ns);
DYNSTRING_T *DSassignchar(DYNSTRING_T * ds, int c, size_t nr);
DYNSTRING_T *DSassigncstr(DYNSTRING_T * this, const char *s, size_t pos,
                          size_t ns);
DYNSTRING_T *DSremove(DYNSTRING_T * ds, size_t p, size_t nr);
void DSresize(DYNSTRING_T * ds, size_t n, int c);
size_t DSfind(DYNSTRING_T * ds, const char *s, size_t p, size_t n);
DYNSTRING_T *DSreplace(DYNSTRING_T * ds, size_t p, size_t n, const char *s,
                       size_t ns);
char *DScstr(DYNSTRING_T * ds);
size_t DSlength(DYNSTRING_T * ds);
DYNARRAYSTRING_T *DAScreate(void);
void DASdestroy(DYNARRAYSTRING_T * ds);
DYNARRAYSTRING_T *DASappend(DYNARRAYSTRING_T * this, DYNSTRING_T * s,
                            size_t n, size_t d);
DYNARRAYSTRING_T *DASassign(DYNARRAYSTRING_T * this, DYNSTRING_T * s,
                            size_t n, size_t d);
DYNARRAYSTRING_T *DASinsert(DYNARRAYSTRING_T * ds, size_t p,
                            DYNSTRING_T ** s, size_t n, size_t d);
DYNARRAYSTRING_T *DASremove(DYNARRAYSTRING_T * ds, size_t p, size_t n);
DYNARRAYSTRING_T *DASsubarray(DYNARRAYSTRING_T * this,
                              DYNARRAYSTRING_T * x, size_t p, size_t n);
DYNSTRING_T *DASgetat(DYNARRAYSTRING_T * ds, size_t i);
void DASputat(DYNARRAYSTRING_T * ds, size_t i, DYNSTRING_T * x);
DYNSTRING_T **DASbase(DYNARRAYSTRING_T * this);
size_t DASlength(DYNARRAYSTRING_T * ds);

#endif

/* END OF FILE */
