/* error.c -- error messages for edline

  AUTHOR: Gregory Pietsch <GKP1@flash.net>

  DESCRIPTION:

  This file contains error routines for edline, an 
  edlin-style line editor.

  COPYRIGHT NOTICE AND DISCLAIMER:

  Copyright (C) 2003 Gregory Pietsch

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

/* includes */
#include <stdio.h>
#include "error.h"

/* static variables */
const char *error_msgs[] = {
    /* NO_ERROR,               */ "",
    /* ERR_OUT_OF_MEMORY,      */ "Out of memory",
    /* ERR_LENGTH,             */ "String length error",
    /* ERR_STRING_POSITION,    */ "String position error",
    /* ERR_INVALID_USER_INPUT, */ "Invalid user input, use ? for help.",
    /* ERR_NO_FILENAME,        */ "No filename",
    /* ERR_ARRAY_TOO_BIG,      */ "Buffer too big",
    /* ERR_INVALID_POSITION    */ "Invalid buffer position",
    /* ERR_MAX                 */ "",
};

/* functions */
void error(ERROR_T err)
{
    fprintf(stderr, "ERROR: %s\n", error_msgs[err]);
}

/* END OF FILE */
