/* xmalloc.c -- memory allocators that abort on error

  AUTHOR: Gregory Pietsch <GKP1@flash.net>

  DESCRIPTION:

  This file is the source for portable memory allocators that
  abort if there is an error.

  COPYRIGHT NOTICE AND DISCLAIMER:

  Copyright (C) 2003 Gregory Pietsch

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

/* includes */
#include <stdlib.h>
#include "error.h"

/* functions */

void *xmalloc(size_t n)
{
	void *p = malloc(n);
	if (p == 0) {
		error(ERR_OUT_OF_MEMORY);
		abort();
	}
	return p;
}

void *xrealloc(void *s, size_t n)
{
	void *p;
	
	if (s == 0)
		return xmalloc(n);
	if (n == 0) {
		free(s);
		return 0;
	}
    if ((p = realloc(s, n)) == 0) {
		error(ERR_OUT_OF_MEMORY);
		abort();
	}
	return p;
}

/* END OF FILE */
