/*
   DISKCOPY.EXE, floppy diskette duplicator similar to MSDOS Diskcopy.
   Copyright (C) 1998, Matthew Stanford.
   Copyright (C) 1999, 2000, Imre Leber.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at:  ilebr@vub.ac.be

*/

#include "diskcopy.h"
#include "tdrvcpy.h"
#include "memtypes.h"
#include "waitfinp.h"
#include "drive.h"

#include <bios.h>
#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

#define SECTORSPERBLOCK 20

void TwoDriveCopy (int sourcedrv, int destdrv, int bel, int fallthrough,
		   int askdisk
#ifndef ALL_RECOVERY_MODE
		   ,int recoverymode
#endif
		   )
{
     int      answer;
     struct   dfree dskfree;
     int      sector;
     unsigned long disksize, endsector, total;
     void*    heapbuf;
     char     backup[BYTESPERSECTOR];
     void**   buffer;
     int      onheap = TRUE;
     int      sectorsperblock = SECTORSPERBLOCK;

     answer = 'Y';

     while (answer == 'Y')
     {
	   if (askdisk)
	   {
	      printf("\nPut source diskette in drive %c:\n", sourcedrv + 'A');
	      printf("Put destination diskette in drive %c:\n", destdrv + 'A');
	      printf("\nPress any key to continue...");
	      WaitForInput();
	   }
	   askdisk = TRUE;

	   for (;;)
	   {
	       getdfree (sourcedrv+1, &dskfree);
	       dskfree.df_total = GetFullClusterCount(sourcedrv+1);
	       if (dskfree.df_total == 0)
	       {
		  printf("\nInvalid drive specification or non removable media.\n");
		  exit(INITERROR);
	       }
	       total    = dskfree.df_total * dskfree.df_sclus;
	       disksize = total * dskfree.df_bsec;

	       if (dskfree.df_total == GetFullClusterCount(destdrv+1)) break;

	       puts ("\n\nDiskette does not have the same capacity as the original.");
	       printf("Put a diskette with the right capacity in drive %c: or %c:, \n",
		      sourcedrv + 'A', destdrv + 'A');
	       puts("or press CTRL-C to cancel.");
	       WaitForInput();
	   }

	   printf("\nCopying %d clusters, %d sectors per cluster, %d bytes per sector\n"
		  "Drive size is %ld bytes.",
		  dskfree.df_total, dskfree.df_sclus, dskfree.df_bsec, disksize);

	   if ((heapbuf = malloc(SECTORSPERBLOCK * dskfree.df_bsec)) == NULL) 
	   {  
	      if (dskfree.df_bsec > BYTESPERSECTOR)
	      {
		 puts("\nInsuficient memory error.\n");
		 exit(INITERROR);
	      }
	      onheap = FALSE;
	      buffer = (void**) &backup;
	      sectorsperblock = 1;
	   }
	   else 
	   {
	      buffer = &heapbuf;
	      sectorsperblock = SECTORSPERBLOCK;
	      onheap = TRUE;
	   }

	   endsector = dskfree.df_total * dskfree.df_sclus;

	   for (sector = 0; sector < endsector; sector+=sectorsperblock)
	   {
#ifndef ALL_RECOVERY_MODE
	      if (recoverymode) 
#endif
		 ReadSectors(sourcedrv, sectorsperblock, sector, *buffer, 
			     dskfree.df_bsec);
#ifndef ALL_RECOVERY_MODE
	      else 
		if (absread(sourcedrv, sectorsperblock, sector, *buffer) != 0)
		   printf("\nMedia error reading from sector %d\n", sector);
#endif                 
	      if (abswrite(destdrv, sectorsperblock, sector, *buffer) != 0)
		 printf("\nMedia error writing to sector %d\n", sector);
	   }

	   if (bel) Beep();

	   answer = (fallthrough) ? 'N' : 'X';
	   while ((answer != 'Y') && (answer != 'N')) 
	   {
		printf("\nDo you want to copy two other diskettes (y/n)?\n");

		answer = toupper(getch());
	   } 
	   
	   if (onheap) free(heapbuf);
     }     
}

int BiosReportsTwoDrives ()
{
     int configuration = biosequip();

     if (configuration & 1)                  /* At least one floppy drive. */
	if (((configuration >> 6) & 3) >= 1)
	   return 1;
	else
	   return 0;
     else
	return 0;
}
