#ifndef PARSER_H_
#define PARSER_H_

typedef int TOKEN;

/* Parser input structure. */

struct LValueArray {
       TOKEN       token;
       void (*func)(TOKEN rvalue);
};

struct HeaderArray {
       int                 amount;
       TOKEN               header;
       struct LValueArray* lvalues;
};

/* Parser output structure. */

struct IniParserStruct {

   /* MEMORY */
   int   UseEMS;                 /* Use of EMS  granted.            */
   int   UseXMS;                 /* Use of XMS  granted.            */
   int   UseSWAP;                /* Use of SWAP granted.            */

   /* OPTIONS */
   int   audible;                /* Give an audible warning.        */
   int   verify;                 /* Verify writes.                  */
   int   informative;            /* Give information on memory use. */
   int   overwrite;              /* Overwrite destination.          */
   int   autoexit;               /* Always automatically exit.      */
   int   askdisk;                /* Ask disk.                       */
   int   mode;                   /* Mode that diskcopy is in.       */

   /* GENERATION */
   int   MakeDAT;                /* Wether or not to keep a compiled 
                                    DAT file.                        */
};

/* Tokens. */
#define TknNONE         -1           /* Invalid input.         */
#define TknDONE          0           /* End of buffer reached. */

#define TknSPACE         1           /* white space  */
#define TknASSIGN        2           /* =            */
#define TknYES           3           /* yes          */
#define TknNO            4           /* no           */
#define TknALWAYS        5           /* always       */
#define TknNEVER         6           /* never        */


#define TknMEMORYHEADER  7           /* [- MEMORY -] */
#define TknDISK          8           /* DISK/SWAP    */
#define TknEMS           9           /* EMS          */
#define TknXMS          10           /* XMS          */

#define TknOPTIONHEADER 11           /* [- OPTIONS -] */
#define TknAUDIBLE      12           /* audible       */
#define TknVERIFY       13           /* verify        */
#define TknINFORMATIVE  14           /* informative   */
#define TknOVERWRITE    15           /* overwrite     */
#define TknAUTOEXIT     16           /* autoexit      */
#define TknMODE         17           /* mode          */
#define TknASKDISK      18

#define TknRECOVERY     19           /* recovery      */
#define TknNORMAL       20           /* normal        */

#define TknRETURN       21           /* Return        */

#define TknGENERATEHEADER 22         /* [- GENERATE -] */
#define TknUSEDATFILE     23         /* usedatfile */

#define PARSERSUCCESS       1

#define YES    1
#define NO     0

#define ALWAYS 1
#define NEVER  0

#define RECOVERY 1
#define NORMAL   0

int ParseIniFile(char* filename);
struct IniParserStruct* GetParsedData(void);

#endif
