/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* DEL - erases one or more files or directories.  This may be
completely interactive. */

/* Copyright (C) 1994--1998 John Hall, Jim Hall. */

/* Email: Jim Hall, jhall1@isd.net */

/* NOTE: Some of these #include's may not be needed anymore since the
   last update. */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <time.h>
#include <dos.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include "getopt.h"


/* Symbolic constants */

#define STREQ(a,b) (strcmp((a), (b)) == 0)
#define _A_FILE (_A_ARCH | _A_HIDDEN | _A_NORMAL | _A_RDONLY | _A_SYSTEM)


/* Boolean values */

enum bool
  {
    FALSE, TRUE
  };

/* Error codes */

enum ecode
  {
    EOK, ESYNTAX, EBADTIME
  };

/* Globals */

int Force = 0, Subdir = 0;

/* Functions */

void erase (char *pathname);
void erase_dir (char *dir);
void usage (void);


/* the program */
int
main (int argc, char **argv)
{
  struct stat statbuf;
  int i, c;

  /* Parse the command line */

  while ((c = getopt (argc, argv, "fFsS?")) != EOF)
    {
      switch (c)
	{
	case 'f':
	case 'F':		/* Force */
	  Force = 1;
	  break;

	case 's':
	case 'S':		/* Subdirectories */
	  Subdir = 1;
	  break;

	default:
	  usage ();
	  break;
	}
    }

  /* Delete all files */

  for (i = optind; i < argc; i++)
    {
      stat (argv[i], &statbuf);

      /* Delete file */

      if (statbuf.st_mode & S_IFDIR)
	{
	  if (!Force)
	    {
	      fprintf (stderr, "Warning: You are about to delete a directory");

	      if (Subdir)
		fprintf (stderr, " and its subcontents");

	      fprintf (stderr, "\n");

	      fprintf (stderr, "Are you sure?\n");
	      c = getch ();

	      if ((c == 'y') || (c == 'Y'))
		erase_dir (argv[i]);

	    }
	  else
	    erase_dir (argv[i]);

	}
      else
	erase (argv[i]);
    }

  exit (0);
}

/* erase - clears pathname of its attributes, then deletes the file.
returns nothing */

void 
erase (char *pathname)
{
  assert (pathname != NULL);

  /* Clear file attributes */
  _dos_setfileattr (pathname, 0x00);

  /* Delete file */
  if (remove (pathname) != EOK)
    fprintf (stderr, "Warning: Unable to remove %s\n", pathname);
}

/* erase_dir - deletes all files and subdirectories in a directory.
then removes the directory.  returns nothing */

void 
erase_dir (char *dir)
{
  /* Some of these may not be needed anymore: */

  struct find_t finfo;
  unsigned done;
  char filename[_MAX_PATH];
  int length;

  assert (dir != NULL);

  /* Remove any trailing backslash from dir */
  length = strlen (dir);
  assert (length > 0);
  if (dir[length - 1] == '\\')
    dir[length - 1] = '\0';

  /* Remove contents of directory */
  sprintf (filename, "%s\\*.*", dir);
  for (done = _dos_findfirst (filename, _A_FILE | _A_SUBDIR, &finfo);
       !done;
       done = _dos_findnext (&finfo))
    {

      /* Specifically exclude . and .. from search */
      if (!STREQ (finfo.name, ".") && !STREQ (finfo.name, ".."))
	{

	  /* Build full path name */
	  sprintf (filename, "%s\\%s", dir, finfo.name);

	  /* Delete file or directory */
	  if (finfo.attrib == _A_SUBDIR)
	    erase_dir (filename);
	  else
	    erase (filename);
	}
    }

  /* Remove directory */
  if ((Subdir) && (rmdir (dir) == EOK))
    fprintf (stderr, "Removed %s\n", dir);
  else
    fprintf (stderr, "Warning: Unable to remove %s\n", dir);
}


/* usage - print usage information for the program */

void 
usage (void)
{
  fprintf (stderr, "DEL/ERASE - Delete one or more files and/or directories.\n");
  fprintf (stderr, "Usage:\n");
  fprintf (stderr, "\tDEL [/F] [/S] file.. dir..\n");
  fprintf (stderr, "\tERASE [/F] [/S] file.. dir..\n");

  fprintf (stderr, "\t\t/F - Force the removal of subdirectories, even if not empty.\n");
  fprintf (stderr, "\t\t/S - Recursively erase subdirectories.  Will ask first.\n");
  exit (1);
}
