/*    
   Defrfact.c -calculate defragmentation factor.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include "fte.h"
#include "bool.h"
#include "inffat12.h"

static int FactorCalculator(RDWRHandle handle, CLUSTER cluster,
                            SECTOR sector, void** structure);

static int FileFactCalculator(RDWRHandle handle,
                              struct DirectoryEntry* entry,
                              void** structure);


struct PipeStruct {
    CLUSTER total;
    CLUSTER consecutive;
};

struct ResultStruct {
       unsigned long count;
       unsigned long sum;
};

int GetDefragFactor(RDWRHandle handle)
{
    struct ResultStruct result = {0,0}, *presult = &result;

    if (!WalkDirectoryTree(handle,
                           FileFactCalculator,
                           (void**) &presult))
       return 255;
  
    if (result.count != 0)
       return (int) (result.sum / result.count);
    else
       return 100; /* Empty disks are unfragmented. */
}

static int FileFactCalculator(RDWRHandle handle,
                            struct DirectoryEntry* entry,
                            void** structure)
{
    struct PipeStruct pipe = {0,0}, *ppipe = &pipe;
    struct ResultStruct* result = *((struct ResultStruct**) structure);

    if (IsDeletedLabel(*entry))      return TRUE;
    if (entry->attribute & FA_LABEL) return TRUE;
    if (IsCurrentDir(*entry))        return TRUE;
    if (IsPreviousDir(*entry))       return TRUE;
  
    FileTraverseFat(handle, entry->firstclust, FactorCalculator,
                    (void**) &ppipe);

    result->count++;

    if (pipe.total != 0)
       result->sum += (((unsigned long) pipe.consecutive * 100) / pipe.total);

    return TRUE;
}

static int FactorCalculator(RDWRHandle handle, CLUSTER cluster,
                            SECTOR sector, void** structure)
{
    struct PipeStruct *pipe = *((struct PipeStruct**) structure);
    CLUSTER now = DataSectorToCluster(handle, sector);

    pipe->total++;

    if ((now == cluster - 1) || (FAT_LAST(cluster))) pipe->consecutive++;

    return TRUE;
}
