; Assembler source library
; Copyright (c) 2002 Arkady Belousov <ark@mos.ru>
;
; This library is free software; you can redistribute it and/or modify it
; under the terms of the GNU Lesser General Public License as published by
; the Free Software Foundation; either version 2.1 of the License, or (at
; your option) any later version.
;
; This library is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU Lesser General Public License for more details.
;
; You should have received a copy of the GNU Lesser General Public
; License along with this library; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;

;
;	Convert byte into unterminated ASCII string with 2 hex digits
;
;
; In:	AL			(value)
; Out:	AX			(ASCII string: AL - hi digit, AH - lo digit)
; Use:	digit2x (digit.mac)
; Modf:	CL
; Call:	none
;
byte2hexa	proc
		mov	ah,al
		and	al,0Fh
		digit2x
		xchg	ah,al
		mov	cl,4
		shr	al,cl
		;and	al,0Fh
		digit2x
		ret
byte2hexa	endp
