   /* ---------- COPY.C - principal source file for COPY --- */
/* 

   Copyright (c) 1996 M. M. Peritsky.  All rights reserved.
   This program is part of the Free-DOS Project.
   See COPY.TXT for more details.

*/
   /* ---------- include files ----------------------------- */

#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <dos.h>
#include <ctype.h>
#include <conio.h>

#include "copy.h"
#include "copyhlp.h"
#include "copysubs.h"
#include "strfns.h"
#include "dirfns.h"

   /* ---------- declaration of symbolic constants --------- */

#define TRUE 1
#define FALSE 0

#define DEVICENAME FILENAME

   /* ---------- declaration of macros --------------------- */

#define STRCAT2(x, y) strcat3(x, y, "")

#define CWD_IS_ROOT (!cwd_parent_exists)
#define DWD_IS_ROOT (!dwd_parent_exists)
#define CWD_IS_NOT_ROOT cwd_parent_exists
#define DWD_IS_NOT_ROOT dwd_parent_exists

#define FNSPLITX(x) fnsplit(x, tf.drive, tf.dir, tf.file, tf.ext)
#define FNMERGEX(x) fnmerge(x, tf.drive, tf.dir, tf.file, tf.ext)
#define FNSPLIT FNSPLITX(fn_path)
#define FNMERGE FNMERGEX(fn_path)

   /* ---------- declaration of static functions ----------- */

static char *nextspec(char *p);
static void do_one_file(int pass);


   /* ---------- declaration of global variables ----------- */

   char *myname;

   char fn_path[MAXPATH];
   struct fn_parts {
      char drive[MAXDRIVE];
      char dir[MAXDIR];
      char file[MAXFILE];
      char ext[MAXEXT];
   } tf;

   char cwd[MAXPATH];
   char cwd_parent[MAXPATH];
   int cwd_parent_exists = FALSE;

   char *dwd;
   int dwd_parent_exists = FALSE;

   int spec_count = 0;
   char *spec[2];

   int a_switch[3];
   int b_switch[3];
   int c_switch = FALSE;
   int k_switch = FALSE;
   int r_switch = FALSE;
   int s_switch = FALSE;
   int v_switch = FALSE;
   int w_switch = FALSE;
   int z_switch = FALSE;

   int old_vf = -1;

   char *src_fullpath;
   char *src_drive_dir;
   char *src_file_ext;
   int src_fullpath_flags;

   char *dest_fullpath;
   char *dest_drive_dir;
   char *dest_file_ext;
   int dest_fullpath_flags;
   int skip_this_dest;

   struct ffblk filedata;

   int n_copied = 0;

   /* ---------- start of main() --------------------------- */

int main(int argc, char *argv[])
{

   /* ---------- declaration of local variables ------------ */
   
   char c;
   char *cp;
   char *p;
   char *q;
   char *r;
   char *s;
   char *t;

   int i;
   int pass;

   int doing_firstspec = FALSE;

   /* ---------- what's my name? --------------------------- */

   FNSPLITX(argv[0]);
   myname = strdup1(tf.file);

   /* ---------- display help screen upon request ---------- */

   if (argc == 1) {
      copyhlp();
      return 1;
   }

   for (i = 1; i < argc; i++) {
      if ((strcmpi(argv[i],"/?") == 0)
       || (strcmpi(argv[i],"/h") == 0)
       || (strcmpi(argv[i],"/help") == 0)) {
             copyhlp();
             return 1;
      }
   }

   /* ---------- parse the switches and arguments ---------- */

   for (i = 0; i < 3; i++) {
      a_switch[i] = FALSE;
      b_switch[i] = FALSE;
   }

   for (i = 1; i < argc; i++) {
      cp = argv[i];
      if (*cp == '/') {
         doing_firstspec = FALSE;
         if (strlen(cp) == 2) {
            c = toupper(*(cp+1));
            switch (c) {
               case 'A':
                  a_switch[spec_count] = TRUE;
                  break;
               case 'B':
                  b_switch[spec_count] = TRUE;
                  break;
               case 'C':
                  c_switch = TRUE;
                  break;
               case 'K':
                  k_switch = TRUE;
                  break;
               case 'R':
                  r_switch = TRUE;
                  break;
               case 'S':
                  s_switch = TRUE;
                  break;
               case 'V':
                  v_switch = TRUE;
                  break;
               case 'W':
                  w_switch = TRUE;
                  break;
               case 'Z':
                  z_switch = TRUE;
                  break;
               default:
                  printf("Option %s is not valid.\n", cp);
                  main_exit(1);
            }
         }
         else {
            printf("Option %s is not valid.\n", cp);
            main_exit(1);
         }
      }
      else {
         switch (spec_count) {
            case 0:
               spec[spec_count++] = strdup1(cp);
               doing_firstspec = TRUE;
               break;
            case 1:
               if ( doing_firstspec 
                  && ( ends_with_plus(spec[0])
                    || starts_with_plus(cp)    ) ) {
                  t = spec[0];
                  spec[0] = STRCAT2( t, cp );
                  free(t);
               }
               else {
                  spec[spec_count++] = cp;
               }
               break;
            default:
               printf("Too many file specifications.\n");
               main_exit(1);
               break;
         }
      }
   }

   /* ---------- check for conflicting switches ------------ */

   if ( (a_switch[0] && b_switch[0])
     || (a_switch[1] && b_switch[1]) ) {
        printf("Switches /A and /B conflict.\n");
        main_exit(1);
   }

   if (a_switch[2] || b_switch[2]) {
      printf("Switches /A and /B must come before file specifications.\n");
      main_exit(1);
   }

   /* ---------- check for missing source spec ------------- */

   if (spec_count == 0) {
      printf("Missing source specification.\n");
      main_exit(1);
   }

   /* ---------- get the current directory and parent ------ */

   /* cwd has trailing slash only if root */
   /* cwd_parent always has trailing slash */

   getcwd(cwd, MAXPATH); 

   strcpy(cwd_parent, cwd);
   i = strlen(cwd_parent);
   if (i > 3) {
      cwd_parent_exists = TRUE;
      while (cwd_parent[i] != '\\') cwd_parent[i--] = '\0';
   }

   /* ---------- initialize the drive-working-directory ---- */

   dwd = strdup1(cwd);
   dwd_parent_exists = cwd_parent_exists;


   /* ---------- if no dest spec, make it cwd -------------- */

   if (spec_count == 1) spec[spec_count++] = cwd;

   /* ---------- determine full path of destination spec --- */

   dest_fullpath = fullpath(spec[1]);
   dest_fullpath_flags = fnsplit2(dest_fullpath,
      &dest_drive_dir, &dest_file_ext);

   /* ---------- set verification -------------------------- */

   if (v_switch) {
      old_vf = getverify();
      setverify(1);
   }

   /* ---------- loop over source specs, two passes -------- */

   for (pass = 0; pass < 2; pass++) {
      p = strdup1(spec[0]);
      r = p;
      do {
         q = nextspec(p);
         s = fullpath(p);

         src_fullpath = s;
         src_fullpath_flags = fnsplit2(src_fullpath,
            &src_drive_dir, &src_file_ext);

         i = FA_NORMAL;
         if (s_switch) i = FA_SYSTEM | FA_HIDDEN; 
         if (findfirst(s, &filedata, i) == 0) {
            do_one_file(pass);
            while (findnext(&filedata) == 0) {
               do_one_file(pass);
            }
         }
         free(s); free(src_drive_dir); free(src_file_ext);
      } while ((p=q) != NULL);
      free(r);
   }

   /* ---------- exit successfully ------------------------- */

   main_exit(0);
}

   /* ---------- end of main() ----------------------------- */

   /* ---------- start of nextspec function ---------------- */

static char *nextspec(char *p)
{
   char *q;
   q=p;
   while ((*q != '\0') && (*q != '+')) q++;
   if (*q == '+') {
      *q = '\0';
      return ++q;
   }
   else {
      return NULL;
   }
}

   /* ---------- end of nextspec function ------------------ */

   /* ---------- start of main_exit function --------------- */

void main_exit(int code)
{
   if (old_vf > -1) setverify(old_vf);

   printf("%d file(s) copied.\n", n_copied);
   if (code != 0) printf("Uns");
   else printf("S");
   printf("uccessful termination.\n");
   exit(code);
}

   /* ---------- end of main_exit function ----------------- */

   /* ---------- start of do_one_file function ------------- */

static void do_one_file(int pass)
{
   char *src_arg;
   char *dest_arg;
   char *temp;

   int g;

   int appnd;
   int ab_in;
   int ab_out;

   int exist_warning;
   int dest_file_exists;
   int dest_file_newer;

   int src_is_dev;
   int dest_is_dev;

   struct ffblk fd;

   src_arg = STRCAT2(src_drive_dir, filedata.ff_name);

   if ((dest_fullpath_flags & WILDCARDS) != 0) {
      temp = newname(filedata.ff_name, dest_file_ext);
      dest_arg = STRCAT2(dest_drive_dir, temp);
      free(temp);
   }
   else {
      dest_arg = strdup1(dest_fullpath);
   }

   str_toupper(src_arg);
   str_toupper(dest_arg);

   src_is_dev = (src_fullpath_flags == DEVICENAME);

   if ( src_is_dev
     && ((dest_fullpath_flags & WILDCARDS) != 0) ) {
      printf("Destination wildcards not permitted when source is %s\n",
          src_file_ext);
      main_exit(1);
   }

   if (pass == 0) {

      if (strcmpi(src_arg, dest_arg) == 0) {
         printf("Cannot copy %s onto itself.\n", src_arg);
         main_exit(1);
      }
   }
   else {
    if (strcmpi(src_arg, dest_arg) != 0) {

      dest_is_dev = (dest_fullpath_flags == DEVICENAME);

      dest_file_exists = ( ( (!dest_is_dev)
         && ( k_switch || r_switch || w_switch ) ) ? 
            (findfirst(dest_arg, &fd, FA_SYSTEM | FA_HIDDEN) == 0)
               : FALSE );

      dest_file_newer = 
         ( ( (!dest_file_exists) || src_is_dev ) ? FALSE
            : ( ( ((unsigned) fd.ff_fdate) > 
                  ((unsigned) filedata.ff_fdate) ) ? TRUE
               : ( ( fd.ff_fdate == filedata.ff_fdate )
                  && ( ((unsigned) fd.ff_ftime) >=
                       ((unsigned) filedata.ff_ftime) ) ) ) );

      /* the (unsigned) cast operators in the above statement are
      needed because of a bug in the Power C header files; the
      ff_fdate and ff_ftime variables should have been declared
      as unsigned rather than as int originally. */

      if ( r_switch && (!dest_is_dev) && (!dest_file_exists) ) {
         printf("Skipping source %s;\n", src_arg);
         printf("   destination %s doesn't exist.\n", dest_arg);
      }
      else {
         if ( k_switch && dest_file_newer ) {
            printf("Skipping source %s;\n", src_arg);
            printf("   file isn't newer than %s\n", dest_arg);
         }
         else {

            if ((!dest_is_dev)
               && ((dest_fullpath_flags & WILDCARDS) == 0)
               && (n_copied > 0)) {
               printf("Appending %s to %s\n", src_arg, dest_arg);
               appnd = TRUE;
            }
            else {
               printf("Copying %s to %s\n", src_arg, dest_arg);
               appnd = FALSE;
            }

            ab_in = (dest_is_dev || a_switch[0]);
            ab_out = a_switch[1];

            exist_warning = FALSE;
            if ( w_switch && dest_file_exists ) {
               exist_warning = TRUE;
               printf("Destination file already exists.\n");
            }

            g = 'Y';
            if (c_switch || exist_warning) {
               do {
                  printf(
                    "Do the copy operation? [Y]es (default), [N]o, [S]top?");
                  g = toupper(getche());
                  printf("\n");
               } while (strchr("YNS\r", g) == NULL);
            }
            switch (g) {
               case '\r':
               case 'Y':

                  printf("Working...\n");

                  copy1(src_arg, ab_in, dest_arg, ab_out, appnd, z_switch,
                     ( (!src_is_dev) && (!dest_is_dev) && (!appnd) ));

                  /* the last argument in the above statement specifies
                  when the destination file should have the same date and
                  time as the source file */

                  n_copied++;
                  break;
               case 'N':
                  break;
               case 'S':
                  printf("Program halted at user's request.\n");
                  main_exit(0);
                  break;
            }
         }
      }
    }
   }

   free(src_arg); free(dest_arg);
}

   /* ---------- end of do_one_file function --------------- */

