
/*
 *  PROMPT.C - prompt handling.
 *
 *
 *
 *  Comments:
 *
 *  14/01/95 (Tim Normal)
 *    started.
 *
 *  08/08/95 (Matt Rains)
 *    i have cleaned up the source code. changes now bring this source into
 *    guidelines for recommended programming practice.
 *
 *  01/06/96 (Tim Norman)
 *    added day of the week printing (oops, forgot about that!)
 *
 *  08/07/96 (Steffan Kaiser)
 *    small changes for speed
 *
 *  20-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 *   removed redundant day strings. Use ones defined in date.c.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 28-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - moved cmd_prompt from internal.c to here
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <ctype.h>
#include <dir.h>
#include <string.h>

#include "command.h"

/* JPP 20-Jul-1998 - removed redundant day strings. Use ones defined in date */

const char *day_strings[] =
{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

/*
 * print the command-line prompt
 *
 */
void printprompt(void)
{
  struct time t;
  struct dosdate_t d;

  static char default_pr[] = "$P$G";
  char *pr;
  char direc[128];
  char temp[128];

  pr = getenv("PROMPT");        /* get PROMPT environment var. */

  if (!pr || !pr[0])            /* if PROMPT hasn't been set */
  {
    pr = default_pr;
  }

  while (*pr)
  {
    if (*pr != '$')
    {
      putchar(*pr);
    }
    else
    {
      pr++;

      switch (toupper(*pr))
      {
        case 'Q':
          {
            putchar('=');
            break;
          }
        case '$':
          {
            putchar('$');
            break;
          }
        case 'T':
          {
            gettime(&t);
            printf("%2d:%02d:%02d.%02d", t.ti_hour, t.ti_min, t.ti_sec, t.ti_hund);
            break;
          }
        case 'D':
          {
            _dos_getdate(&d);
            printf("%s %02d-%02d-%04d", day_strings[d.dayofweek], d.month,
                   d.day, d.year);
            break;
          }
        case 'P':
          {
            direc[0] = getdisk() + 'A';
            direc[1] = ':';
            getcurdir(0, temp);

            if (temp[0] == '\\')
            {
              strcpy(&direc[2], temp);
            }
            else
            {
              direc[2] = '\\';
              strcpy(&direc[3], temp);
            }

            fputs(direc, stdout);
            break;
          }
        case 'V':
          {
            fputs("FreeDOS Alpha", stdout);
            break;
          }
        case 'N':
          {
            putchar(getdisk() + 'A');
            break;
          }
        case 'G':
          {
            putchar('>');
            break;
          }
        case 'L':
          {
            putchar('<');
            break;
          }
        case 'B':
          {
            putchar('|');
            break;
          }
        case '_':
          {
            putchar('\n');
            break;
          }
        case 'E':
          {
            putchar(27);
            break;
          }
        case 'H':
          {
            putchar(8);
            break;
          }
      }
    }
    pr++;
  }
}


#ifdef INCLUDE_CMD_PROMPT

#define PROMPTEQUAL  "PROMPT="

/*
 * changes the PROMPT env. var.
 *
 * JPP 17-Jul-1998 - changed to use dynamic memory instead of static.
 *
 */
#pragma argsused
int cmd_prompt(char *first, char *rest)
{
  char *from,
   *tempcommand;
  int returnvalue;

  /* create a fake command to pass to set() */
  if (*rest == '=')
  {
    from = &rest[1];
    while (isspace(*from))
      from++;
    tempcommand = (char *)malloc(strlen(PROMPTEQUAL) + strlen(from) + 1);
    strcpy(tempcommand, PROMPTEQUAL);
    strcat(tempcommand, from);
  }
  else
  {
    tempcommand = (char *)malloc(strlen(PROMPTEQUAL) + strlen(rest) + 1);
    strcpy(tempcommand, PROMPTEQUAL);
    strcat(tempcommand, rest);
  }

  returnvalue = set_env(tempcommand);
  free(tempcommand);
  return returnvalue;
}
#endif
