/*
 *  PATH.C - path command.
 *
 *  Comments:
 *
 * 17 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_PATH

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "command.h"

#define PATHEQUAL    "PATH="

/*
 * changes the PATH env. var.
 *
 * JPP 17-Jul-1998 - changed to use dynamic memory instead of static.
 *
 */
#pragma argsused
int cmd_path(char *first, char *rest)
{
  char *from,
   *tempcommand;
  int returnvalue;

  if (!rest || !*rest)
  {
    printf("PATH=%s\n", getenv("PATH"));
    return 0;
  }

  /* create a fake command to pass to set() */
  if (*rest == '=')
  {
    from = &rest[1];
    while (isspace(*from))
      from++;
    tempcommand = (char *)malloc(strlen(PATHEQUAL) + strlen(from) + 1);
    strcpy(tempcommand, PATHEQUAL);
    strcat(tempcommand, from);
  }
  else
  {
    tempcommand = (char *)malloc(strlen(PATHEQUAL) + strlen(rest) + 1);
    strcpy(tempcommand, PATHEQUAL);
    strcat(tempcommand, rest);
  }

  returnvalue = set_env(tempcommand);
  free(tempcommand);
  return returnvalue;

}

#endif
