/*
 *  FOR.C - for command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 19 Jul 1998 (Hans B Pufal) [HBP_001]
 *   Implementation of FOR
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "command.h"
#include "batch.h"

int cmd_for(char *cmd, char *param)
{
  /*
   * Perform FOR command.
   *
   * First check syntax is correct : FOR %v IN ( <list> ) DO <command>
   *   v must be alphabetic, <command> must not be empty.
   *
   * If all is correct build a new bcontext structure which preserves
   *   the necessary information so that readbatchline can expand
   *   each the command prototype for each list element.
   *
   * You might look on a FOR as being a called batch file with one line
   *   per list element.
   */

  char *pp, var;

  dprintf(("CMD '%s' : '%s'\n", cmd, param));

  if (strcmp(param, "/?") == 0)
  {
    printf("%s :\n", cmd);
    return 0;
  }

  /* Check that first element is % then an alpha char followed by space */

  if ((*param != '%') || !isalpha(*(param + 1)) || !isspace(*(param + 2)))
  {
    error_syntax("bad varable specification.");
    return 1;
  }

  param++;
  var = *param++;               /* Save FOR var name */

  while (isspace(*param))
    param++;

  /* Check next element is 'IN' */

  if ((strncmpi(param, "in", 2) != 0) || !isspace(*(param + 2)))
  {
    error_syntax("'in' missing in for statement.");
    return 1;
  }

  param += 2;
  while (isspace(*param))
    param++;

  /* Folowed by a '(', find also matching ')' */

  if ((*param != '(') || (NULL == (pp = strchr(param, ')'))))
  {
    error_syntax("no brackets found.");
    return 1;
  }

  *pp++ = '\0';
  param++;                      /* param now points at null terminated list */

  while (isspace(*pp))
    pp++;

  /* Check DO follows */

  if ((strncmpi(pp, "do", 2) != 0) || !isspace(*(pp + 2)))
  {
    error_syntax("'do' missing.");
    return 1;
  }

  pp += 2;
  while (isspace(*pp))
    pp++;

  /* Check that command tail is not empty */

  if (*pp == '\0')
  {
    error_syntax("no command after 'do'.");
    return 1;
  }

  /* OK all is correct, build a bcontext.... */

  {
    struct bcontext
     *new = (struct bcontext *)malloc(sizeof(struct bcontext));

    new->prev = bc;
    bc = new;

    bc->bfile = NULL;
    bc->ffind = NULL;
    bc->params = batch_params("", param); /* Split out list */
    bc->shiftlevel = 0;
    bc->forvar = var;
    bc->forproto = strdup(pp);
  }

  return 0;
}
