/*
 *  INIT.C - initialization code
 *
 *      This is more or less a complete rewrite based on the
 *      initialize() code of v0.74c, but also some changes of 0.75b.
 *
 *  Comments:
 *      1998/07/19 ska  removed from COMMAND.C and put into this file
 *
 * 09-Sep-1998 ska
 * - fix/chg: ^Break handler now handles external programs properly
 *
 * 01-Dec-1998 jpp
 * - finished batch file trace mode.  Fixed bug with /C command line switch
 *   running batch files
 * - Added about 2 second delay where user can press F8 to run autoexec.bat
 *   in tracemode, or press F5 to bypass autoexec.bat completely.
 *
 */

#include "config.h"

#include <ctype.h>
#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include "mcb.h"
#include <environ.h>
#include "err_hand.h"
#include "batch.h"

#include "strings.h"

/* Name of the executable */
//#ifdef __TINY__
#define COM_NAME "COMMAND.COM"
//#else
//#define COM_NAME "COMMAND.EXE"
//#endif

extern int aliasload(char *, char *);

static unsigned oldPSP;
char *ComDir;                   //this is the directory command.com is in.

/* Without resetting the owner PSP, the program is not removed
   from memory by the DOS boxes of Win98 & WinNT4 (others not tested) */
void exitfct(void)
{
  OwnerPSP = oldPSP;
}

/*
 * show commands and options that are available.
 *
 */
static void showcmds(void)
{
  struct CMD *cmdptr;
  unsigned char y;
  extern struct CMD cmds[];     /* The internal command table */

  printf("Internal commands available:\n");
  y = 0;
  cmdptr = cmds;
  while (cmdptr->name)
  {
    if (++y == 8)
    {
      puts(cmdptr->name);
      y = 0;
    }
    else
      printf("%-10s", cmdptr->name);

    cmdptr++;
  }
  if (y != 0)
    putchar('\n');
  printf("\nFeatures available: ");
#ifdef FEATURE_ALIASES
  printf("[aliases] ");
#endif
#ifdef FEATURE_HISTORY
  printf("[history] ");
#endif
#ifdef FEATURE_FILENAME_COMPLETION
  printf("[filename completion] ");
#endif
  putchar('\n');
  putchar('\n');
}

/* Waits about 2 secs for a keypress.
   returns 0 if none else returns key pressed.
 */

int WaitForFkeys(void)
{
  struct time start,
    now;
  int secs = 3;
  int ch;

  gettime(&start);

  while (secs)
  {
    gettime(&now);
    if (now.ti_sec != start.ti_sec)
    {
      gettime(&start);
      secs--;
    }
    if (kbhit())
    {
      if ((ch = getch()) == 0)
        ch = getch() + 256;
//      printf("key pressed = %d\n",ch);
      return ch;
    }
  }
  return 0;
}

#define KEY_F5   319
#define KEY_F8   322

/*
 * set up global initializations and process parameters
 *
 * argc - number of parameters to command.com
 * argv - command-line parameters
 *
 *      This function will:
 *      1) Set up the host environment (Create a new environment segment if
 *              necessary, alter the parent process ID, catch ^Break etc.)
 *      2) Create the COMSPEC variable
 *      3) Parse the command line parameters passed to COMMAND.COM
 *      4) Perform all command line actions (spawn "/c" commands, alters
 *              size of environment etc.)
 *      5) If shell is interactive, invoke a ver() command.
 */

#pragma argsused
int initialize(int argc, char *argv[])
{
  char *comPath;                /* path to COMMAND.COM (for COMSPEC/reload) */
  char *newTTY;                 /* what to change TTY to */
  unsigned envSize;             /* minimum environment size (/E:) */
  int loadMSGs;                 /* load messages permanent into memory (/MSG) */
  int spawnCmd;                 /* spawn command (/C or /K) */
  int showhelp;                 /* show help /? */
  int showinfo;                 /* show initial info only if no command line options */
  int key;

  char *argv0;
  char *p;
  char *q;
  char *h;
  char buf[256];
  unsigned e;
  extern int canexit;

/* Set up the host environment of COMMAND.COM */

  /* Install the ^Break handler (see chkCBreak() for more details) */
  extern void initCBreakCatcher(void);
  initCBreakCatcher();

  /* Install INT 24 Critical error handler */
  init_error_handler();

  /* DOS shells patch the PPID to the own PID, how stupid this is, however */

  oldPSP = OwnerPSP;
  atexit(exitfct);
  OwnerPSP = _psp;

  /* Some elder DOSs may not receive an initialzied environment segment */
//#if 0
  if (env_glbSeg && !isMCB(SEG2MCB(env_glbSeg)))
    env_setGlbSeg(0);
//#endif

/* Now parse the command line parameters passed to COMMAND.COM */
  /* Preparations */
  comPath = newTTY = NULL;
  loadMSGs = tracemode = spawnCmd = showhelp = 0;
  showinfo = 1;

  /*JPP added 128 to size so that we can add COMSPEC and other variables */
  envSize = env_resize(0, 0) + 128;
  if (envSize < 160 || envSize > 32767)	/* invalid size? */
    envSize = 256;
  argv0 = argv[0];              /* preserve for later */

  while (!spawnCmd && (p = *++argv) != NULL)
  {                             /* one next argument */
    if (*p != '/')
    {                           /* non-option argument */
      if (!comPath)
        comPath = p;
      else if (!newTTY)
        newTTY = p;
      else
      {
        puts("Too many arguments");
        break;
      }
      if ((p = strchr(p, '/')) == NULL)	/* no option appended */
        continue;
      *p = '\0';
    }

    /* scan options */
    while (p && *++p)
    {
      /*      h := begin of option for printing error messages
         p := end of option string
         q := running pointer through option string
       */
      if ((p = strchr(h = q = p, '/')) != NULL)
        *p = '\0';
      switch (toupper(*q++))
      {
        case 'K':
        case 'C':
          if (*q)
            goto unknown;
          spawnCmd = toupper(q[-1]);
          showinfo = 0;
          break;

        case 'E':
          if (*q == ':' || *q == '=')
          {
            e = 0;
            while (isdigit(*++q))
              e = e * 10 + *q - '0';
            if (*q)
              printf("Invalid number in: %s\n", h);
            else if (e > 32767)
              printf("Number must be less than 32768 in: %s\n", h);
            else if (envSize < e)	/* don't shrink below minimum */
              envSize = e;
          }
          else if (!*q)
            puts("/E requires an argument");
          else
            goto unknown;
          break;

        case 'F':
          if (*q)
            goto unknown;
          autofail = 1;
          break;

        case 'M':
          if (strcmpi(q, "SG") == 0)
            loadMSGs = 1;
          else
            goto unknown;
          break;

        case 'P':
          if (*q)
            goto unknown;
          canexit = 0;
          break;

        case 'Y':
          if (*q)
            goto unknown;
          tracemode = 1;
          showinfo = 0;
          break;

        case '?':
          showhelp = 1;
          showinfo = 0;
          break;

        default:
        unknown:
          printf("Unknown option: %s\n", h);
      }
    }
  }

/* Now process the options */

#ifdef INCLUDE_CMD_CTTY

  if (newTTY)                   /* change TTY as early as poosible so the caller gets
                                   the messages into the correct channel */
    cmd_ctty(newTTY);
#endif

  /* First of all, set up the environment */
  env_resizeCtrl |= ENV_USEUMB | ENV_ALLOWMOVE;
  if (!env_newsize(0, envSize))
    puts("Could not resize/create environment");
//  else
  //  {
  //    printf("Environment size set to %d bytes.\n", envSize);
  //  }

  /* Then add the COMSPEC variable */
  if (comPath)
  {
    /* Remove quotes, maybe this comes handy in the future */
    q = stpcpy(buf, *comPath == '"' ? comPath + 1 : comPath);
    if (q[-1] == '"')
      --q;
    if (buf[1] != ':' || buf[2] != '\\')
    {
      puts("The path to " COM_NAME " must be fully qualified!"
      "That means including drive letter and beginning with a backslash."
           "For example: C:\\FDOS");
    }
    else
    {
      strcpy(q, "\\" COM_NAME);
      if (exist(buf))
      {
        q = buf;
        goto comFound;
      }
      printf("Cannot find " COM_NAME " in: %s\n", comPath);
    }
  }

  if (!argv0 || !*argv0 || !exist(argv0))
  {
    if (argv0 && *argv0)
      printf("Cannot find: %s\n", argv0);
    puts("You must specify the complete path to " COM_NAME);
    puts("as the first argument of COMMAND,");
    puts("for instance: C:\\FDOS");
    exit(101);
  }

  q = argv0;

comFound:
  comPath = _fullpath(NULL, q, 0);
  ComDir = strdup(comPath);

  q = strrchr(ComDir, '\\');
  if (q)
    *++q = 0;

  if (chgEnv("COMSPEC", comPath))
    error_env_var("COMSPEC");

  free(comPath);

  /* Here the messages had to be loaded, the filename is in 'p' */
  if (loadMSGs)
  {
    /* no transient portion --> no reload */
    puts("The /MSG option has no effect, yet.");
  }

#ifdef FEATURE_ALIASES
  aliasload(ComDir, "ALIAS.SYS");
#endif

  /* Now the /P option can be processed */
  if (!canexit)
  {
    key = WaitForFkeys();

    if (key == KEY_F8)
    {
      tracemode = 1;
      showinfo = 0;
    }

    if (key == KEY_F5)
    {
      printf("Bypassing AUTOEXEC.BAT file.\n");
    }
    else
    {
      if (exist("\\AUTOEXEC.BAT"))
        parsecommandline("\\AUTOEXEC.BAT");
      else
      {
#ifdef INCLUDE_CMD_DATE
        cmd_date(NULL);
#endif
#ifdef INCLUDE_CMD_TIME
        cmd_time(NULL);
#endif
      }
    }
  }

  /* Now the /C or /K option can be processed */
  if (spawnCmd)
  {
    q = buf;
    buf[0] = '\0';              /* if no further argument */
    while ((p = *++argv) != NULL)
    {
      *q = ' ';
      stpcpy(q + 1, p);
    }

    parsecommandline(buf + 1);

    if (spawnCmd != 'K')
      return 1;
  }

  if (showinfo)
  {
    short_version();
    putchar('\n');
    showcmds();
  }

  return 0;
}
