/*
 * MISC.C -- Misc. Functions
 *
 * 07/12/98 (Rob Lake) -----------------------------------------------------
 *  started
 *
 * 07/13/98 (Rob Lake) -----------------------------------------------------
 *      moved functions in here
 *
 */

#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <direct.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <dir.h>
#include <conio.h>
#include <sys/stat.h>
#include "command.h"

/*
 * exist -- Checks if a file exists
 *
 */
int
exist(char *fn)
{
  return (access(fn, 0) == 0);
}
/*
 * get a character out-of-band and honor Ctrl-Break characters
 */
int
cgetchar(void)
{
  int c;

  if ((c = getch()) == 0)
    c = getch() << 8;

  if (c == 3)
    ctrlBreak = 1;

  return c;
}

/*
 * Check if Ctrl-Break was pressed during the last calls
 */
int
chkCBreak(int mode)
{
  static int leaveAll = 0;      /* leave all batch files */
  int c;

  switch (mode)
  {
    case BREAK_OUTOFBATCH:
      leaveAll = 0;
      return 0;
    case BREAK_BATCHFILE:
      if (leaveAll)
        return 1;
      if (!ctrlBreak)
        return 0;

      /* we need to be sure the string arrives on the screen! */
      do
        cputs("\r\nCtrl-Break pressed.  Cancel batch file? (Yes/No/All) ");
      while (!strchr("YNA\3", c = toupper(cgetchar())) || !c);

      cputs("\r\n");

      if (c == 'N')
        return ctrlBreak = 0;   /* ignore */

      leaveAll = c == 'A' || c == '\3'; /* leave all batch files */

      break;
    case BREAK_INPUT:
      if (!ctrlBreak)
        return 0;
      break;
  }

  ctrlBreak = 0;                /* state processed */
  return 1;
}

/*
 * function to destructively split a string into an array of strings
 *
 * Changed return value to int to determine number of args
 *   -- Rob Lake (06/29/98)
 *
 */
int
split(char *s, char **p)
{
  int sc = 0,
    pc = 0;                     /* string and parameter counters */

  while (s[sc])
  {
    if (sc && isspace(s[sc]) && !isspace(s[sc - 1]))
      s[sc] = 0;

    else if (!isspace(s[sc]) && (sc == 0 || isspace(s[sc - 1]) ||
                                 s[sc - 1] == 0))
      p[pc++] = &s[sc];

    sc++;
  }

  p[pc] = NULL;
  return pc;
}

/*
 * internal function to get the first argument from the parameter list
 * and return a pointer to the beginning of the next argument, or NULL if
 * there are no more arguments
 *
 */
char *
parse_firstarg(char *s)
{
  char *place;

  /* skip over first argument */
  place = s;
  while (*place && !isspace(*place))
    place++;

  if (*place)
  {
    /* mark the end of the first parameter */
    *place++ = 0;

    /* skip over whitespace before next argument */
    while (isspace(*place))
      place++;

    /* if there is something here, return a pointer to it, else NULL */
    if (*place)
      return place;
    else
      return NULL;
  }
  else
    return NULL;
}
