/*
 *  INTERNAL.C - command.com internal commands.
 *
 *  Comments:
 *
 *  17/08/94 (Tim Norman) ---------------------------------------------------
 *    started.
 *
 *  08/08/95 (Matt Rains) ---------------------------------------------------
 *    i have cleaned up the source code. changes now bring this source into
 *    guidelines for recommended programming practice.
 *
 *  cd()
 *    started.
 *
 *  dir()
 *    i have added support for file attributes to the DIR() function. the
 *    routine adds "d" (directory) and "r" (read only) output. files with the
 *    system attribute have the filename converted to lowercase. files with
 *    the hidden attribute are not displayed.
 *
 *    i have added support for directorys. now if the directory attribute is
 *    detected the file size if replaced with the string "<dir>".
 *
 *  ver()
 *    started.
 *
 *  md()
 *    started.
 *
 *  rd()
 *    started.
 *
 *  del()
 *    started.
 *
 *  does not support wildcard selection.
 *
 *  todo: add delete directory support.
 *        add recursive directory delete support.
 *
 *  ren()
 *    started.
 *
 *  does not support wildcard selection.
 *
 *    todo: add rename directory support.
 *
 *  a general structure has been used for the cd, rd and md commands. this
 *  will be better in the long run. it is too hard to maintain such diverse
 *  functions when you are involved in a group project like this.
 *
 *  12/14/95 (Tim Norman) -----------------------------------------------------
 *    fixed DIR so that it will stick \*.* if a directory is specified and
 *    that it will stick on .* if a file with no extension is specified or
 *    *.* if it ends in a \
 *
 *  1/6/96 (Tim Norman) -----------------------------------------------------
 *    added an isatty call to DIR so it won't prompt for keypresses unless
 *    stdin and stdout are the console.
 *
 *    changed parameters to be mutually consistent to make calling the
 *    functions easier
 *
 *  rem()
 *    started.
 *
 *  doskey()
 *    started.
 *
 *  1/22/96 (Oliver Mueller) -------------------------------------------------
 *    error messages are now handled by perror.
 *
 *  02/05/96 (Tim Norman) ----------------------------------------------------
 *    converted all functions to accept first/rest parameters
 *
 *  07/26/96 (Tim Norman) ----------------------------------------------------
 *     changed return values to int instead of void
 *
 *  path()
 *     started.
 *
 *  12/23/96 (Aaron Kaufman) -------------------------------------------------
 *     rewrote dir() to mimic MS-DOS's dir
 *
 *  01/28/97 (Tim Norman) ----------------------------------------------------
 *     cleaned up Aaron's DIR code
 *
 *  06/13/97 (Tim Norman) ----------------------------------------------------
 *     moved DIR code to dir.c
 *     re-implemented Aaron's DIR code
 *
 *  06/14/97 (Steffan Kaiser) ------------------------------------------------
 *     ctrl-break handling
 *     bug fixes
 *
 *  06/14/97 (Tim Norman) ----------------------------------------------------
 *     changed static var in set() to a malloc'd space to pass to putenv.
 *     need to find a better way to do this, since it seems it is wasting
 *     memory when variables are redefined.
 *
 *  06/29/98 (Rob Lake) ------------------------------------------------------
 *      rewrote del to support wildcards
 *      added my name to the contributors
 *
 *  06/30/98 (Rob Lake) ------------------------------------------------------
 *      rewrote ver command to accept switches, now ver alone prints
 *      copyright notice only.
 *  07/08/1998 (John P. Price)
 *  - removed call to show_environment in set command.
 *  - moved test for syntax before allocating memory in set command.
 *  - misc clean up and optimization.
 * 07/13/98 (Rob Lake)
 *  - fixed bug that caused del not to delete file with out attribute.
 *      - moved set, del, ren, and ver to there own files
 *
 */

#include <stdlib.h>
#include <dos.h>
#include <direct.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <dir.h>
#include <conio.h>
#include <io.h>
#include <sys/stat.h>
#include "command.h"

#define SET "set"

/*
 *  generic function to handle cd, md, and rd (and their verbose names)
 *
 *
 */
int
directory_handler(char *first, char *rest,
                  int (*func) (const char *),
                  char *func_name, char *usage)
{
  char *dir;                    /* pointer to the directory to change to          */
  char *place;                  /* used to search for the \ when no space is used */

  /* check if there is no space between the command and the path */
  if (rest[0] == 0)
  {
    /* search for the \ or . so that both short & long names will work */
    for (place = first; *place; place++)
      if (*place == '.' || *place == '\\')
        break;

    if (*place)
      dir = place;
    else
      dir = NULL;               /* signal that there are no parameters */
  }
  else
  {
    /* if there is more than 1 parameter */
    if (parse_firstarg(rest) != NULL)
    {
      puts(BADCMDLINE);         /* JPP 07/08/1998 clean up */
      printf(USAGE ": %s\n", usage);  /*JPP 07/08/1998 clean up */
      return 1;
    }
    else
      dir = rest;
  }

  /* if doing a CD and no parameters given, print out current directory */
  if (func == chdir && (!dir || !dir[0]))
  {
    char direc[128];
    char temp[128];

    direc[0] = getdisk() + 'A';
    direc[1] = ':';
    getcurdir(0, temp);

    if (temp[0] == '\\')
    {
      strcpy(&direc[2], temp);
    }
    else
    {
      direc[2] = '\\';
      strcpy(&direc[3], temp);
    }

    printf("%s\n", direc);

    return 0;
  }

  /* take off trailing \ if any, but ONLY if dir is not the root dir */
  if (strlen(dir) >= 2 && dir[strlen(dir) - 1] == '\\')
    dir[strlen(dir) - 1] = 0;

  if (func(dir) != 0)
  {
    perror(func_name);
    return 1;
  }

  return 0;
}

/*
 * CD / CHDIR - makes a call to directory_handler to do its work
 *
 *
 */
int
cd(char *first, char *rest)
{
  return directory_handler(first, rest, chdir, "cd()", CD_HELP);
}

/*
 * MD / MKDIR - makes a call to directory_handler to do its work
 *
 *
 */
int
md(char *first, char *rest)
{
  return directory_handler(first, rest, mkdir, "md()", MD_HELP);
}

/*
 * RD / RMDIR - makes a call to directory_handler to do its work
 *
 *
 */
int
rd(char *first, char *rest)
{
  return directory_handler(first, rest, rmdir, "rd()", RD_HELP);
}

/*
 *
 * set the exitflag to true
 *
 */
#pragma argsused
int
internal_exit(char *first, char *rest)
{
  exitflag = 1;

  return 0;
}

/*
 *
 * does nothing
 *
 */
#pragma argsused
int
rem(char *first, char *rest)
{
  return 0;
}

/*
 *
 * prints DOSKEY message...  will soon emulate DOSKEY macros
 *
 */
#pragma argsused
int
doskey(char *first, char *rest)
{
  printf("DOSKEY features are already enabled in the shell.\n");

  return 0;
}

/*
 *
 * changes the PROMPT env. var.
 *
 */
#pragma argsused
int
prompt(char *first, char *rest)
{
  char *from,
    tempcommand[256];

  /* create a fake command to pass to set() */
  strcpy(tempcommand, PROMPTEQUAL);
  if (*rest == '=')
  {
    from = &rest[1];
    while (isspace(*from))
      from++;
    strcat(tempcommand, from);
  }
  else
    strcat(tempcommand, rest);

  return set(SET, tempcommand);
}

/*
 *
 * changes the PATH env. var.
 *
 */
#pragma argsused
int
path(char *first, char *rest)
{
  char *from,
    tempcommand[256];

  if (!rest || !*rest)
  {
    printf("PATH=%s\n", getenv("PATH"));
    return 0;
  }

  /* create a fake command to pass to set() */
  strcpy(tempcommand, PATHEQUAL);
  if (*rest == '=')
  {
    from = &rest[1];
    while (isspace(*from))
      from++;
    strcat(tempcommand, from);
  }
  else
    strcat(tempcommand, rest);

  return set(SET, tempcommand);
}
