/* 
 *  WHERE.C - path functions.
 *
 *
 *
 *  Comments:
 *
 *  07/15/95 (Tim Norman) ---------------------------------------------------
 *    started.
 *
 *  08/08/95 (Matt Rains) ---------------------------------------------------
 *    i have cleaned up the source code. changes now bring this source into
 *    guidelines for recommended programming practice.
 *
 *  12/12/95 (Steffan Kaiser & Tim Norman) ----------------------------------
 *    added some patches to fix some things and make more efficient
 *
 *  1/6/96 (Tim Norman) -----------------------------------------------------
 *    fixed a stupid pointer mistake...  Thanks to everyone who noticed it!
 *
 *  8/1/96 (Tim Norman) -----------------------------------------------------
 *    fixed a bug when getenv returns NULL
 *
 *  8/7/96 (Steffan Kaiser and Tim Norman) ----------------------------------
 *    speed improvements and bug fixes
 *
 *  8/27/96 (Tim Norman) ----------------------------------------------------
 *    changed code to use pointers directly into PATH environment variable
 *    rather than making our own copy.  This saves some memory, but requires
 *    we write our own function to copy pathnames out of the variable.
 *
 *  12/23/96 (Aaron Kaufman) ------------------------------------------------
 *    Fixed a bug in get_paths() that did not point to the first PATH in the
 *    environment variable.
 *
 *  7/12/97 (Tim Norman) ----------------------------------------------------
 *    Apparently, Aaron's bugfix got lost, so I fixed it again.
 *
 */

#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>

/*
 * 
 *  copy a string, stopping at ';' or '\0'
 * 
 *  Return value:  position in dest where NUL is placed
 * 
 */
char *
pathcpy(char *dest, char *src)
{
  char *ret, *tmp = dest;

  /* copy data */
  while (*src != ';' && *src != 0)
    *dest++ = *src++;

  /* strip final backslash if there is one */
  ret = dest > tmp && dest[-1] == '\\' ? dest - 1 : dest;
  *ret = 0;
  return ret;
}

/*
 *
 *  get paths from environment variable and assigns an array of pointers
 *  to point to each individual path entry
 *
 */
void 
get_paths(char *paths[129])
{
  char *p;                      /* pointer to path */
  int count, pos;               /* counters */

  p = getenv("PATH");
  if (!p)
  {
    paths[0] = ".";
    paths[1] = NULL;
    return;
  }

  /* set up paths array */
  paths[0] = ".";
  paths[1] = p;
  pos = 0;
  count = 2;

  /* set the pointers in paths */
  while (p[pos] != 0)
  {
    if (p[pos] == ';')
    {
      if (p[pos + 1] != 0)
      {
        paths[count] = &p[pos + 1];
        count++;
      }
    }
    pos++;
  }

  paths[count] = NULL;          /* last path points to NULL */

  /* paths is now an array of pointers to all the search paths */
  /* we need to use pathcpy to copy stuff out of it */

  return;
}

/*
 *
 *  searches for file using path info.
 *
 */
int 
find_which(char *paths[129], char *fname, char *fullname)
{
  struct ffblk f;               /* directory search structure */

  int count;
  int tryall;                   /* whether to try all extensions */
  int extcount;
  char *extp;
  static char ext[3][5] =
  {".COM", ".EXE", ".BAT"};

  count = 0;

  /* is there an extension and is it in the last path component? */
  tryall = !(extp = strrchr(fname, '.')) || strchr(extp + 1, '\\');

  /* if a path is already specified, then just try tacking on .com, .exe */
  if (strchr(fname, '\\') || fname[1] == ':')
  {
    if (tryall == 0)
    {
      strcpy(fullname, fname);
      return 1;
    }

    extp = stpcpy(fullname, fname);

    for (extcount = 0; extcount < 3; extcount++)
    {
      strcpy(extp, ext[extcount]);

      if (findfirst(fullname, &f, 7) == 0)
        return 1;
    }
  }
  else
    while (paths[count])        /* cycle through paths */
    {
      /* create base filename */
      extp = stpcpy(stpcpy(pathcpy(fullname, paths[count]), "\\"), fname);

      if (tryall)
      {
        /* try all extensions */
        for (extcount = 0; extcount < 3; extcount++)
        {
          strcpy(extp, ext[extcount]);

          if (findfirst(fullname, &f, 7) == 0)
            return 1;
        }
      }
      else
      {
        if (findfirst(fullname, &f, 7) == 0)
          return 1;
      }
      count++;
    }

  return 0;
}
