/*
 * TRUENAME.C -- Truename Command (undocumented DOS?)
 *
 * 07/14/98 (Rob Lake)
 *  - started and tested fine
 *  - added stand alone debugging
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 28-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - changed _truename function so it does not return a pointer to a local
 *   variable.
 *
 * 09-Aug-1998 (Rob Lake <rlake@cs.mun.ca>)
 * - _truename now sets errno
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_TRUENAME

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <dir.h>

#include "command.h"

char *_truename(char *fn)
{
	char fn1[MAXPATH];
	struct REGPACK rp;

	assert(fn);

	strcpy(fn1, fn);
	rp.r_ds = FP_SEG(fn1);
	rp.r_si = FP_OFF(fn1);
	rp.r_es = FP_SEG(fn);
	rp.r_di = FP_OFF(fn);
	rp.r_ax = 0x60 << 8;          // AH = 0x60

	intr(0x21, &rp);

	if (rp.r_flags & 1)
	{
		errno = rp.r_ax >> 8;
		*fn = '\0';
	}
	return fn;
}

#pragma argsused
int cmd_truename(char *rest)
{
	char p[MAXPATH];

  assert(rest);

  if (*rest)
  {
    strcpy(p, rest);
    _truename(p);
  }
  else
  {
    strcpy(p, ".");
    _truename(p);
  }

  if (*p == '\0')
  {
    error_path_not_found();
		return 0;
  }

  puts(p);

  return 1;
}

#ifdef DEBUG_STANDALONE
int main(int argc, char **argv)
{
  cmd_truename(argv[1]);

  return 0;
}
#endif

#endif
