/* A structure to preserve the context of a batch file */

/*  Added:
   bfnam -- name of batchfile for modifyable scripts if bfile == NULL
   bpos -- position within batchfile, if bfile == NULL
   blinecnt  -- line counter
   bclose -- close file if it was opened temporarily
   brewind -- rewind file instead of positioning to bpos
   blabel -- to search for if != NULL
*/

#include <stdio.h>
#ifndef __PACIFIC__
#include <dir.h>
#endif

struct bcontext
{
  struct bcontext *prev;
  FILE *bfile;
  char *bfnam;                  /* name of batchfile */
  char *forproto;
  char *params;
  char *blabel;                 /* label to search for */
  struct ffblk *ffind;
#ifndef __PACIFIC__
  fpos_t bpos;                  /* position within file if bfile == NULL */
#else
  unsigned long bpos;           /* position within file if bfile == NULL */
#endif
  long blinecnt;                /* line counter */
  int shiftlevel;
  int echo;                     /* Preserve echo flag across batch calls */
  int bclose;
  int brewind;
  char forvar;
};

/*  The stack of current batch contexts.
 * NULL when no batch is active
 */
extern struct bcontext *bc;

extern unsigned int echo;       /* The echo flag */
extern int tracemode;                   /* debug script? */

void exit_batch(void);

extern char *batch_params(char *s1, char *s2);

extern struct bcontext *newBatchContext(void);
extern void initBatchContext(struct bcontext *b);
