/*
 *  VERIFY.C - verify command.
 *
 *  Comments:
 *
 * 31 Jul 1998 (John P Price)
 *   started.
 *
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_VERIFY

#include <stdio.h>
#include <string.h>
#include <dos.h>

#include "command.h"

#pragma argsused
int cmd_verify(char *cmd, char *param)
{
  dprintf(("CMD '%s' : '%s'\n", cmd, param));

  if (strcmp(param, "/?") == 0)
  {
    puts(
"Sets whether to verify that your files are written correctly to a\n"
"disk.\n"
"\n"
"VERIFY [ON | OFF]\n"
"\n"
"Type VERIFY without a parameter to display the current VERIFY setting."
    );
    return 0;
  }

  if (!*param)
    printf("VERIFY is %s\n", getverify() ? D_ON : D_OFF);
  else if (stricmp(param, D_OFF) == 0)
    setverify(0);
  else if (stricmp(param, D_ON) == 0)
    setverify(1);
  else
    puts("Must specify ON or OFF.");

  return 0;
}

#endif
