/*
 * VER.C
 *
 *  06/30/98 (Rob Lake)
 *      rewrote ver command to accept switches, now ver alone prints
 *      copyright notice only.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 30-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added text about where to send bug reports and get updates.
 *
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "command.h"

#define VER_HELP     "display shell version info   VER [/C/R/W/?]"


void short_version(void)
{
  printf("\n" SHELLINFO " " SHELLVER "\n");
}


#ifdef INCLUDE_CMD_VER

/*
 *  display shell version info internal command.
 *
 *
 */
#pragma argsused
int cmd_ver(char *first, char *rest)
{
  int i;

  /* JPP 07/08/1998 clean up and shortened info. */

  puts("\n" SHELLINFO " " SHELLVER "\nCopyright (C) 1994-1998 Tim Norman and others.");
  /* Basic copyright notice */
  if (rest[0] == 0)
  {
    puts("\n"SHELLINFO
           " comes with ABSOLUTELY NO WARRANTY; for details\n"
           "type: `ver /w'. This is free software, and you are welcome to redistribute\n"
           "it under certain conditions; type `ver /r' for details. Type `ver /c' for a\n"
           "listing of credits.");
  }
  else
  {
    /* MS-DOS ver prints just help if /? is alone or not */
    if (strstr(rest, "/?") != NULL)
    {
      puts(USAGE ": " VER_HELP);
      return 0;
    }

    for (i = 0; rest[i]; i++)
    {
      /* skip spaces */
      if (rest[i] == ' ')
        continue;
      if (rest[i] == '/')
      {
        /* is this a lone '/' ? */
        if (rest[i + 1] == 0)
        {
          error_invalid_switch(' ');
          return 1;
        }
        continue;
      }
      if (toupper(rest[i]) == 'W')
      {                           /* Warranty notice */
        /* JPP 07/08/1998 removed extra printf calls */
        puts("\n This program is distributed in the hope that it will be useful,\n"
           " but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
             " MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
             " GNU General Public License for more details.");
      }
      else if (toupper(rest[i]) == 'R')
      {                           /* Redistribution notice */
        /* JPP 07/08/1998 removed extra printf calls */
        puts("\n This program is free software; you can redistribute it and/or modify\n"
             " it under the terms of the GNU General Public License as published by\n"
        " the Free Software Foundation; either version 2 of the License, or\n"
             " (at your option) any later version.");
      }
      else if (toupper(rest[i]) == 'C')
      {                           /* Developer listing */
        /* JPP 07/08/1998 removed extra printf calls; rearranged names */
        puts("\ndeveloped by:\n"
             "    Tim Norman      Matt Rains\n"
             "    Evan Jeffrey    Steffen Kaiser\n"
             "    Svante Frey     Oliver Mueller\n"
             "    Aaron Kaufman   Marc Desrochers\n"
             "    Rob Lake        John P Price\n"
             "    Hans B Pufal");
      }
      else
      {
        error_invalid_switch(toupper(rest[i]));
        return 1;
      }

    }
  }
  puts("\nSend bug reports to command@gcfl.net.\n"
     "Updates are available from http://www.gcfl.net/FreeDOS/command.com.");
  return 0;
}

#endif
