/*
 *  DEL.C - del command.
 *
 *  Comments:
 *
 *  06/29/98 (Rob Lake rlake@cs.mun.ca)
 *      rewrote del to support wildcards
 *      added my name to the contributors
 *
 * 07/13/98 (Rob Lake)
 *  - fixed bug that caused del not to delete file with out attribute.
 *  - moved set, del, ren, and ver to there own files
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_DEL

#include <dir.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <direct.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>

#include "command.h"

/*

 *  simple file delete internal command.
 *  Rewritten by Rob Lake (06/29/98)
 *
 */

#define DEL_HELP     "delete file   DEL [d:][path]filespec"

#pragma argsused
int cmd_del(char *first, char *rest)
{
  int done,
    flags,
    orig_disk,
    args,
    inter,
    filespec;

  struct ffblk f;
  struct stat stbuf;

  static char drive[MAXDRIVE],
    dir[MAXDIR],
    file[MAXFILE],
    ext[MAXEXT];

  char fn[MAXFILE + MAXEXT + 1],
    orig_dir[MAXPATH];

  static char **arg;

  drive[0] = '\0';
  dir[0] = '\0';

  args = split(rest, arg);
  inter = 0;
  filespec = 0;

  if (args > 2)
  {
    error_too_many_parameters(arg[args - 1]);
    return 1;
  }
  else if (args >= 1)
  {
    /* check for /? anywhere in command line */
    if (stricmp(arg[2], "/?") == 0 ||
        stricmp(arg[1], "/?") == 0 ||
        stricmp(arg[0], "/?") == 0)
    {
      printf("%s: %s\n", USAGE, DEL_HELP);
      return 0;
    }
    if (stricmp(arg[1], "/p") == 0)
    {
      inter = 1;
      filespec = 0;
    }
    else if (stricmp(arg[0], "/p") == 0)
    {
      filespec = 1;
      inter = 1;
    }
    /* only one argument and that's /P */
    if (args == 1 && inter)
    {
      error_req_param_missing();
      return 1;
    }
    /* check whether the file actually exists */
    if (access(arg[filespec], 2) != 0 &&
        strchr(arg[filespec], '*') == NULL)
    {
      error_file_not_found();
      return 1;
    }
    stat(arg[filespec], &stbuf);
    /* check if it is a directory */
    if ((stbuf.st_mode & S_IFMT) == S_IFDIR
        && strchr(arg[filespec], '*') == NULL)
      strcat(arg[filespec], "\\");

    flags = fnsplit(arg[filespec], drive, dir, file, ext);
    /* build the filename, wildcards allowed */
    if (flags & FILENAME && flags && EXTENSION)
      sprintf(fn, "%s%s", file, ext);
    else if (flags & FILENAME && (flags && EXTENSION) == 0)
      sprintf(fn, "%s", file);
    else
      sprintf(fn, "*.*");

    /* uppercase the strings, for prettier output */
    strupr(drive);
    strupr(dir);
    strupr(file);
    strupr(ext);

    if (flags & DRIVE)
    {
      orig_disk = getdisk();
      _chdrive(drive[0] - 'A' + 1);
    }

    if (flags & DIRECTORY)
    {
      if (strlen(dir) > 1)
        dir[strlen(dir) - 1] = '\0';
      getcwd(orig_dir, MAXPATH);
      if (chdir(dir))
      {
        error_path_not_found();
        return 1;
      }
      if (dir[0] != '\0' && strlen(dir) > 1)
        strcat(dir, "\\");
    }
  }
  else
  {
    /* only command given */
    error_req_param_missing();
    return 1;
  }

  /* needed? */
  if (inter && args == 1)
  {
    error_req_param_missing();
    return 1;
  }

  /* make sure user is sure if all files are to be
   * deleted */
  if (strcmp(fn, "*.*") == 0 && !inter)
  {
    int yes;
    char c;
    c = 0;
    yes = 0;
    puts("All files in directory will be deleted!\n");
    puts("Are you sure (Y/N)?");
    while (c != 13)
    {
      c = getch();
      while (toupper(c) != 'N' && toupper(c) != 'Y')
        c = getch();
      putchar(toupper(c));
      if (toupper(c) == 'Y')
        yes = 1;
      else
        yes = 0;
      c = getch();
      if (c == 8)
        printf("\b \b");
    }
    printf("\n");
    if (yes == 0)
    {
      chdir(orig_dir);
      return 1;
    }
  }

  done = findfirst(fn, &f, FA_ARCH);
  if (done)
  {
    chdir(orig_dir);
    error_file_not_found();
    return 0;
  }

  while (!done)
  {
    int okay = 1;
    if (inter)
    {
      char c;
      okay = -1;
      printf(drive);
      printf(dir);
      printf(f.ff_name);
      while (okay == -1)
      {
        printf(", Delete(Y/N)?");
        c = toupper(getche());
        if (c == 'Y')
          okay = 1;
        else if (c == 'N')
          okay = 0;
        else if (c == 3)
        {                       /* ^C pressed */
          if (flags & DRIVE)
            _chdrive(orig_disk + 1);
          chdir(orig_dir);
          printf("\n");
          return 1;
        }
        else
        {
          printf(drive);
          printf(dir);
          printf(f.ff_name);
        }
      }
      printf("\n");
    }
    if (okay)
    {
#ifdef NODEL
/* define NODEL if you want to debug */
      printf(drive);
      printf(dir);
      printf(f.ff_name);
      printf("\n");
#else
      if (unlink(f.ff_name) != 0)
      {
        perror("del()");
        return 1;
      }
#endif
    }
    done = findnext(&f);
  }

  if (flags & DRIVE)
    _chdrive(orig_disk + 1);
  chdir(orig_dir);
  return 0;
}

#endif
