/*
 * MESSAGES.C - Read messages from strings database located in a file or
 *              at the end of command.com
 *
 *
 * Comments:
 *
 * 27 Jul 1998  John P. Price
 * - started.
 *
 * 03-Dec-1998  John P. Price
 * - Reduced the ammount of memory allocated by not reading in entire index,
 *   but only the index element needed.
 *
 */

//#define READ_FROM_FILE

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <alloc.h>
#include <dir.h>

#include "command.h"
#include "strings.h"

void display_string(unsigned id,...)
{
  struct indextype
  {
    unsigned index;
    unsigned size;
  }
   *string_index;

  va_list argptr;
  FILE *f;
  char fdid[10];
  char *theid = STRINGS_ID;
  char *thisstr;

  unsigned segs;
  unsigned offs;
  unsigned long offset;

  if (id >= NUMBER_OF_STRINGS)
  {
    printf("Invalid string ID!\n");
    return;
  }

#ifdef READ_FROM_FILE
  if ((thisstr = malloc(MAXPATH)) == NULL)
  {
    printf("Out of memory accessing strings.dat file.\n");
    return;
  }
  strcpy(thisstr, ComDir);
  strcat(thisstr, "STRINGS.DAT");
  if ((f = fopen(thisstr, "rb")) == NULL)
  {
    perror("Can not access strings.dat!");
    free(thisstr);
    return;
  }
  free(thisstr);

  offset = 0;
#else
  if ((f = fopen(getEnv("COMSPEC"), "rb")) == NULL)
  {
    if ((thisstr = malloc(MAXPATH)) != NULL)
    {
      strcpy(thisstr, ComDir);
      strcat(thisstr, "COMMAND.COM");
      if ((f = fopen(thisstr, "rb")) == NULL)
      {
        perror("Can not open COMMAND.COM to read strings!");
        free(thisstr);
        return;
      }
      free(thisstr);
    }
    else
      return;
  }

//  printf("%s opened.\n",getEnv("COMSPEC"));

  fread(fdid, 2, 1, f);
  if (fdid[0] != 'M' || fdid[1] != 'Z')
  {
    printf("COMMAND.COM not a valid EXE file (MZ not found)!\n");
    fclose(f);
    return;
  }

  fread(&offs, sizeof(unsigned), 1, f);
  fread(&segs, sizeof(unsigned), 1, f);

//  printf("segs = %u  offs = %u\n",segs,offs);

  if (offs != 0)
    segs--;

  offset = (long)segs *512 + offs;
  printf("offset = %lu\n", offset);

  fseek(f, offset, SEEK_SET);

  printf("memory = %u\n", coreleft());

#endif

  fread(fdid, strlen(theid), 1, f);

  if (strncmp(fdid, theid, strlen(STRINGS_ID)))
  {
    printf("Strings ID not valid!\n");
    fclose(f);
    return;
  }

  offset += strlen(theid);

  if ((string_index = malloc(sizeof(struct indextype))) == NULL)
  {
    printf("Out of memory reading string index in.\n");
    fclose(f);
    return;
  }

//  printf("Reading %u bytes of string index in...",NUMBER_OF_STRINGS * sizeof(unsigned));
  //  fread(string_index, sizeof(struct indextype), NUMBER_OF_STRINGS, f);
  //  printf("done!\n");

  //read index value into string_index
  fseek(f, id * sizeof(struct indextype), SEEK_CUR);
  fread(string_index, sizeof(struct indextype), 1, f);

  if ((thisstr = malloc(string_index->size)) == NULL)
  {
    printf("Out of memory reading string in.\n");
    free(string_index);
    fclose(f);
    return;
  }

  offset += NUMBER_OF_STRINGS * sizeof(struct indextype);

  fseek(f, string_index->index + offset, SEEK_SET);
//  printf("Reading %u bytes of string in...",string_index[id].size);
  fread(thisstr, string_index->size, 1, f);
//  printf("done!\n");

  free(string_index);

  fclose(f);

  va_start(argptr, id);
  vprintf(thisstr, argptr);
  va_end(argptr);
  free(thisstr);
}
