/* choice.c */

/* Waits for the user to press a key, which must be in a list of
   choices */

/*
   Copyright (C) 1994--2002 Jim Hall, jhall@freedos.org

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>			/* strtok  */
#include <ctype.h>			/* toupper */

#include <conio.h>			/* getch (Borland) */
#include <dos.h>			/* delay (Borland) */

#include "getopt.h"			/* GNU getopt      */
#include "catgets.h"			/* catopen/catgets */


/* Symbolic constants */

/* #define DEBUG				/* debugging   */
#define beep() putch('\a')			/* make a beep */


/* Function prototypes */

void usage (nl_catd cat);
extern int getopt (int argc, char *const *argv, const char *shortopts);


int
main (int argc, char **argv)
{
  char *s;
  char *choices;			/* the list of choices       */

  int i;
  int key;				/* the key that was pressed */
  int def_key;				/* default key after wait   */
  int def_wait = 0;			/* default time to wait     */
  int wait;				/* how long we have waited  */

  int opt_beep = 0;			/* do we make a beep?       */
  int show_choices = 1;			/* do we show choices?      */
  int case_sensitive = 0;		/* are we case sensitive?   */

  nl_catd cat;				/* language catalog         */

#ifdef DEBUG /* debugging */
  printf ("Begin\n");
#endif /* debugging */

  /* Open the message catalog */

  cat = catopen ("choice", 0);

  /* Scan command line */

  opterr = 0;					/* no error messages */

  choices = catgets (cat, 3, 0, "yn");		/* set default choices */

  while ((i = getopt (argc, argv, "aAbBc:C:nNsSt:T:")) != EOF)
    {
      switch (i)
	{
	case 'a':
	case 'A': /* Alert */
	case 'b':
	case 'B': /* Beep */
	  /* Not sure if I prefer /A or /B, so I'll keep both for now. -jh */
	  opt_beep = 1;
	  break;

	case 'c':
	case 'C': /* allowable chars */
	  choices = optarg;			/* pointer assignment */
	  if (choices[0] == ':')
	    {
	      /* possible workaround for a getopt bug? */
	      choices++;
	    }
	  break;

	case 'n':
	case 'N': /* do not display choices at end */
	  show_choices = 0;
	  break;

	case 's':
	case 'S': /* be case sensitive */
	  case_sensitive = 1;
	  break;

	case 't':
	case 'T': /* time to wait */
	  s = strtok (optarg, ":,");
	  def_key = s[0];

	  s = strtok (NULL, ":,");
	  def_wait = atoi (s);

#ifdef DEBUG /* debugging */
	  printf ("/T triggered:\n");
	  printf ("def_wait=%d\n", def_wait);
	  printf ("def_key=%c\n", def_key);
#endif /* debugging */
	  break;

	default:
	  /* show usage, and quit */

	  usage (cat);
	  catclose (cat);
	  exit (0);
	  break;
	} /* switch */
    } /* while */

  /* Make sure def_key is valid */
  /* Set def_key if not given */

  if (def_wait > 0)
    {
      if (!strchr (choices, def_key))
	{
	  def_key = choices[0];
	}
    }
  else
    {
      def_key = choices[0];
    }

#ifdef DEBUG /* debugging */
  printf ("After fixup:\n");
  printf ("def_wait=%d\n", def_wait);
  printf ("def_key=%c\n", def_key);
#endif /* debugging */

  /* Display text */

  if (optind < argc)
    {
      for (i = optind; i < argc; i++)
	{
	  printf ("%s ", argv[i]);
	}
    }

  if (show_choices)
    {
      if (!case_sensitive)
	{
	  for (i = 0; choices[i]; i++)
	    {
	      /* Uppercase the choices */
	      choices[i] = toupper(choices[i]);
	    }
	}

      /* print the choices */

      printf ("[%s]? ", choices);
    }

  /* Make a beep */

  if (opt_beep)
    {
      beep();
    }

  /* Grab the key.  Don't exit until we found it. */

  for (wait = 0; ; wait++)
    {
      if (def_wait > 0)
	{
	  delay (500);			/* wait for half a second */

	  if (kbhit())
	    {
	      key = getch();		/* grab the key */
	    }
	  else if ((wait * 2) > def_wait)
	    {
	      key = def_key;		/* grab the default key */
	    }
	}
      else
	{
	  key = getch();		/* grab the key */
	}

      for (i = 0; choices[i]; i++)
	{
	  if (key == choices[i])
	    {
	      printf ("\n");		/* force a new line */
	      catclose (cat);
	      exit (i+1);		/* exit starts counting at 1 */
	    }

	  if ((!case_sensitive) && (toupper(key) == toupper(choices[i])))
	    {
	      printf ("\n");		/* force a new line */
	      catclose (cat);
	      exit (i+1);		/* exit starts counting at 1 */
	    }
	} /* for */

      beep();
    } /* while */
}

void
usage (nl_catd cat)
{
  char *s1, *s2;

  s1 = catgets (cat, 0, 0, "Waits for the user to press a key, from a list of choices");
  printf ("CHOICE version 3.6, Copyright (C) 1994--2002 Jim Hall, jhall@freedos.org\n");
  printf ("%s\n", s1);

  s1 = catgets (cat, 1, 0, "Usage:");
  printf ("%s ", s1);

  s1 = catgets (cat, 0, 1, "choices");
  s2 = catgets (cat, 0, 2, "text");
  printf ("CHOICE [ /A | /B ] [ /C[:]%s ] [ /N ] [ /S ] [ /T[:]c,nn ] [ %s ]\n", s1, s2);

  s2 = catgets (cat, 0, 8, "Sound an alert at prompt");
  printf ("  /A  -  %s\n", s2);
  printf ("  /B  -  %s\n", s2);

  s2 = catgets (cat, 0, 3, "Specifies allowable keys.  Default is:");
  printf ("  /C[:]%s  -  %s ", s1, s2);

  s2 = catgets (cat, 3, 0, "yn");
  printf ("%s\n", s2);

  s1 = catgets (cat, 0, 4, "Do not display the choices at end of prompt");
  printf ("  /N  -  %s\n", s1);

  s1 = catgets (cat, 0, 5, "Be case-sensitive");
  printf ("  /S  -  %s\n", s1);

  s1 = catgets (cat, 0, 6, "(ignored, for compatilibity with MS-DOS)");
  printf ("  /T[:]c,nn  -  %s\n", s1);

  s1 = catgets (cat, 0, 7, "The text to display as a prompt");
  s2 = catgets (cat, 0, 2, "text");
  printf ("  %s  -  %s\n", s2, s1);
}
