/** 
**  TALLOC.C
**
**  lean_and_mean malloc()/free implementation
**  by tom ehlert, te@drivesnapshot.de
**
**  please be careful:
**
**  this is only slightly tested and has NO ERRORCHECCKING AT ALL
**  no internal checking. no stack checking. nothing !!
**
**  use it only, if your programs are already debugged !!
**/

#pragma option -zD_BSSEND         /* BSS segment */
#pragma option -zBENDBSS          /* BSS class */


#ifndef __TURBOC__
   #error this code requires funny segment handling.
          currently done only for turboc !!!
#endif



#define STATIC static

  char alloc_bottom[1];

#define BUSY        1               /* Bit set if memory block in use*/
#define isbusy(x)   (x&BUSY)


/**
*** _memavl()
***   return max. memory available
***   Q & D
**/

#define dbprintf(x)
//#define printf getch() != ' ' ? exit(0) : printf

char *malloc(unsigned length)
    {
    char    *akt,*next,
            *ltop = (char*)&akt - 0x200;
    unsigned alen;        

    length = (length + 3) & ~BUSY;

    akt  = alloc_bottom;


    
    
    for (;;)
      {

retest:
		dbprintf(("follow [%x] = %x\n",akt, *(short*)akt));
		
		
		if (*(short*)akt == 0)	
			{                   
									/* end of initialized memory */
        
        	if (ltop - akt < length)
	        	return (void*)0;
	        	
	        *(short*)akt = length | BUSY;
	        *(short*)(akt+length) = 0;

        	dbprintf(("set [%x] = %x\n",akt,*(short*)akt));
	        
	        return akt+2;	
			}
		

    	next = akt + ((*(short*)akt) & ~BUSY);

        if (!isbusy(*akt))     
			{        
	        if (!isbusy(*next))		/* merge 2 blocks */
	        	{
	        	if (*(short *)next == 0)
	        		{
	        		*(short*)akt = 0;
	        		goto retest;
	        		}
	        	
	        	*(short*)akt += *(short*)next;
	        	goto retest;
	        	}
			}	        	                               

        if (!isbusy(*akt))     
	        if (*(short*)akt >= length)  /* try to split */
	        	{
	 	        if (*(short*)akt > length)  /* split */
	        		{
        			*(short*)(akt+length) = *(short*)akt - length;
		        	}
		        
	        	*(short*)akt = length | BUSY;
	        	dbprintf(("set [%x] = %x\n",akt,*(short*)akt));
	        	
		        return akt+2;
		        }
				
		
        akt += (*(short*)akt) & ~BUSY;            /* next block       */
        } 
}

/**
** reset busy-bit
**/

void free(void *ptr)
    {
    if (ptr)
         ((short *) ptr)[-1] &= ~BUSY;
    }

#ifdef TALLOC_NEED_REALLOC

/* there isn't often need for realloc ;)
*/

void* realloc(void *ptr,unsigned newlength)
	{
	unsigned oldlength = ((short*)ptr)[-1] & ~BUSY;
	void *newptr;
	
	newptr = malloc(newlength);
	
	if (newptr == (void*)0)
		{
		if (newlength <= oldlength)
			return ptr;
		}
	else {
		memcpy(newptr,ptr,oldlength);
		}		

	free(ptr);
	return newptr;
	}
    
#endif /* ifdef TALLOC_NEED_REALLOC */
    

#ifdef TEST

#include <STDIO.H>


int gallocated = 0;

void *testalloc(int length)
{     
	void *p;

	printf("alloc %x bytes - ",length);
	
	p = malloc(length);
	
	if (p) gallocated += length,printf("at %x - sum=%x\n",p,gallocated);
	else   printf("failed\n");
	return p;
}
void testfree(void* p)
{   
    gallocated -= ((short*)p)[-1] & ~BUSY; 
	printf("free %x \n",p);
	
	free(p);
}



main()
{     
	char *s1,*s2,*s3,*s4,*s5,*s6;
	unsigned size;
	
	s1 = testalloc(1);
	s2 = testalloc(2);
	s3 = testalloc(0x10);
	s4 = testalloc(0x100);
	s5 = testalloc(0x1000);
	s6 = testalloc(0xfff0);
	
	testfree(s3);
	s3 = testalloc(6);
	testfree(s2);
	testalloc(8);
	
	
	for(size = 0xe000; size;)
		{
		if (testalloc(size))
			;
		else
			size >>= 1;
		}	


	testfree(s1);
	testfree(s5);	
	testfree(s4);	
	testfree(s6);	

	
	return 1;
}
#endif