/*
Ŀ
jzinsint.c								     
Install an interrupt into the assembler routine jzinthnd.c		     
You must declare the ffunction argument as global in the main routine:      
int inthandler();							     
main() 								     
{									     
   jzinsint(5,inthandler);	( steals the print screen interrupt )	     
}									     
									     
int inthandler()							     
{									     
  jzscrprn("inside the interrupt handler",24,0,31);                         
}									     
									     
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950 		     

*/


#include <jaz.h>			/* define macros and types */
extern int jzinthnd();			/* asm interrupt handler */
extern int far gdseg,gfunction; 	/* public vars defined in jzinthnd.asm*/

jzinsint(fintnum,ffunction)
int fintnum;
int (*ffunction)();
{
  TVECTOR wvec;
  wvec.segment = getcs();		/* get code segment */
  wvec.offset = (int) jzinthnd; 	/* point to asm routine */
  gdseg = getds();			/* save data segment for int handler */
  gfunction = (int) ffunction;		/* set variable for call [bx] */
  cli();				/* don't allow interrupts */
  jzsetint(fintnum,wvec);		/* call dos to set interrupt */
  sti();				/* turn interrupts back on */
}
