/*
Ŀ
jzgetcls.c								     
Return a	 cluster given a two byte cluster word from a lookup	     
into the file allocation table.					     
									     
See jzgetfat.dmo for examples						     
									     
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950 		     

*/

jzgetcls(ffat , fcluster , fbigfat)
char *ffat;
int fcluster;
int fbigfat;			/* true on 20mg or > disks */
{
  int wcluster,woddeven;

  if (fbigfat) {
    memcpy(&wcluster , ffat + (fcluster << 1),2);  /* get cluster */
    return(wcluster);
  }

  woddeven = 3 * fcluster;

  memcpy(&wcluster , ffat + (woddeven >> 1),2);  /* get cluster */

  if (woddeven & 1)
    return(wcluster >> 4);	       /* get rid of low nibble */
  else
    return(wcluster & 0xFFF);	       /* get rid of high nibble */
}
