/*
 *	dos\get.c		get disk parameters
 *
 *	Copyright (C) 1998, Gregg Jennings
 *
 *	v0.1	12-Apr-1998, grejen
 */

#include <stdlib.h>
#include <string.h>

#include "dosio.h"
#include "../d_disk.h"		/* struct d_stat */
#include "../d_lib.h"		/* disk_read() */

static int boot_parameters(int disk, int secsize, struct DEVICEPARAMS *dp);

/*
 * disk_get_params      get disk (DOS) parameters
 *
 * Note: This function works on NTFS drives.
 *
 */

extern int disk_getparams(int disk, struct DEVICEPARAMS *dp)
{
    memset(dp,0,sizeof(struct DEVICEPARAMS));

    /* TODO: check for remote */
    /* TODO: check for removable */

    dp->special = 1;

    if (dos_ioctl(DOS_DEV_IOCTL,DOS_MINOR_GET_DEVICE,disk,dp) != -1) {

        /* ds->d_media = 1; */

        if (boot_parameters(disk,512,dp) != -1) {
            return 0;
        }
    }

    /* dp->cylinders = max_track(dp); */

    return -1;
}

/*
 * disk_getmedia        get MID structure
 *
 * Note: This function does not get the actual filesys and vollabel
 *       MID structure members under windows NT (filesys is always
 *       "FAT" or "CDFS" and the vollabel is either all spaces or
 *       the volume label with spaceas as the middle four characters.
 *
 *       This function reads CD-ROM and NTFS drives under Windows NT.
 *
 */

extern int disk_getmedia(int disk, struct MID *mid)
{
    memset(mid,0,sizeof(struct MID));

    if (dos_ioctl(DOS_DEV_IOCTL,DOS_MINOR_GET_MEDIA,disk,mid) != -1)
        return 0;

    return -1;
}


/*
 * boot_parameters		get disk (BOOT) parameters
 *
 */

static int boot_parameters(int disk, int secsize, struct DEVICEPARAMS *dp)
{
int i;
char *buf;
struct BOOT boot;

	if ((buf = malloc(secsize)) == NULL)
		return 0;

	i = disk_read(disk,0,buf,1,secsize);

	if (i == -1) {
		memcpy(&boot,buf,sizeof(struct BOOT));
		memcpy(&dp->sec_size,&boot.sec_size,sizeof(struct BPB));
	}

	free(buf);
	return i;
}
