/*
 *	dos\gcc\rdump.c 	display 80x86 registers
 *
 *	Copyright (C) 1998, Gregg Jennings
 *
 *	1.1 23-Sep-1998 greggj	dosmem.h
 */

#include <stdio.h>

#include "dosmem.h"

#define O_MASK 0x0800
#define D_MASK 0x0400
#define I_MASK 0x0200
#define S_MASK 0x0080
#define Z_MASK 0x0040
#define A_MASK 0x0010
#define P_MASK 0x0004
#define C_MASK 0x0001

char *over[]={"NV","OV"};
char *dire[]={"UP","DN"};
char *inte[]={"DI","EI"};
char *sign[]={"PL","NG"};
char *zero[]={"NZ","ZR"};
char *auxi[]={"NA","AC"};
char *pari[]={"PO","PE"};
char *carr[]={"NC","CY"};

/*
 * dpmi_dump	display 80x86 registers for the DPMI calls
 *
 */

extern void dpmi_dump(__dpmi_regs *regs)
{
int f;

	fprintf(stderr,"\n");
	fprintf(stderr,"EAX=%08lX  EBX=%08lX  ECX=%08lX  EDX=%08lX  ",
			regs->d.eax,regs->d.ebx,regs->d.ecx,regs->d.edx);
	fprintf(stderr,"\n");
	fprintf(stderr,"ESI=%08lX  EDI=%08lX  EBP=%08lX  DS=%04X  ",
		   regs->d.esi,regs->d.edi,regs->d.ebp, regs->x.ds);
	f = regs->x.flags;
	fprintf(stderr,"%s ",over[(f&O_MASK) ? (1) : (0)]);
	fprintf(stderr,"%s ",dire[(f&D_MASK) ? (1) : (0)]);
	fprintf(stderr,"%s ",inte[(f&I_MASK) ? (1) : (0)]);
	fprintf(stderr,"%s ",sign[(f&S_MASK) ? (1) : (0)]);
	fprintf(stderr,"%s ",zero[(f&Z_MASK) ? (1) : (0)]);
	fprintf(stderr,"%s ",auxi[(f&A_MASK) ? (1) : (0)]);
	fprintf(stderr,"%s ",pari[(f&P_MASK) ? (1) : (0)]);
	fprintf(stderr,"%s ",carr[(f&C_MASK) ? (1) : (0)]);
	fprintf(stderr,"\n");
}
