/*
 *  d_lib.c     auxillary functions
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

#include "d_disk.h"


/*
   dir_sectors = d_ndir / (d_bsize / 32);
   data_sector = (d_ftsize * d_ftables) + dir_sectors + d_bres-1;
   dir_sector = (d_ftsize * d_ftables) + d_bres;
   cluster_size = d_bsize * d_usize;
   num_clusters =
      ((d_bnum - (d_ftsize * d_ftables) - dir_sectors-1) / d_usize)+1;
*/

/*
 * clustersector    convert logical sector number to the sector
 *                  within the cluster number
 */

extern long clustersector(long sector, struct d_stat *ds)
{
    if (sector < ds->d_dsec)
        return 0;
    return (sector - ds->d_dsec) % ds->d_usize;
}

/*
 * clustertosector  convert cluster number to logical sector number
 *
 */

extern long clustertosector(long cluster, struct d_stat *ds)
{
    return ((cluster-2) * ds->d_usize) + ds->d_dsec;
}

/*
 * sectortocluser   convert the logical sector number to the
 *                  cluster number
 */

extern long sectortocluster(long sector, struct d_stat *ds)
{
    if (sector < ds->d_dsec)
        return 0;
    return ((sector - ds->d_dsec) / ds->d_usize) + 2;
}
