/*
 *  d_error.h   d_errno values
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#ifndef D_ERROR_H
#define D_ERROR_H

typedef enum D_ERRNO_VALUES {
    D_EDOS = -1,
    D_ENONE = 0,
    D_ENOMEM,
    D_ERDONLY,
    D_EHANDLE,              /* invalid disk handle */
    D_EINVAL,               /* invalid argument */
    D_EUNIT,                /* unknown unit */
    D_ENREADY,              /* drive not ready */
    D_ECRC,                 /* data error (CRC) */
    D_EREQ,                 /* bad driver request structure length */
    D_ESEEK,                /* seek error */
    D_ETYPE,                /* unknown media type */
    D_ESECNO,               /* sector not found */
    D_EWRITE,               /* write fault */
    D_EREAD,                /* read fault */
    D_EGENF,                /* general failure */
    D_EINVCH,               /* invalid media change */
    D_EINVCMD,              /* invalid command */
    D_EINVMED,              /* invalid media */
    D_EADDR,                /* address mark not found */
    D_ESEEKF,               /* seek failure */
    D_ECONTRL,              /* controller failure */
    D_EWPROT,               /* disk write protected */
    D_ERESET,               /* reset failure */
    D_EDMA,                 /* DMA error/overrun */
    D_EBAD,                 /* bad sector/track detected */

    D_EUNKNOWN
} D_ERROR;


int dskerr_to_errno(int error, int iotype);

#endif
