/*
 *  d_disk.h    library data definitions
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#ifndef D_DISK_H
#define D_DISK_H

#ifndef TYPES_H
#include "types.h"
#endif

/* access modes */

#define D_RDONLY    0
#define D_RDWR      1
#define D_BINARY    2


#define D_IFREM     0x10000         /* if removable */
#define D_IROM      0x20000         /* read only media */
/* ... more? */
#define D_ISREM(m)  (m&D_IFREM)

#define D_FSID_LEN  12
#define D_DEV_LEN   12

struct d_stat {
    char d_fsid[D_FSID_LEN];/* file system id */
    char d_dev[D_DEV_LEN];  /* disk ID */
    long d_ino;             /* disk serial number */
    long d_mode;            /* mode of access to disk */
    long d_atime;           /* time of last access */
    long d_mtime;           /* time of last data modification */
    long d_ctime;           /* time of last status change */
    long d_size;            /* total size in bytes */
    long d_bsize;           /* sector size in bytes */
    long d_bnum;            /* number of sectors */
    long d_bres;            /* number of reserved sectors */
    long d_bhid;            /* number of hidden sectors */
    long d_usize;           /* allocation unit (cluster) size in sectors */
    long d_units;           /* number of allocation units */
    long d_ufree;           /* number of free allocation units */
    long d_ftables;         /* number of allocation tables */
    long d_ftsize;          /* allocation table size in sectors */
    long d_ndir;            /* root dir entries */
    long d_dsecs;           /* number of directory sectors */
    long d_dsec;            /* first data sector (start of first cluster) */
    long d_ptracks;         /* physical number of tracks */
    long d_pheads;          /* physical number of heads */
    long d_psecs;           /* physical number of sectors per track */
    long d_media;           /* media type */
};

extern int d_errno;

extern int d_open(const char *drv, int mode);
extern int d_close(int dd);
extern long d_tell(int dh);
extern long d_lseek(int dh, long offset, long whence);
extern int d_read(int dh, void LARGE *buf, unsigned int nsecs);
extern int d_write(int dh, void LARGE *buf, unsigned int nsecs);
extern int d_stat(const char *root, struct d_stat *buf);
extern int d_hstat(int dh, struct d_stat *buf);
extern void d_perror(const char *msg);
extern int d_bsize(int dh);

#endif
