/***
*setup.c - setup
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Initialization.
*
*Notice:
*   This progam can be distributed only if in accordance with the DPU
*   Software License. (see DPU.TXT or contact the author for a copy).
*   http://www.diskwarez.com/
*******************************************************************************/

/*
   Versions:

   3.9   08-Aug-1998    bumped minor version number for fix in DIRENT.C
   3.8   20-Jul-1998    bumped minor version number for fix in FILES.C
   3.7   02-Jul-1998    __GNUC__; _winmajor, _winminor
   3.6   21-Apr-1998    fixed current/login drive error in startup();
                        bumped minor version number again
   3.5   07-Apr-1998    bumped minor version number because of DISKIO.C
   3.4   12-Jan-1998    fixed INI file lookup; removed Save/Restore; added
                        gettmpdir(); changed the order of INI file search
   3.3   04-Jan-1998    moved get_volume() into diskio.c; dos_ver;
                        removed save file stuff; added _getcwd() for ini file
   3.2   28-Nov-1997    enhanced startup drive checking; removed
                        underscores from some local function names
   3.1   12-Sep-1996    "%r"
   3.0   18-Nov-1995    cleaned up the setting of `volume'
   2.9   31-Oct-1995    fixed argument switch handling
   2.8   25-Jun-1995    added another level to the version number
   2.7   15-Dec-1994    corrected Processor ID equate order
   2.6   09-Nov-1994    general cleaning, comments,
   2.5   04-Sep-1994    consolodated all extern references.
                        removed some code in setup() and startup()
                        and placed into functions.
   2.4   18-Apr-1994    cleaned up extern defs
   2.3   09-Mar-1994    hugefree() file/clusters, bump to revision
   2.2   03-Feb-1994    added startup()
   2.1   04-Jan-1994    added get_volume()

   Release Notes:

   Every program (well, most) has to set things up before actually
   doing things. This figures out where we are, reads the .INI file,
   etc. Contains the version number (which I call serial number;
   please do not change it's format unless you have a better idea
   and inform me of it!) and copyright notice.

   Programming Notes:

   The logdisk() functions return DISK_OK for no errors, less than
   DISK_OK for warnings, and greater than DISK_OK for unrecoverable
   errors.  I forgot this once and totally messed things up!

*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include <direct.h>
#ifdef __BORLANDC__
#include <conio.h>
#endif

#include "disked.h"
#include "init.h"
#include "diskio.h"
#include "int2f.h"               /* winver() */
#include "int24.h"               /* DOS critical error handler */
#include "files.h"
#include "mylib.h"
#include "alloc.h"
#include "error.h"
#include "dirent.h"
#include "direct.h"
#include "console.h"

/* globals referenced here

   All of the DISKED configuration switches (mixed case
   identifiers), all of the "start-up" variables (for
   initial sector position, control switches.
   Some of the DISKIO globals.

   error, err_msg[]        ERROR.C
   enum DISKIO_RETURNS     DISKIO.H
   comspec[],promptvar[]   DISKED.C

   (probably more)
*/

/* globals defined here */

const char * const Version=" 3.2.5"

#ifdef _QC                                /* Compiler ID */
"Q"                                       /*  keep track of compiler */
#elif defined(__BORLANDC__)               /*  for BUGZZZZ! */
"B"
#elif defined(_MSC_VER)
"M"
#elif defined(__WATCOMC__)
"W"
#elif defined(__GNUC__)
"G"
#else
"X"                                      /* put others here and below */
#endif

/* Processor ID, note order */

#if defined(_M_I586) || defined(__586__)
"i586";
#elif defined(_M_I486) || defined(__486__)
"i486";
#elif defined(_M_I386) || defined(__386__)
"i386";
#elif defined(_M_I286) || defined(__286__)
"i286";
#elif defined(_M_I8086) || defined(_M_I86)
"i86";
#elif defined(__GNUC__)
"i386";
#else
"x86";
#endif

/* internal data */

const char * const Author="Gregg Jennings";
const char * const Title="DISKED - The DISK EDitor";
const char * const Copyr="(c) 1989-1998, All rights reserved";

static const char *disked_ini="DISKED.INI";
static int min_mem;                    /* for running with an IDE */
static int find_flag;                  /* find string arg */
static char set_file[_MAX_PATH];       /* file being set-to/tracked */

/* internal functions */

static void setupmem(void);
static void setinifile(char *arv);
static void programargs(char **argv, int *dsk);
static int getdriveinfo(int *drives, int *number);
static void dofind(void);
static void doset(int cdisk);
static int dofiles(void);
static void quit(int e);

/***
*setup   -  sets up everything
*
****/

extern int setup(char **argv, int drives[], int *dsk)
{
int i,c,cdisk;

   /* preset all non-init-structure globals */

   /* even though MS and WC will set _os..., they get it wrong under NT */

   if ((i = dos_ver()) >= 0x500)
      i = dos_ver5();
   _osmajor = (unsigned short)i>>8;
   _osminor = (unsigned short)i&0xff;

   if ((i = winver()) > 0) {
      _winmajor = (unsigned short)i>>8;
      _winminor = (unsigned short)i&0xff;
   }

   write_to = FALSE;                /* global booleans */
   files_indexed = FALSE;
   Signon = TRUE;
   big_screen = FALSE;

   byte_cnt = 0;                    /* global object counters */
   n_files = 1;
   n_dirs = 1;

   find_flag = min_mem = 0;         /* start-up flags */
   set_sector = -1L;
   dir_cluster = 0;
   set_file[0] = '\0';

   memset(tagged,0,sizeof(tagged));

   /* get drive info -- set current drive and get drive count */

   cdisk = *dsk = getdriveinfo(drives,&max_drive);

   setinifile(*argv);               /* find ini file location */
   initialize(ini_file);            /* initialize the world */

   initvideo(Output);               /* setup video stuff */

#ifndef __GNUC__
   _harderr(hhandler);              /* capture INT 24 handler */
#endif

   programargs(argv,dsk);           /* check command line parameters */
                                    /* set disk to use if an arg */
   if (!drives[*dsk])
   {
      if (*dsk == cdisk)
         abort();                   /* should never happen... */

      print("No Drive %c: Use Current?",*dsk+'@');
      if ((c = input()) != 'y' && c != 'Y')
         exit(2);
      *dsk = cdisk;
   }

   return cdisk;
}

/***
*startup() -   login drive and do startup stuff like index files,
*              set to particular spot, etc.
*
****/

extern int startup(unsigned int cdisk, unsigned int ddisk)
{
int c;
DISKIO_STATUS status;

   /* login drive and if error find out what to do */

   while ((status = logdisk(ddisk)) > DISK_OK)
   {
      printerror(Debug);
      if (ddisk == cdisk)                    /* if disk is current disk */
         exit(2);                            /* just quit */

      print(" %c: Use current? (or Retry) ",ddisk+'@');

      if ((c = input()) == 'y' || c == 'Y')  /* use current drive ? */
         ddisk = cdisk;                      /*  yes, try it */
      else if (tolower(c) != 'r')            /* try again ? */
         exit(0);                            /*  no, quit */
      output('\n');
   }

   /* allocate memory for sector buffers and file buffer */

   setupmem();

   /*
      First do Special Commands which bypass normal start-up sequence
      only one for now: /f{text}.  Note that the order of /f and +|-f
      on the command line is followed.
   */

   if (find_flag)             /* find text via command line */
   {
      dofind();
   }

   /* end of Special Commands */

   else
   {
      if (Signon == TRUE)
         disptext(signon_text);     /* signon text */

      if (Files > 0)
         dofiles();                 /* index files */

      else if (Signon == TRUE)      /* use the delay of dofiles() */
      {                             /*  for the pause */
         pause();
         output('\n');
      }

      doset(cdisk);                 /* find out what sector to start at */
   }

   return status;
}

/***
*newdisk() - consolated disk change stuff
*
****/

extern int newdisk(int tempd)
{
int i;
unsigned int temps;

   temps = sec_size;             /* save current sector size */
   savesector();                 /* and sector data */
   if ((i = logdisk(tempd)) > DISK_OK)
   {
      restoresector();
      disk_moved = 0;
      return 0;                  /* RETURN */
   }

   drivestatus(i);

   if (temps != sec_size)        /* new sector size */
   {
       sec_buf = newalloc(sec_buf,sec_size*sizeof(char));
       if (sec_buf == NULL)
       {
           print("\nReallocation Failure.\n");
           print("Sorry, but I am too confused to continue...\n");
           exit(3);
       }
       sec_bufp = (UINT32)sec_buf;
       save_sec  = newalloc(save_sec,sec_size*sizeof(char));
       spare_sec = newalloc(spare_sec,sec_size*sizeof(char));
   }

   n_files = 1;                  /* setup for files */
   n_dirs = 1;

   if (Files)                    /* if to index them */
   {
      if (files_indexed)         /* if already */
      {
         hugefreep(clusters);    /* free them first */
         hugefreep(files);
      }
      dofiles();
   }

   set_sector = -1L;             /* kill original start-sector */

   if (Home)
      rootsector();
   else
   {
      if (log_sector >= num_sectors)
         lastsector();
      else
         readsector();
   }

   return 1;
}

/* drivestatus - display warning (extern to DISKIO.C due to print()) */

extern void drivestatus(DISKIO_STATUS status)
{
   if (removable && status == DISK_USE_DPB)    /* floppy BOOT record bad */
      print("\nInvalid BOOT record. Using DPB.");
   if (!removable && status == DISK_USE_BOOT)  /* non-floppy no DPB available */
      print("\nDPB not supported (ramdrive?)");
}

/* gettmpdir  -  copies dirspec to tmpdir; % delimted get from environment */

extern void gettmpdir(char *tmpdir, char *dirspec)
{
char *tmp;
char var[FILENAME_MAX];

   if (dirspec[0] == '%')
   {
      strcpy(var,&dirspec[1]);
      if (var[strlen(var)-1] == '%')
         var[strlen(var)-1] = '\0';
      if ((tmp = getenv(var)) != NULL)
         strcpy(tmpdir,tmp);
      else
         *tmpdir = '\0';
   }
   else
      strcpy(tmpdir,dirspec);

   if (tmpdir[strlen(tmpdir)-1] == ':')
      strcat(tmpdir,"\\");
}


/* internal functions */

/***
*getdriveinfo  -  makes a list of all valid drives, set the number
*                 of drives
* RETURNS current drive
*
****/

static int getdriveinfo(int *drives, int *num)
{
int i;
unsigned tempd,cdisk;

   *num = 0;                                 /* initialize */
   _dos_getdrive(&cdisk);                    /* get current drive */

   for (i = 0; i < MAX_DRIVE; i++)           /* loop to verify drives */
   {
      _dos_setdrive(i,&tempd);               /* try and set */
      _dos_getdrive(&tempd);                 /* see if it was set */
      if (i == (int)tempd)                   /* if it was set */
      {
         drives[i] = TRUE;                   /*  then the drive is real */
         ++(*num);                           /* increment count */
      }
      else
         drives[i] = FALSE;
   }
   _dos_setdrive(cdisk,&tempd);              /* reset current disk */

   return cdisk;
}

/***
*setinifile   -  Form the INI filespecs.
*
****/

static void setinifile(char *argv)
{
unsigned i;
char *tempc;
int notfound;

   strcpy(com_spec,getenv("COMSPEC"));        /* get where COMMAND.COM is */
   strcpy(prompt_var,"PROMPT=");
   strcat(prompt_var,getenv("PROMPT"));       /* change prompt for shell */
   strcat(prompt_var,"(DE)");
   _putenv(prompt_var);

   notfound = 0;

   if (exist(disked_ini))                          /* current directory */
   {
      _getcwd(ini_file,67);
      if (ini_file[strlen(ini_file)-1] != '\\')
         strcat(ini_file,"\\");
      strcat(ini_file,disked_ini);
   }
   else if ((tempc = getenv("INIT")) != NULL)      /* %INIT% directory */
   {
      strcpy(ini_file,tempc);
      if (ini_file[strlen(ini_file)-1] != '\\')
         strcat(ini_file,"\\");
      strcat(ini_file,disked_ini);
      notfound = !exist(ini_file);
   }
   if (notfound)                                   /* ARGV[0] */
   {
      strcpy(ini_file,argv);
      i = strlen(ini_file);
      ini_file[--i]='I';
      ini_file[--i]='N';
      ini_file[--i]='I';
   }

}

/* startup processes before prompt */

/***
*dofind -   Search for text specified on command line.
*           The complexity is due to whether or not to index the
*           files before or after seaching (command line order).
*
****/

static void dofind(void)
{
int i;

   rootsector();                 /* set to root */
   if (Display)
   {
      printc(Title);             /* display (centered) logo */
      printc(Copyr);             /*  instead of drive parameters */
   }
   if (Files && find_flag == 1)  /* index files first? */
      i = dofiles();
   else
      i = 1;
   if (error.num != -1)          /* was there an error? */
   {
      output('\n');
      printerror(Debug);
      output('\n');
   }
   if (i == 0 && Verify)
      getver(" find",MOV_YN);

   print("\nfind %s",findstr);

   if ((i = find(1,0,0)) >= 0)   /* find text */
   {
      print("found at %r",i);
   }
   if (Files && find_flag == 2)  /* index files now? */
      dofiles();
}

/***
*doset -   Set to the proper starting sector.  More complexity
*           due to command line arguments.
*
*  0.2   25-Nov-1995    changed `set_sector' setting
*  0.1   19-Mar-1995    changed set file for filetrack()
****/

static void doset(int cdisk)
{
int tempd;
long templ;
char tempstr[67];

   if (set_sector != -1L)                          /* set to a sector? */
   {
      setsector(set_sector);
   }
#ifndef __GNUC__
   else if (set_file[0] != '\0')                   /* set to file? */
   {
      if ((tempd = file_start(set_file)) != 0)     /* if found */
      {
         setcluster(tempd);                        /* set to first sector */
         if (Files)
         {
            int i;
            tempd = clusters[tempd];
            if (tempd != 0)
               if ((i = filetrack(gfile(tempd),tempd)) != 1)
                  print("file track error: %d",i);
         }
      }
      else
         rootsector();                             /* not found */
   }
#endif
   else if (Files && !Home)               /* if indexed files and not go home */
   {                                      /*  set to current directory */
      strcpy(tempstr,&cur_dir[2]);
      if ((tempd = findfile(tempstr)) != 0)
         setcluster(tempd);
      else
         rootsector();
   }
   else if (cdisk == cur_disk && _osminor != 0x32)
   {
                                          /* else goto current directory */
                                          /* if not WINNT */
#ifndef __GNUC__
      if ((templ = cwdstart()) == 0)
#endif
         templ = dir_sector;
      set_sector = templ;
      dir_cluster = sectortocluster(templ);
      setsector(templ);
   }
   else
      rootsector();
}

/***
*dofiles   -  Index the files.
*
****/

static int dofiles(void)
{
   if (Display)
      print("\nindexing...");
   files_indexed = Files = initfiles();
   if (Display)
      clreol();
   return files_indexed;
}

/***
*setupmem   -
*
****/

#ifndef __GNUC__
#define MIN_DATABUF  8192U
#define DEF_DATABUF  65024U
#define DECREMENT_SIZE    512U
#else
#define MIN_DATABUF  8192U
#define DEF_DATABUF  (1000U*1024U)
#define DECREMENT_SIZE    1024U
#endif

static void setupmem(void)
{
unsigned int u;

   /*
      Yeah I can make it a long and get a huge pointer for a really
      large buffer, but so far that large of a buffer has not been
      needed.  Next time Im bored...
   */

   /* try and get memory */

   for (u = (min_mem) ? MIN_DATABUF : DEF_DATABUF ; ; u -= DECREMENT_SIZE)
      if ((data_buf = (unsigned char *)alloc(u,sizeof(char)))!=NULL)
         break;
   if (u < 512U*10U)
      quit(NO_MEM);
   max_bytes = u;

   /****** can only alloc sector buffer if sector size is known ******/

   if ((sec_buf = alloc(sec_size,sizeof(char))) == NULL)
      quit(NO_MEM);

   if ((save_sec = alloc(sec_size,sizeof(char))) != NULL)
      if ((spare_sec = alloc(sec_size,sizeof(char))) == NULL)
         freep(save_sec);

   sec_bufp = (UINT32)sec_buf;         /* make a copy of buffer pointer */
}


static void quit(int e)
{
   print(err_msg[e]);
   exit(e);
}

/***
*programargs  -  Check command line arguments, set global prameters etc.
*
****/

static void programargs(char **argv, int *dsk)
{
int c;

   if (*++argv)
   {
      do
      {
embedded_sw:
         c = tolower(**argv);
         if (c == '-')                 /* turn things off */
         {
            switch (*++*argv)
            {
               case '?':
                  goto Help;
                  break;
               case 'D': Debug=FALSE; break;
               case 't': Translate=FALSE; break;
               case 'f': Files=FALSE;   break;
               case 'h': Home=FALSE;    break;
               default:  break;
            }
         }
         else if (c == '/')            /* do/set things */
         {
            c = *++*argv;
            switch (c)                 /* non-argument switches */
            {                          /*  they all `continue' */
               case '\0':
                  continue;
               case '@':
                  Signon = !Signon;
                  continue;
               case 'h':               /* help ! */
               case '?':
Help:             printc(Title);       /* display (centered) logo */
                  printc(Version);
                  printc(Copyr);
                  disptext(com_line_text);
                  exit(0);
               case 'm':               /* minimize memory */
                  min_mem = 1;
                  continue;
               case '5':
                  big_screen = 1;
                  continue;
            }

            /* "argument" switches -- first check for argument */

            ++*argv;                   /* next character */
            if (**argv == '\0')        /* if null check next argument */
            {
               ++argv;
               if (*argv == NULL)
                  break;               /* break out of do-while */
            }
            if (strchr("/+-\\",**argv))   /* oops, not arg, another switch */
               goto embedded_sw;          /* do a "re-do" */

            switch (c)
            {
               case 's':
                  switch(**argv)
                  {
                     case 'B':
                        set_sector = 0;
                        break;
                     case 'F':
                        set_sector = reserved_secs + 1;
                        break;
                     default:
                        if (isdigit(**argv))
                           set_sector = atoi(*argv);
                        if (isalpha(**argv))
                           strcpy(set_file,*argv);
                        break;
                  }
                  break;
               case 'f':               /* find string arg */
                  find_flag = 1;
                  strcpy(findstr,*argv);
                  break;
            }
         }
         else if (c == '+')            /* turn things on */
         {
            switch (*++*argv)
            {
               case 'D': Debug = TRUE; break;
               case 't': Translate = TRUE; break;
               case 'f':
                  if (find_flag == 1)
                     find_flag = 2;          /* index files AFTER find() */
                  Files = TRUE;
                  break;
               case 'h': Home = TRUE; break;
            }
         }
         else if (isalpha(c))                /* disk drive letter */
         {
             *dsk = toupper(**argv)-'@';
         }
      } while (*++argv);
   }
}
